/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import clover.it.unimi.dsi.fastutil.booleans.AbstractBooleanIterator;
import clover.it.unimi.dsi.fastutil.booleans.BooleanCollection;
import clover.it.unimi.dsi.fastutil.booleans.BooleanIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSet;
import clover.it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLong2BooleanMap
implements Long2BooleanMap,
Serializable {
    protected boolean defRetValue;

    protected AbstractLong2BooleanMap() {
    }

    public void setDefRetValue(boolean rv) {
        this.defaultReturnValue(rv);
    }

    public boolean getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(boolean rv) {
        this.defRetValue = rv;
    }

    public boolean defaultReturnValue() {
        return this.defRetValue;
    }

    public boolean put(long key, boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(long key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        long k = (Long)ok;
        return this.containsKey(k) ? Boolean.valueOf(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        long k = (Long)ok;
        boolean v = this.put(k, (Boolean)ov);
        return this.containsKey(k) ? Boolean.valueOf(v) : null;
    }

    public Object remove(Object ok) {
        long k = (Long)ok;
        boolean v = this.remove(k);
        return this.containsKey(k) ? Boolean.valueOf(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Boolean)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Long)ok);
    }

    public boolean containsValue(boolean v) {
        return ((BooleanCollection)this.values()).contains(v);
    }

    public boolean containsKey(long k) {
        return ((LongSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Long2BooleanMap) {
            while (n-- != 0) {
                Long2BooleanMap.Entry e = (Long2BooleanMap.Entry)i.next();
                this.put(e.getLongKey(), e.getBooleanValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractLongSet(){

            public boolean contains(long k) {
                return AbstractLong2BooleanMap.this.containsKey(k);
            }

            public int size() {
                return AbstractLong2BooleanMap.this.size();
            }

            public LongIterator longIterator() {
                return new AbstractLongIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2BooleanMap.this.entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Long2BooleanMap.Entry)this.i.next()).getLongKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractBooleanCollection(){

            public boolean contains(boolean k) {
                return AbstractLong2BooleanMap.this.containsValue(k);
            }

            public int size() {
                return AbstractLong2BooleanMap.this.size();
            }

            public BooleanIterator booleanIterator() {
                return new AbstractBooleanIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2BooleanMap.this.entrySet().iterator();
                    }

                    public boolean nextBoolean() {
                        return ((Long2BooleanMap.Entry)this.i.next()).getBooleanValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Long2BooleanMap.Entry e = (Long2BooleanMap.Entry)i.next();
            s.append(String.valueOf(e.getLongKey()));
            s.append("=>");
            s.append(String.valueOf(e.getBooleanValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Long2BooleanMap.Entry {
        protected long key;
        protected boolean value;

        public BasicEntry(Object key, Object value) {
            this.key = (Long)key;
            this.value = (Boolean)value;
        }

        public BasicEntry(long key, boolean value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Long(this.key);
        }

        public long getLongKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean getBooleanValue() {
            return this.value;
        }

        public boolean setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return this.setValue((Boolean)value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Long)e.getKey() && this.value == (Boolean)e.getValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ (this.value ? 1231 : 1237);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

