/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.ints;

import clover.it.unimi.dsi.fastutil.Lists;
import clover.it.unimi.dsi.fastutil.ints.AbstractIntList;
import clover.it.unimi.dsi.fastutil.ints.IntCollection;
import clover.it.unimi.dsi.fastutil.ints.IntCollections;
import clover.it.unimi.dsi.fastutil.ints.IntIterators;
import clover.it.unimi.dsi.fastutil.ints.IntList;
import clover.it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class IntLists {
    private IntLists() {
    }

    public static IntList singleton(int element) {
        return new Singleton(element);
    }

    public static IntList singleton(Object element) {
        return new Singleton((Integer)element);
    }

    public static IntList synchronize(IntList l) {
        return new SynchronizedList(l);
    }

    public static IntList synchronize(IntList l, Object sync) {
        return new SynchronizedList(l, sync);
    }

    public static IntList unmodifiable(IntList l) {
        return new UnmodifiableList(l);
    }

    public static class UnmodifiableList
    extends IntCollections.UnmodifiableCollection
    implements IntList,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final IntList list;

        protected UnmodifiableList(IntList l) {
            super(l);
            this.list = l;
        }

        public int getInt(int i) {
            return this.list.getInt(i);
        }

        public int set(int i, int k) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, int k) {
            throw new UnsupportedOperationException();
        }

        public int removeInt(int i) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(int k) {
            return this.list.indexOf(k);
        }

        public int lastIndexOf(int k) {
            return this.list.lastIndexOf(k);
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(IntList l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, List l) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, IntList l) {
            throw new UnsupportedOperationException();
        }

        public void getElements(int from, int[] a, int offset, int length) {
            this.list.getElements(from, a, offset, length);
        }

        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        public void addElements(int index, int[] a, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        public void addElements(int index, int[] a) {
            throw new UnsupportedOperationException();
        }

        public void size(int size) {
            this.list.size(size);
        }

        public ListIterator listIterator() {
            return IntIterators.unmodifiable((IntListIterator)this.list.listIterator());
        }

        public ListIterator listIterator(int i) {
            return IntIterators.unmodifiable((IntListIterator)this.list.listIterator(i));
        }

        public IntListIterator intListIterator() {
            return IntIterators.unmodifiable(this.list.intListIterator());
        }

        public IntListIterator intListIterator(int i) {
            return IntIterators.unmodifiable(this.list.intListIterator(i));
        }

        public List subList(int from, int to) {
            return new UnmodifiableList((IntList)this.list.subList(from, to));
        }

        public IntList intSubList(int from, int to) {
            return new UnmodifiableList(this.list.intSubList(from, to));
        }

        public boolean equals(Object o) {
            return this.collection.equals(o);
        }

        public int hashCode() {
            return this.collection.hashCode();
        }

        public int compareTo(Object o) {
            return this.list.compareTo(o);
        }

        public Object get(int i) {
            return this.list.get(i);
        }

        public void add(int i, Object k) {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object k) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int i) {
            throw new UnsupportedOperationException();
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }
    }

    public static class SynchronizedList
    extends IntCollections.SynchronizedCollection
    implements IntList,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final IntList list;

        protected SynchronizedList(IntList l, Object sync) {
            super(l, sync);
            this.list = l;
        }

        protected SynchronizedList(IntList l) {
            super(l);
            this.list = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getInt(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.getInt(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int set(int i, int k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int i, int k) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int removeInt(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.removeInt(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(int k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(int k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, IntCollection c) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(List l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(IntList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, List l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, IntList l) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.addAll(index, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getElements(int from, int[] a, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.getElements(from, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeElements(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                this.list.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElements(int index, int[] a, int offset, int length) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElements(int index, int[] a) {
            Object object = this.sync;
            synchronized (object) {
                this.list.addElements(index, a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void size(int size) {
            Object object = this.sync;
            synchronized (object) {
                this.list.size(size);
            }
        }

        public ListIterator listIterator() {
            return this.list.listIterator();
        }

        public ListIterator listIterator(int i) {
            return this.list.listIterator(i);
        }

        public IntListIterator intListIterator() {
            return this.list.intListIterator();
        }

        public IntListIterator intListIterator(int i) {
            return this.list.intListIterator(i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList((IntList)this.list.subList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IntList intSubList(int from, int to) {
            Object object = this.sync;
            synchronized (object) {
                return new SynchronizedList(this.list.intSubList(from, to), this.sync);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.collection.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int compareTo(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.compareTo(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.get(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int i, Object k) {
            Object object = this.sync;
            synchronized (object) {
                this.list.add(i, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object k) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.set(index, k);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int i) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.remove(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object o) {
            Object object = this.sync;
            synchronized (object) {
                return this.list.lastIndexOf(o);
            }
        }
    }

    public static class Singleton
    extends AbstractIntList
    implements Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        private final int element;

        private Singleton(int element) {
            this.element = element;
        }

        public boolean rem(int k) {
            throw new UnsupportedOperationException();
        }

        public boolean add(int k) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, int k) {
            throw new UnsupportedOperationException();
        }

        public int getInt(int i) {
            if (i == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        public int removeInt(int i) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(int k) {
            return k == this.element;
        }

        public boolean addAll(IntList c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, IntList c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(IntCollection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(List c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, List c) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int i, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int[] toIntArray() {
            int[] a = new int[]{this.element};
            return a;
        }

        public IntListIterator intListIterator() {
            return IntIterators.wrap(this.toIntArray());
        }

        public IntListIterator intListIterator(int i) {
            if (i > 1 || i < 0) {
                throw new IndexOutOfBoundsException();
            }
            IntListIterator l = IntIterators.wrap(this.toIntArray());
            if (i == 1) {
                l.next();
            }
            return l;
        }

        public IntList intSubList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            if (from != 0 || to != 1) {
                return Lists.EMPTY_LIST;
            }
            return this;
        }

        public int size() {
            return 1;
        }

        public void size(int size) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object clone() {
            return this;
        }
    }
}

