/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.ints;

import clover.it.unimi.dsi.fastutil.Arrays;
import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.HashCommon;
import java.io.Serializable;

public class IntArrays {
    private static final long ONEOVERPHI = 106039L;
    public static final int[] EMPTY_ARRAY = new int[0];
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private IntArrays() {
    }

    public static int[] ensureCapacity(int[] array, int length) {
        if (length > array.length) {
            int[] t = new int[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static int[] ensureCapacity(int[] array, int length, int preserve) {
        if (length > array.length) {
            int[] t = new int[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static int[] grow(int[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            int[] t = new int[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static int[] grow(int[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            try {
                int[] t = new int[newLength];
                System.arraycopy(array, 0, t, 0, preserve);
                return t;
            }
            catch (Error T) {
                System.err.println(newLength);
                throw T;
            }
        }
        return array;
    }

    public static int[] trim(int[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        int[] t = length == 0 ? EMPTY_ARRAY : new int[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static int[] setLength(int[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return IntArrays.trim(array, length);
        }
        return IntArrays.ensureCapacity(array, length);
    }

    public static int[] copy(int[] array, int offset, int length) {
        IntArrays.ensureOffsetLength(array, offset, length);
        int[] a = length == 0 ? EMPTY_ARRAY : new int[length];
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static int[] copy(int[] array) {
        return (int[])array.clone();
    }

    public static void fill(int[] array, int value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    public static void fill(int[] array, int from, int to, int value) {
        IntArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i = from; i < to; ++i) {
                array[i] = value;
            }
        }
    }

    public static boolean equals(int[] a1, int[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(int[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(int[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy,
    Serializable {
        private ArrayHashStrategy() {
        }

        public int hashCode(Object o) {
            if (o == null) {
                return 0;
            }
            if (o == HashCommon.REMOVED) {
                return HashCommon.REMOVED.hashCode();
            }
            int[] a = (int[])o;
            int i = a.length;
            int hashCode = -1;
            while (i-- != 0) {
                hashCode = 31 * hashCode + a[i];
            }
            return hashCode;
        }

        public boolean equals(Object a, Object b) {
            if (a == null) {
                return b == null;
            }
            if (a == HashCommon.REMOVED || b == HashCommon.REMOVED) {
                return a == b;
            }
            return IntArrays.equals((int[])a, (int[])b);
        }
    }
}

