/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.bytes;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import clover.it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import clover.it.unimi.dsi.fastutil.bytes.Byte2DoubleMap;
import clover.it.unimi.dsi.fastutil.bytes.ByteIterator;
import clover.it.unimi.dsi.fastutil.bytes.ByteSet;
import clover.it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import clover.it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import clover.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import clover.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractByte2DoubleMap
implements Byte2DoubleMap,
Serializable {
    protected double defRetValue;

    protected AbstractByte2DoubleMap() {
    }

    public void setDefRetValue(double rv) {
        this.defaultReturnValue(rv);
    }

    public double getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(double rv) {
        this.defRetValue = rv;
    }

    public double defaultReturnValue() {
        return this.defRetValue;
    }

    public double put(byte key, double value) {
        throw new UnsupportedOperationException();
    }

    public double remove(byte key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        byte k = (Byte)ok;
        return this.containsKey(k) ? new Double(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        byte k = (Byte)ok;
        double v = this.put(k, (Double)ov);
        return this.containsKey(k) ? new Double(v) : null;
    }

    public Object remove(Object ok) {
        byte k = (Byte)ok;
        double v = this.remove(k);
        return this.containsKey(k) ? new Double(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Double)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Byte)ok);
    }

    public boolean containsValue(double v) {
        return ((DoubleCollection)this.values()).contains(v);
    }

    public boolean containsKey(byte k) {
        return ((ByteSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Byte2DoubleMap) {
            while (n-- != 0) {
                Byte2DoubleMap.Entry e = (Byte2DoubleMap.Entry)i.next();
                this.put(e.getByteKey(), e.getDoubleValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractByteSet(){

            public boolean contains(byte k) {
                return AbstractByte2DoubleMap.this.containsKey(k);
            }

            public int size() {
                return AbstractByte2DoubleMap.this.size();
            }

            public ByteIterator byteIterator() {
                return new AbstractByteIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractByte2DoubleMap.this.entrySet().iterator();
                    }

                    public byte nextByte() {
                        return ((Byte2DoubleMap.Entry)this.i.next()).getByteKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractDoubleCollection(){

            public boolean contains(double k) {
                return AbstractByte2DoubleMap.this.containsValue(k);
            }

            public int size() {
                return AbstractByte2DoubleMap.this.size();
            }

            public DoubleIterator doubleIterator() {
                return new AbstractDoubleIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractByte2DoubleMap.this.entrySet().iterator();
                    }

                    public double nextDouble() {
                        return ((Byte2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Byte2DoubleMap.Entry e = (Byte2DoubleMap.Entry)i.next();
            s.append(String.valueOf(e.getByteKey()));
            s.append("=>");
            s.append(String.valueOf(e.getDoubleValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Byte2DoubleMap.Entry {
        protected byte key;
        protected double value;

        public BasicEntry(Object key, Object value) {
            this.key = (Byte)key;
            this.value = (Double)value;
        }

        public BasicEntry(byte key, double value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Byte(this.key);
        }

        public byte getByteKey() {
            return this.key;
        }

        public Object getValue() {
            return new Double(this.value);
        }

        public double getDoubleValue() {
            return this.value;
        }

        public double setValue(double value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Double(this.setValue((Double)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Byte)e.getKey() && this.value == (Double)e.getValue();
        }

        public int hashCode() {
            return this.key ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

