/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.tools.plugins;

import clover.com.lowagie.text.Document;
import clover.com.lowagie.text.pdf.PdfContentByte;
import clover.com.lowagie.text.pdf.PdfImportedPage;
import clover.com.lowagie.text.pdf.PdfReader;
import clover.com.lowagie.text.pdf.PdfWriter;
import clover.com.lowagie.tools.arguments.FileArgument;
import clover.com.lowagie.tools.arguments.LabelAccessory;
import clover.com.lowagie.tools.arguments.PdfFilter;
import clover.com.lowagie.tools.arguments.ToolArgument;
import clover.com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class Burst
extends AbstractTool {
    static {
        Burst.addVersion("$Id: Burst.java,v 1.10 2006/09/15 23:37:38 xlv Exp $");
    }

    public Burst() {
        FileArgument f = new FileArgument(this, "srcfile", "The file you want to split", false, new PdfFilter());
        f.setLabel(new LabelAccessory());
        this.arguments.add(f);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Burst", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Burst OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            File directory = src.getParentFile();
            String name = src.getName();
            name = name.substring(0, name.lastIndexOf(46));
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            int n = reader.getNumberOfPages();
            int digits = 1 + n / 10;
            System.out.println("There are " + n + " pages in the original file.");
            int i = 0;
            while (i < n) {
                int pagenumber = i + 1;
                String filename = String.valueOf(pagenumber);
                while (filename.length() < digits) {
                    filename = "0" + filename;
                }
                filename = "_" + filename + ".pdf";
                Document document = new Document(reader.getPageSizeWithRotation(pagenumber));
                PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(new File(directory, String.valueOf(name) + filename)));
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                PdfImportedPage page = writer.getImportedPage(reader, pagenumber);
                int rotation = reader.getPageRotation(pagenumber);
                if (rotation == 90 || rotation == 270) {
                    cb.addTemplate(page, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, reader.getPageSizeWithRotation(pagenumber).height());
                } else {
                    cb.addTemplate(page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                }
                document.close();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        Burst tool = new Burst();
        if (args.length < 1) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is more than one destfile.");
    }
}

