/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.rtf.document;

import clover.com.lowagie.text.PageSize;
import clover.com.lowagie.text.Rectangle;
import clover.com.lowagie.text.rtf.RtfElement;
import clover.com.lowagie.text.rtf.RtfExtendedElement;
import clover.com.lowagie.text.rtf.document.RtfDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfPageSetting
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] PAGE_WIDTH = "\\paperw".getBytes();
    private static final byte[] PAGE_HEIGHT = "\\paperh".getBytes();
    private static final byte[] MARGIN_LEFT = "\\margl".getBytes();
    private static final byte[] MARGIN_RIGHT = "\\margr".getBytes();
    private static final byte[] MARGIN_TOP = "\\margt".getBytes();
    private static final byte[] MARGIN_BOTTOM = "\\margb".getBytes();
    private static final byte[] LANDSCAPE = "\\lndscpsxn".getBytes();
    private static final byte[] SECTION_PAGE_WIDTH = "\\pgwsxn".getBytes();
    private static final byte[] SECTION_PAGE_HEIGHT = "\\pghsxn".getBytes();
    private static final byte[] SECTION_MARGIN_LEFT = "\\marglsxn".getBytes();
    private static final byte[] SECTION_MARGIN_RIGHT = "\\margrsxn".getBytes();
    private static final byte[] SECTION_MARGIN_TOP = "\\margtsxn".getBytes();
    private static final byte[] SECTION_MARGIN_BOTTOM = "\\margbsxn".getBytes();
    private int pageWidth = 11906;
    private int pageHeight = 16840;
    private int marginLeft = 1800;
    private int marginRight = 1800;
    private int marginTop = 1440;
    private int marginBottom = 1440;
    private boolean landscape = false;

    public RtfPageSetting(RtfDocument doc) {
        super(doc);
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(PAGE_WIDTH);
            result.write(this.intToByteArray(this.pageWidth));
            result.write(PAGE_HEIGHT);
            result.write(this.intToByteArray(this.pageHeight));
            result.write(MARGIN_LEFT);
            result.write(this.intToByteArray(this.marginLeft));
            result.write(MARGIN_RIGHT);
            result.write(this.intToByteArray(this.marginRight));
            result.write(MARGIN_TOP);
            result.write(this.intToByteArray(this.marginTop));
            result.write(MARGIN_BOTTOM);
            result.write(this.intToByteArray(this.marginBottom));
            result.write(10);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] writeSectionDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.landscape) {
                result.write(LANDSCAPE);
                result.write(SECTION_PAGE_WIDTH);
                result.write(this.intToByteArray(this.pageWidth));
                result.write(SECTION_PAGE_HEIGHT);
                result.write(this.intToByteArray(this.pageHeight));
                result.write(10);
            } else {
                result.write(SECTION_PAGE_WIDTH);
                result.write(this.intToByteArray(this.pageWidth));
                result.write(SECTION_PAGE_HEIGHT);
                result.write(this.intToByteArray(this.pageHeight));
                result.write(10);
            }
            result.write(SECTION_MARGIN_LEFT);
            result.write(this.intToByteArray(this.marginLeft));
            result.write(SECTION_MARGIN_RIGHT);
            result.write(this.intToByteArray(this.marginRight));
            result.write(SECTION_MARGIN_TOP);
            result.write(this.intToByteArray(this.marginTop));
            result.write(SECTION_MARGIN_BOTTOM);
            result.write(this.intToByteArray(this.marginBottom));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
    }

    public void setPageSize(Rectangle pageSize) {
        if (!this.guessFormat(pageSize, false)) {
            this.pageWidth = (int)((double)pageSize.width() * 20.0);
            this.pageHeight = (int)((double)pageSize.height() * 20.0);
            this.landscape = this.pageWidth > this.pageHeight;
        }
    }

    private boolean guessFormat(Rectangle pageSize, boolean rotate) {
        if (rotate) {
            pageSize = pageSize.rotate();
        }
        if (this.rectEquals(pageSize, PageSize.A3)) {
            this.pageWidth = 16837;
            this.pageHeight = 23811;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.A4)) {
            this.pageWidth = 11907;
            this.pageHeight = 16840;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.A5)) {
            this.pageWidth = 8391;
            this.pageHeight = 11907;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.A6)) {
            this.pageWidth = 5959;
            this.pageHeight = 8420;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.B4)) {
            this.pageWidth = 14570;
            this.pageHeight = 20636;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.B5)) {
            this.pageWidth = 10319;
            this.pageHeight = 14572;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.HALFLETTER)) {
            this.pageWidth = 7927;
            this.pageHeight = 12247;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.LETTER)) {
            this.pageWidth = 12242;
            this.pageHeight = 15842;
            this.landscape = rotate;
            return true;
        }
        if (this.rectEquals(pageSize, PageSize.LEGAL)) {
            this.pageWidth = 12252;
            this.pageHeight = 20163;
            this.landscape = rotate;
            return true;
        }
        if (!rotate && this.guessFormat(pageSize, true)) {
            int x = this.pageWidth;
            this.pageWidth = this.pageHeight;
            this.pageHeight = x;
            return true;
        }
        return false;
    }

    private boolean rectEquals(Rectangle rect1, Rectangle rect2) {
        return rect1.width() == rect2.width() && rect1.height() == rect2.height();
    }
}

