/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.List;
import clover.com.lowagie.text.RomanList;
import clover.com.lowagie.text.pdf.PdfArray;
import clover.com.lowagie.text.pdf.PdfDictionary;
import clover.com.lowagie.text.pdf.PdfName;
import clover.com.lowagie.text.pdf.PdfNumber;
import clover.com.lowagie.text.pdf.PdfObject;
import clover.com.lowagie.text.pdf.PdfReader;
import clover.com.lowagie.text.pdf.PdfString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeMap;

public class PdfPageLabels {
    public static final int DECIMAL_ARABIC_NUMERALS = 0;
    public static final int UPPERCASE_ROMAN_NUMERALS = 1;
    public static final int LOWERCASE_ROMAN_NUMERALS = 2;
    public static final int UPPERCASE_LETTERS = 3;
    public static final int LOWERCASE_LETTERS = 4;
    public static final int EMPTY = 5;
    static PdfName[] numberingStyle = new PdfName[]{PdfName.D, PdfName.R, new PdfName("r"), PdfName.A, new PdfName("a")};
    TreeMap map = new TreeMap();

    public PdfPageLabels() {
        this.addPageLabel(1, 0, null, 1);
    }

    public void addPageLabel(int page, int numberStyle, String text, int firstPage) {
        if (page < 1 || firstPage < 1) {
            throw new IllegalArgumentException("In a page label the page numbers must be greater or equal to 1.");
        }
        PdfName pdfName = null;
        if (numberStyle >= 0 && numberStyle < numberingStyle.length) {
            pdfName = numberingStyle[numberStyle];
        }
        Integer iPage = new Integer(page);
        Object[] obj = new Object[]{iPage, pdfName, text, new Integer(firstPage)};
        this.map.put(iPage, obj);
    }

    public void addPageLabel(int page, int numberStyle, String text) {
        this.addPageLabel(page, numberStyle, text, 1);
    }

    public void addPageLabel(int page, int numberStyle) {
        this.addPageLabel(page, numberStyle, null, 1);
    }

    public void removePageLabel(int page) {
        if (page <= 1) {
            return;
        }
        this.map.remove(new Integer(page));
    }

    PdfDictionary getDictionary() {
        PdfDictionary dic = new PdfDictionary();
        PdfArray array = new PdfArray();
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            int st;
            String text;
            Object[] obj = (Object[])it.next();
            PdfDictionary subDic = new PdfDictionary();
            PdfName pName = (PdfName)obj[1];
            if (pName != null) {
                subDic.put(PdfName.S, pName);
            }
            if ((text = (String)obj[2]) != null) {
                subDic.put(PdfName.P, new PdfString(text, "UnicodeBig"));
            }
            if ((st = ((Integer)obj[3]).intValue()) != 1) {
                subDic.put(PdfName.ST, new PdfNumber(st));
            }
            array.add(new PdfNumber((Integer)obj[0] - 1));
            array.add(subDic);
        }
        dic.put(PdfName.NUMS, array);
        return dic;
    }

    public static String[] getPageLabels(PdfReader reader) {
        int n = reader.getNumberOfPages();
        String[] labelstrings = new String[n];
        PdfDictionary dict = reader.getCatalog();
        PdfDictionary labels = (PdfDictionary)PdfReader.getPdfObject(dict.get(PdfName.PAGELABELS));
        PdfArray numbers = (PdfArray)PdfReader.getPdfObject(labels.get(PdfName.NUMS));
        HashMap<Integer, PdfDictionary> numberTree = new HashMap<Integer, PdfDictionary>();
        ListIterator i = numbers.listIterator();
        while (i.hasNext()) {
            PdfNumber pageIndex = (PdfNumber)i.next();
            PdfDictionary pageLabel = (PdfDictionary)PdfReader.getPdfObject((PdfObject)i.next());
            numberTree.put(new Integer(pageIndex.intValue()), pageLabel);
        }
        int pagecount = 1;
        String prefix = "";
        int type = 68;
        int i2 = 0;
        while (i2 < n) {
            Integer current = new Integer(i2);
            if (numberTree.containsKey(current)) {
                PdfDictionary d = (PdfDictionary)numberTree.get(current);
                pagecount = d.contains(PdfName.ST) ? ((PdfNumber)d.get(PdfName.ST)).intValue() : 1;
                if (d.contains(PdfName.P)) {
                    prefix = ((PdfString)d.get(PdfName.P)).toString();
                }
                if (d.contains(PdfName.S)) {
                    type = ((PdfName)d.get(PdfName.S)).toString().charAt(1);
                }
            }
            switch (type) {
                default: {
                    labelstrings[i2] = String.valueOf(prefix) + pagecount;
                    break;
                }
                case 82: {
                    labelstrings[i2] = String.valueOf(prefix) + RomanList.toRomanUpperCase(pagecount);
                    break;
                }
                case 114: {
                    labelstrings[i2] = String.valueOf(prefix) + RomanList.toRomanLowerCase(pagecount);
                    break;
                }
                case 65: {
                    labelstrings[i2] = String.valueOf(prefix) + List.getUpperCaseLetter(pagecount);
                    break;
                }
                case 97: {
                    labelstrings[i2] = String.valueOf(prefix) + List.getLowerCaseLetter(pagecount);
                }
            }
            ++pagecount;
            ++i2;
        }
        return labelstrings;
    }
}

