/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.pdf.PdfString;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;

public class PdfDate
extends PdfString {
    private static final int[] DATE_SPACE;

    static {
        int[] nArray = new int[18];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = -1;
        nArray[6] = 5;
        nArray[7] = 2;
        nArray[9] = 11;
        nArray[10] = 2;
        nArray[12] = 12;
        nArray[13] = 2;
        nArray[15] = 13;
        nArray[16] = 2;
        DATE_SPACE = nArray;
    }

    public PdfDate(Calendar d) {
        StringBuffer date = new StringBuffer("D:");
        date.append(this.setLength(d.get(1), 4));
        date.append(this.setLength(d.get(2) + 1, 2));
        date.append(this.setLength(d.get(5), 2));
        date.append(this.setLength(d.get(11), 2));
        date.append(this.setLength(d.get(12), 2));
        date.append(this.setLength(d.get(13), 2));
        int timezone = (d.get(15) + d.get(16)) / 3600000;
        if (timezone == 0) {
            date.append('Z');
        } else if (timezone < 0) {
            date.append('-');
            timezone = -timezone;
        } else {
            date.append('+');
        }
        if (timezone != 0) {
            date.append(this.setLength(timezone, 2)).append('\'');
            int zone = Math.abs((d.get(15) + d.get(16)) / 60000) - timezone * 60;
            date.append(this.setLength(zone, 2)).append('\'');
        }
        this.value = date.toString();
    }

    public PdfDate() {
        this(new GregorianCalendar());
    }

    private String setLength(int i, int length) {
        StringBuffer tmp = new StringBuffer();
        tmp.append(i);
        while (tmp.length() < length) {
            tmp.insert(0, "0");
        }
        tmp.setLength(length);
        return tmp.toString();
    }

    public String getW3CDate() {
        return PdfDate.getW3CDate(this.value);
    }

    public static String getW3CDate(String d) {
        SimpleDateFormat w3c = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Calendar c = PdfDate.decode(d);
        return w3c.format(c.getTime());
    }

    public static Calendar decode(String s) {
        try {
            GregorianCalendar calendar;
            if (s.startsWith("D:")) {
                s = s.substring(2);
            }
            int slen = s.length();
            int idx = s.indexOf(90);
            if (idx >= 0) {
                slen = idx;
                calendar = new GregorianCalendar(new SimpleTimeZone(0, "ZPDF"));
            } else {
                int sign = 1;
                idx = s.indexOf(43);
                if (idx < 0 && (idx = s.indexOf(45)) >= 0) {
                    sign = -1;
                }
                if (idx < 0) {
                    calendar = new GregorianCalendar();
                } else {
                    int offset = Integer.parseInt(s.substring(idx + 1, idx + 3)) * 60;
                    if (idx + 5 < s.length()) {
                        offset += Integer.parseInt(s.substring(idx + 4, idx + 6));
                    }
                    calendar = new GregorianCalendar(new SimpleTimeZone(offset * sign * 60000, "ZPDF"));
                    slen = idx;
                }
            }
            calendar.clear();
            idx = 0;
            int k = 0;
            while (k < DATE_SPACE.length) {
                if (idx >= slen) break;
                calendar.set(DATE_SPACE[k], Integer.parseInt(s.substring(idx, idx + DATE_SPACE[k + 1])) + DATE_SPACE[k + 2]);
                idx += DATE_SPACE[k + 1];
                k += 3;
            }
            return calendar;
        }
        catch (Exception e) {
            return null;
        }
    }
}

