/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.Primitives;
import clover.com.google.gson.TypeUtils;
import java.lang.reflect.Type;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeInfo {
    protected final Type actualType;
    protected final Class<?> rawClass;

    TypeInfo(Type actualType) {
        this.actualType = actualType;
        this.rawClass = TypeUtils.toRawClass(actualType);
    }

    public final Type getActualType() {
        return this.actualType;
    }

    public final Class<?> getWrappedClass() {
        return Primitives.wrap(this.rawClass);
    }

    public final Class<?> getRawClass() {
        return this.rawClass;
    }

    public final boolean isCollectionOrArray() {
        return Collection.class.isAssignableFrom(this.rawClass) || this.isArray();
    }

    public final boolean isArray() {
        return TypeUtils.isArray(this.rawClass);
    }

    public final boolean isEnum() {
        return this.rawClass.isEnum();
    }

    public final boolean isPrimitive() {
        return Primitives.isWrapperType(Primitives.wrap(this.rawClass));
    }
}

