/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.util;

import info.bliki.htmlcleaner.BaseToken;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.TagToken;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagStack
extends ArrayList<TagToken> {
    protected ArrayList<BaseToken> fNodeList;
    private static final long serialVersionUID = 7377721039394435077L;

    public TagStack() {
        this(40, 80);
    }

    public TagStack(int initialStackCapacity, int initialNodelistCapacity) {
        super(initialStackCapacity);
        this.fNodeList = new ArrayList(initialNodelistCapacity);
    }

    public TagToken peek() {
        return (TagToken)this.get(this.size() - 1);
    }

    public TagToken pop() {
        if (this.size() > 0) {
            TagToken node = (TagToken)this.remove(this.size() - 1);
            if (this.size() == 0) {
                this.fNodeList.add(node);
            } else {
                TagToken topNode = this.peek();
                if (topNode instanceof TagNode) {
                    ((TagNode)topNode).addChild(node);
                } else {
                    throw new UnsupportedOperationException("No TagNode available!");
                }
            }
            return node;
        }
        return null;
    }

    public boolean push(TagToken item) {
        return this.add(item);
    }

    public boolean push(String nodeString) {
        return this.add(new TagNode(nodeString));
    }

    public List<BaseToken> getNodeList() {
        return this.fNodeList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void append(BaseToken contentNode) {
        if (this.size() > 0) {
            TagToken node = this.peek();
            if (!(node instanceof TagNode)) throw new UnsupportedOperationException("No TagNode available for tag: " + node.getName());
            ((TagNode)node).addChild(contentNode);
            return;
        } else {
            this.fNodeList.add(contentNode);
        }
    }

    public void append(TagStack stack) {
        for (int i = 0; i < stack.fNodeList.size(); ++i) {
            this.append(stack.fNodeList.get(i));
        }
    }
}

