/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.code;

import info.bliki.wiki.tags.code.AbstractCodeFormatter;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCPPBasedCodeFilter
extends AbstractCodeFormatter {
    protected int appendIdentifier(String input, int identifierStart, int currentPosition, HashMap<String, String> keyWords, HashMap<String, String> objectWords, StringBuilder result) {
        String keywordValue;
        String originalIdent;
        String keywordIdent = originalIdent = input.substring(identifierStart, --currentPosition);
        if (!this.isKeywordCaseSensitive()) {
            keywordIdent = keywordIdent.toLowerCase();
        }
        if ((keywordValue = keyWords.get(keywordIdent)) != null) {
            result.append(keywordValue);
        } else {
            if (objectWords == null) {
                result.append(originalIdent);
                return currentPosition;
            }
            String objectValue = objectWords.get(keywordIdent);
            if (objectValue != null) {
                result.append(objectValue);
            } else {
                result.append(originalIdent);
            }
        }
        return currentPosition;
    }

    @Override
    public String filter(String input) {
        char[] source = input.toCharArray();
        int currentPosition = 0;
        int identStart = 0;
        char currentChar = ' ';
        HashMap<String, String> keywordsSet = this.getKeywordSet();
        HashMap<String, String> objectsSet = this.getObjectSet();
        StringBuilder result = new StringBuilder(input.length() + input.length() / 4);
        boolean identFound = false;
        try {
            while (true) {
                if ((currentChar = source[currentPosition++]) >= 'A' && currentChar <= 'Z' || currentChar == '_' || currentChar >= 'a' && currentChar <= 'z') {
                    identStart = currentPosition - 1;
                    identFound = true;
                    while (currentChar >= 'a' && currentChar <= 'z' || currentChar >= 'A' && currentChar <= 'Z' || currentChar == '_') {
                        currentChar = source[currentPosition++];
                    }
                    currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, objectsSet, result);
                    identFound = false;
                    continue;
                }
                if (currentChar == '\"') {
                    result.append("<span style=\"color:#2A00FF; \">");
                    AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\\') {
                            currentChar = source[currentPosition++];
                            AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                            continue;
                        }
                        if (currentChar != 34) continue;
                    }
                    result.append("</span>");
                    continue;
                }
                if (currentChar == '\'') {
                    result.append("<span style=\"color:#2A00FF; \">");
                    AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\\') {
                            currentChar = source[currentPosition++];
                            AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                            continue;
                        }
                        if (currentChar != 39) continue;
                    }
                    result.append("</span>");
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '/') {
                    result.append("<span style=\"color:#3F7F5F; \">");
                    AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                    AbstractCPPBasedCodeFilter.appendChar(result, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                        if (currentChar != 10) continue;
                    }
                    result.append("</span>");
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '*') {
                    if (currentPosition < input.length() - 1 && source[currentPosition + 1] == '*') {
                        result.append("<span style=\"color:#3F5FBF; \">");
                    } else {
                        result.append("<span style=\"color:#3F7F5F; \">");
                    }
                    AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                    AbstractCPPBasedCodeFilter.appendChar(result, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                        if (currentChar != 47 || source[currentPosition - 2] != '*') continue;
                    }
                    result.append("</span>");
                    continue;
                }
                if (currentChar == '<' && this.isPHPTag() && currentPosition + 3 < input.length() && source[currentPosition] == '?' && source[currentPosition + 1] == 'p' && source[currentPosition + 2] == 'h' && source[currentPosition + 3] == 'p') {
                    currentPosition += 4;
                    result.append("<span style=\"color:#7F0055; font-weight: bold; \">&#60;?php</span>");
                    continue;
                }
                if (currentChar == '?' && this.isPHPTag() && currentPosition < input.length() && source[currentPosition] == '>') {
                    ++currentPosition;
                    result.append("<span style=\"color:#7F0055; font-weight: bold; \">?&#62;</span>");
                    continue;
                }
                AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
            }
        }
        catch (IndexOutOfBoundsException e) {
            if (identFound) {
                currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, null, result);
            }
            return result.toString();
        }
    }

    public boolean isKeywordCaseSensitive() {
        return true;
    }

    public boolean isPHPTag() {
        return false;
    }
}

