/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.xml.SAXiTextHandler;
import de.memtext.util.CryptUtils;
import de.memtext.util.FileDeleterThread;
import de.memtext.util.FileUtils;
import de.memtext.util.TimeUtils;
import de.memtext.util.TransletUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.SxDBUtils;
import de.superx.common.DBServletException;
import de.superx.common.TransletCache;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.util.SqlStringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;
import org.jfor.jfor.converter.Converter;
import org.jfor.jfor.converter.IConverterOption;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlTransformer {
    private static int cacheSecs = 300;
    private String stylesheet;
    private String contenttype;
    private HttpServletResponse response;
    private HttpServletRequest request;
    private String mandantenID = "default";
    private String browser;
    private ServletConfig config;
    private String xml;
    private Locale desiredLocale;
    private TimeUtils tutil = new TimeUtils();
    private String maskenname;
    private static final short DECIMALFORMAT = 4;
    private static final short INTEGERFORMAT = 3;
    private String encryptParam;
    private HSSFFont font_1;
    private HSSFFont font_2;
    private HSSFFont font_3;
    private HSSFFont font_4;
    private HSSFFont font_5;
    private HSSFFont font_summe;

    public XmlTransformer(ServletConfig config, HttpServletRequest request, HttpServletResponse response, String mandantenID, String browser) {
        this.response = response;
        this.request = request;
        this.browser = browser;
        this.config = config;
        this.mandantenID = mandantenID;
        XMLUtils.getExceptionHandler().setExitWanted(false);
    }

    private ServletConfig getServletConfig() {
        return this.config;
    }

    public void transform(String maskenname, Collection tmpFiles, String xml, Locale desiredLocale, String stylesheet, String desiredContenttype, String encryptParam) throws DBServletException, FactoryConfigurationError, IOException, ParserConfigurationException, TransformerException {
        this.xml = xml;
        this.stylesheet = stylesheet;
        this.contenttype = desiredContenttype;
        this.desiredLocale = desiredLocale;
        this.maskenname = maskenname;
        this.encryptParam = encryptParam;
        this.tutil.start();
        String methode = "html";
        if (stylesheet != null && stylesheet.indexOf("fo_rtf") > -1) {
            desiredContenttype = "application/rtf";
        }
        if (desiredContenttype != null) {
            if (desiredContenttype.equals("")) {
                desiredContenttype = "text/html; charset=" + SqlStringUtils.getEncoding();
                methode = "html";
            }
        } else {
            desiredContenttype = "text/html; charset=" + SqlStringUtils.getEncoding();
        }
        if ((desiredContenttype = desiredContenttype.toLowerCase()).startsWith("text/xml")) {
            this.response.setContentType("text/xml; charset=" + SqlStringUtils.getEncoding());
            methode = "xml";
        } else if (desiredContenttype.startsWith("application/pdf")) {
            this.response.setContentType("application/pdf");
            methode = "xml";
        } else if (desiredContenttype.startsWith("text/plain")) {
            this.response.setContentType("text/plain; charset=" + SqlStringUtils.getEncoding());
            methode = "text";
        } else if (desiredContenttype.startsWith("application/msword") || desiredContenttype.startsWith("application/rtf")) {
            Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINE, "Transformiere nach rtf gew\u00e4hlt ");
            this.response.setContentType("application/rtf");
            methode = "xml";
        } else if (desiredContenttype.startsWith("application/vnd.ms-excel")) {
            Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINE, "Transformiere nach xls gew\u00e4hlt ");
            this.response.setContentType("application/vnd.ms-excel");
            methode = "xml";
        } else if (desiredContenttype.startsWith("native_")) {
            methode = "xml";
        } else {
            this.response.setContentType(desiredContenttype);
            methode = "html";
        }
        Logger.getLogger("superx_" + this.getMandantenID()).log(Level.INFO, "Transformation nach " + methode + " beginnt ");
        if (stylesheet == null || stylesheet.equals("")) {
            stylesheet = SuperXManager.defaultTableHtmlXsl;
        }
        String transletFile = "file:///" + this.getServletConfig().getServletContext().getRealPath("xml/" + stylesheet);
        Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.INFO, " Translet f\u00fcr Ergebnisvorbereitung:" + transletFile);
        Transformer transformer = TransletCache.getTransformer(this.getMandantenID(), transletFile);
        transformer.setOutputProperty("encoding", SqlStringUtils.getEncoding());
        transformer.setOutputProperty("method", methode);
        xml = SxPools.get(this.getMandantenID()).localize(xml, desiredLocale);
        SuperXManager.setLastXml(xml);
        StringReader returnTextStringReader = new StringReader(xml);
        Logger.getLogger("superx_" + this.getMandantenID()).log(Level.INFO, "Erzeuge Contenttype: " + desiredContenttype);
        if (desiredContenttype.equals("text/xml")) {
            this.createXml(transformer, returnTextStringReader);
        } else if (desiredContenttype.equals("application/pdf")) {
            this.createPdf(transformer, returnTextStringReader);
        } else if (desiredContenttype.equals("application/rtf")) {
            this.createRtf(transformer, returnTextStringReader);
        } else if (desiredContenttype.equals("application/vnd.ms-excel")) {
            this.createXls(transformer, returnTextStringReader, null);
        } else if (desiredContenttype.startsWith("native")) {
            this.createNative(returnTextStringReader);
        } else {
            this.createNormalOutput(transformer, returnTextStringReader);
        }
        FileDeleterThread fd = new FileDeleterThread(tmpFiles, cacheSecs);
        fd.start();
    }

    public void createPdfStandalone(String xml, String transletFile, String outfileFilename) throws IOException, TransformerException, ConfigurationException, SAXException, DBServletException {
        FopFactory fopFactory = FopFactory.newInstance();
        fopFactory.setStrictValidation(false);
        fopFactory.setSourceResolution(96);
        DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
        File f2 = new File(transletFile);
        File cfgFile = new File("fop.xconf");
        if (!cfgFile.exists()) {
            throw new IOException("fop.xconf nicht gefunden - muss im gleichen Verzeichnis wie xsl Datei liegen");
        }
        Configuration cfg = cfgBuilder.buildFromFile(cfgFile);
        fopFactory.setUserConfig(cfg);
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        foUserAgent.setBaseURL(f2.getParent());
        FileOutputStream fs = new FileOutputStream(outfileFilename);
        Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)fs);
        StringReader returnTextStringReader = new StringReader(xml);
        StreamSource src = new StreamSource(returnTextStringReader);
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        Templates t = TransletUtils.createTemplate(transletFile);
        TransletUtils.initFactory();
        Transformer transformer = t.newTransformer();
        transformer.setOutputProperty("encoding", SqlStringUtils.getEncoding());
        transformer.setOutputProperty("method", "xml");
        transformer.transform(src, res);
        fs.close();
    }

    public void createExcelStandalone(String xml, String transletFile, String outfileFilename) throws DBServletException, FactoryConfigurationError, IOException, ParserConfigurationException, TransformerException {
        String methode = "xml";
        Transformer transformer = TransletCache.getTransformer(this.getMandantenID(), transletFile);
        transformer.setOutputProperty("encoding", SqlStringUtils.getEncoding());
        transformer.setOutputProperty("method", methode);
        StringReader returnTextStringReader = new StringReader(xml);
        this.createXls(transformer, returnTextStringReader, outfileFilename);
    }

    public void setMandantenID(String mandantenId) {
        this.mandantenID = mandantenId;
    }

    private String getMandantenID() {
        return this.mandantenID;
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    private void createNormalOutput(Transformer transformer, StringReader returnTextStringReader) throws IOException, TransformerException {
        Logger.getLogger("superx_" + this.getMandantenID()).log(Level.INFO, "Normal xml Transformation, not fop or rtf");
        StringWriter erg = new StringWriter();
        transformer.transform(new StreamSource(returnTextStringReader), new StreamResult(erg));
        String result = erg.toString();
        result = SxPools.get(this.mandantenID).customHTMLHeaderFooter(result);
        Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " transformation zu HTML Dauer:" + this.tutil.getSinceStart());
        if (this.encryptParam != null && this.encryptParam.equals("true")) {
            result = CryptUtils.simpleEncryptString2(result);
        }
        this.tutil.start();
        this.sendBackHTML(result);
        Logger.getLogger("superx_" + this.getMandantenID()).log(Level.FINER, " schicken der Ergebnisseite an Client " + this.tutil.getSinceStart());
    }

    protected void sendBackHTML(String txt) throws IOException {
        Object out = null;
        TimeUtils t = new TimeUtils();
        t.start();
        String encoding = this.request.getHeader("Accept-Encoding");
        byte[] myBytes = txt.getBytes(SqlStringUtils.getEncoding());
        if (encoding != null && encoding.indexOf("gzip") != -1) {
            this.response.setHeader("Content-Encoding", "gzip");
            out = new GZIPOutputStream((OutputStream)this.response.getOutputStream());
        } else if (encoding != null && encoding.indexOf("compress") != -1) {
            this.response.setHeader("Content-Encoding", "compress");
            out = new ZipOutputStream((OutputStream)this.response.getOutputStream());
        } else {
            this.response.setContentLength(myBytes.length);
            out = this.response.getOutputStream();
        }
        this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        ((OutputStream)out).write(myBytes);
        ((OutputStream)out).close();
    }

    private void createRtf(Transformer transformer, StringReader returnTextStringReader) throws FactoryConfigurationError, TransformerException, IOException, DBServletException, ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dfactory.newDocumentBuilder();
        org.w3c.dom.Document mydomres = builder.newDocument();
        PrintWriter output = this.response.getWriter();
        this.response.reset();
        this.response.setContentType("application/rtf");
        this.response.setHeader("Content-disposition", "attachment; filename=" + this.maskenname.replace(' ', '_') + ".rtf");
        this.response.setHeader("Cache-Control", "expires=0");
        transformer.transform(new StreamSource(returnTextStringReader), new DOMResult(mydomres));
        try {
            new Converter(mydomres, (Writer)output, (IConverterOption)Converter.createConverterOption());
        }
        catch (Exception e2) {
            throw new DBServletException("Converter " + e2);
        }
        output.flush();
    }

    private void createPdfItext(Transformer transformer, StringReader returnTextStringReader) throws ParserConfigurationException, FactoryConfigurationError, SAXException, IOException, TransformerException {
        StringWriter w = new StringWriter();
        StreamResult itextXml = new StreamResult(w);
        transformer.transform(new StreamSource(returnTextStringReader), itextXml);
        Document document = new Document();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(new InputSource(new StringReader(w.getBuffer().toString())), (DefaultHandler)new SAXiTextHandler((DocListener)document));
        this.response.reset();
        this.response.setContentType("application/pdf");
        this.response.setHeader("Content-disposition", "attachment; filename=" + this.maskenname.replace(' ', '_') + ".pdf");
        this.response.setHeader("Cache-Control", "expires=0");
        this.response.setContentLength(outStream.size());
        ServletOutputStream sos = this.response.getOutputStream();
        outStream.writeTo((OutputStream)sos);
        sos.flush();
    }

    private void createXls(Transformer transformer, StringReader returnTextStringReader, String filename) throws FactoryConfigurationError, IOException, ParserConfigurationException, TransformerException {
        HSSFWorkbook wb;
        Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.INFO, "Transformiere nach xls ");
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dfactory.newDocumentBuilder();
        org.w3c.dom.Document mydomres = builder.newDocument();
        transformer.transform(new StreamSource(returnTextStringReader), new DOMResult(mydomres));
        Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.INFO, "Transformiere nach xml-xls ");
        Node workbook = XMLUtils.getFirstNode(mydomres, "xls_workbook");
        if (workbook == null) {
            return;
        }
        if (SxPools.hasPool(this.mandantenID) && SxPools.get(this.mandantenID).getExcelVorlage() != null && (!XMLUtils.hasAttrib(workbook, "vorlage") || XMLUtils.getAttribValue(workbook, "vorlage").equals(""))) {
            XMLUtils.setAttribValue(workbook, "vorlage", SxPools.get(this.mandantenID).getExcelVorlage());
        }
        String vorlage = null;
        if (XMLUtils.hasAttrib(workbook, "vorlage")) {
            vorlage = XMLUtils.getAttribValue(workbook, "vorlage");
        }
        if (vorlage == null || vorlage.equals("")) {
            wb = new HSSFWorkbook();
        } else {
            FileInputStream fis = new FileInputStream(vorlage);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)fis);
            wb = new HSSFWorkbook(fs);
            fis.close();
        }
        this.font_1 = wb.createFont();
        this.font_1.setBoldweight((short)700);
        this.font_2 = wb.createFont();
        this.font_2.setBoldweight((short)700);
        this.font_3 = wb.createFont();
        this.font_3.setBoldweight((short)700);
        this.font_4 = wb.createFont();
        this.font_4.setBoldweight((short)700);
        this.font_4.setItalic(true);
        this.font_5 = wb.createFont();
        this.font_5.setBoldweight((short)700);
        this.font_summe = wb.createFont();
        this.font_summe.setBoldweight((short)700);
        NodeList stylelist = mydomres.getElementsByTagName("xls_cellstyle");
        Node pageformat = null;
        try {
            pageformat = XMLUtils.getChildNode(workbook, "xls_PageFormat");
        }
        catch (Exception exception) {
            // empty catch block
        }
        XlsStyles xs = new XlsStyles(stylelist, wb);
        Hashtable styles = xs.getHashtable();
        int counter = 0;
        Iterator it = XMLUtils.getChildNodeIterator(workbook);
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getLocalName() != "xls_sheet") continue;
            this.createXls_Sheet(vorlage != null && !vorlage.equals(""), styles, n, pageformat, wb, ++counter, vorlage == null);
        }
        String removeAdditionalSheets = null;
        if (XMLUtils.hasAttrib(workbook, "removeAdditionalSheets")) {
            removeAdditionalSheets = XMLUtils.getAttribValue(workbook, "removeAdditionalSheets");
        }
        if (removeAdditionalSheets != null && removeAdditionalSheets.equals("true")) {
            int sheetCount = wb.getNumberOfSheets();
            int i2 = counter;
            while (i2 < sheetCount) {
                HSSFSheet asheet = wb.getSheetAt(counter);
                wb.setSheetName(counter, "del" + i2);
                int i22 = 0;
                while (i22 <= asheet.getLastRowNum()) {
                    if (asheet.getRow(i22) != null) {
                        asheet.removeRow((Row)asheet.getRow(i22));
                    }
                    ++i22;
                }
                wb.removeSheetAt(counter);
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < wb.getNumberOfSheets()) {
            wb.getSheetAt(i3).setSelected(i3 == 0);
            ++i3;
        }
        if (filename != null) {
            FileOutputStream fileOut = new FileOutputStream(filename);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        } else {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            this.response.reset();
            this.response.setContentType("application/vnd.ms-excel");
            this.response.setHeader("Content-disposition", "attachment; filename=" + FileUtils.removeProblemChars(this.maskenname) + ".xls");
            this.response.setHeader("Cache-Control", "expires=0");
            this.response.setContentLength(outStream.size());
            ServletOutputStream sos = this.response.getOutputStream();
            outStream.writeTo((OutputStream)sos);
            sos.flush();
        }
    }

    /*
     * Unable to fully structure code
     */
    private short getColorIndex(String attrib) {
        block3: {
            result = -999;
            try {
                result = Short.parseShort(attrib);
                break block3;
            }
            catch (NumberFormatException ex) {
                t = HSSFColor.getIndexHash();
                e = t.keys();
                ** while (e.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                key = e.nextElement();
                if (t.get(key) == null || t.get(key).toString().indexOf(attrib) <= -1) continue;
                c = (HSSFColor)t.get(key);
                result = c.getIndex();
                break;
            }
        }
        return result;
    }

    private void createXml(Transformer transformer, StringReader returnTextStringReader) throws IOException, TransformerException {
        ServletOutputStream out = null;
        Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.INFO, "Transformiere nach XML ");
        Level logLevel = Logger.getLogger("superx_" + this.getMandantenID() + "_xml").getParent().getLevel();
        Logger.getLogger("superx_" + this.getMandantenID() + "_xml").getParent().setLevel(Level.SEVERE);
        out = this.response.getOutputStream();
        this.response.setContentType("text/xml; charset=" + SqlStringUtils.getEncoding());
        this.response.setHeader("Content-Encoding", SqlStringUtils.getEncoding());
        StringWriter erg = new StringWriter();
        transformer.transform(new StreamSource(returnTextStringReader), new StreamResult(erg));
        String result = erg.toString();
        byte[] myBytes = result.getBytes(SqlStringUtils.getEncoding());
        this.response.setContentLength(myBytes.length);
        out.write(myBytes);
        out.close();
    }

    private void createPdf(Transformer transformer, StringReader returnTextStringReader) throws IOException, TransformerException {
        Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.INFO, "Transformiere nach pdf ");
        Level logLevel = Logger.getLogger("superx_" + this.getMandantenID() + "_xml").getParent().getLevel();
        Logger.getLogger("superx_" + this.getMandantenID() + "_xml").getParent().setLevel(Level.SEVERE);
        this.response.setContentType("application/pdf");
        this.response.setHeader("Content-disposition", "attachment; filename=" + FileUtils.removeProblemChars(this.maskenname) + ".pdf");
        this.response.setHeader("Cache-Control", "expires=0");
        try {
            try {
                FopFactory fopFactory = FopFactory.newInstance();
                fopFactory.setStrictValidation(false);
                fopFactory.setSourceResolution(96);
                DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
                String cfgFolder = String.valueOf(this.getServletConfig().getServletContext().getRealPath("/")) + File.separator + "WEB-INF";
                Configuration cfg = cfgBuilder.buildFromFile(new File(String.valueOf(cfgFolder) + File.separator + "fop.xconf"));
                fopFactory.setUserConfig(cfg);
                FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
                foUserAgent.setBaseURL("file:///" + this.getServletConfig().getServletContext().getRealPath("/"));
                Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)this.response.getOutputStream());
                StreamSource src = new StreamSource(returnTextStringReader);
                SAXResult res = new SAXResult(fop.getDefaultHandler());
                transformer.transform(src, res);
            }
            catch (Exception ex) {
                Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.SEVERE, "Transformer-Fehlelr\n " + ex.toString());
                Logger.getLogger("superx_" + this.getMandantenID() + "_xml").getParent().setLevel(logLevel);
            }
        }
        finally {
            Logger.getLogger("superx_" + this.getMandantenID() + "_xml").getParent().setLevel(logLevel);
        }
    }

    protected void createXlsPageFormat(Node pageformat, HSSFSheet sheet) {
        HSSFPrintSetup ps = sheet.getPrintSetup();
        if (pageformat != null) {
            Object s = null;
            String mynode = "";
            Iterator it = XMLUtils.getChildNodeIterator(pageformat);
            while (it.hasNext()) {
                String nodeval;
                Node n = (Node)it.next();
                String nodename = n.getLocalName();
                try {
                    nodeval = XMLUtils.getTheValue(n);
                }
                catch (Exception e2) {
                    nodeval = "";
                }
                String nodefont = null;
                String nodefontStyle = null;
                String nodefontSize = null;
                try {
                    nodefont = XMLUtils.getAttribValue(n, "font");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    nodefontStyle = XMLUtils.getAttribValue(n, "fontStyle");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    nodefontSize = XMLUtils.getAttribValue(n, "fontSize");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mynode = "";
                if (nodefont != null && nodefontStyle != null) {
                    mynode = String.valueOf(mynode) + HSSFHeader.font((String)nodefont, (String)nodefontStyle);
                }
                if ((mynode = String.valueOf(mynode) + nodeval).indexOf("$PAGE") > 0) {
                    mynode = SxDBUtils.replaceString(mynode, "$PAGE", HSSFHeader.page());
                }
                if (mynode.indexOf("$NUMPAGES") > 0) {
                    mynode = SxDBUtils.replaceString(mynode, "$NUMPAGES", HSSFHeader.numPages());
                }
                Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.INFO, "node: " + nodename + " val: " + nodeval);
                if (nodename.equalsIgnoreCase("xls_top-margin")) {
                    sheet.setMargin((short)2, Double.parseDouble(nodeval) / 2.54);
                }
                if (nodename.equalsIgnoreCase("xls_bottom-margin")) {
                    sheet.setMargin((short)3, Double.parseDouble(nodeval) / 2.54);
                }
                if (nodename.equalsIgnoreCase("xls_left-margin")) {
                    sheet.setMargin((short)0, Double.parseDouble(nodeval) / 2.54);
                }
                if (nodename.equalsIgnoreCase("xls_right-margin")) {
                    sheet.setMargin((short)1, Double.parseDouble(nodeval) / 2.54);
                }
                this.createXlsHeaderFooter(sheet, nodename, mynode);
                if (nodename.equalsIgnoreCase("xls_Autobreaks")) {
                    sheet.setAutobreaks(true);
                }
                if (nodename.equalsIgnoreCase("xls_Landscape")) {
                    ps.setLandscape(true);
                }
                if (nodename.equalsIgnoreCase("xls_FitHeight")) {
                    ps.setFitHeight(Short.parseShort(nodeval));
                }
                if (nodename.equalsIgnoreCase("xls_FitWidth")) {
                    ps.setFitWidth(Short.parseShort(nodeval));
                    Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.INFO, "xls_FitWidth: " + nodeval);
                }
                if (!nodename.equalsIgnoreCase("xls_PaperSize")) continue;
                if (nodeval.equalsIgnoreCase("letter")) {
                    ps.setPaperSize((short)1);
                    continue;
                }
                ps.setPaperSize((short)9);
            }
        }
    }

    private void createXlsHeaderFooter(HSSFSheet sheet, String nodename, String mynode) {
        HSSFHeader header = sheet.getHeader();
        HSSFFooter footer = sheet.getFooter();
        if (nodename.equalsIgnoreCase("xls_header-left")) {
            header.setLeft(mynode);
        }
        if (nodename.equalsIgnoreCase("xls_header-center")) {
            header.setCenter(mynode);
        }
        if (nodename.equalsIgnoreCase("xls_header-right")) {
            header.setRight(mynode);
        }
        if (nodename.equalsIgnoreCase("xls_footer-left")) {
            footer.setLeft(mynode);
        }
        if (nodename.equalsIgnoreCase("xls_footer-center")) {
            footer.setCenter(mynode);
        }
        if (nodename.equalsIgnoreCase("xls_footer-right")) {
            footer.setRight(mynode);
        }
    }

    protected void createXls_Sheet(boolean hasVorlagendatei, Hashtable styles, Node sheetnode, Node pageformat, HSSFWorkbook wb, int counter, boolean isNewSheetWanted) {
        HSSFSheet sheet;
        if (sheetnode == null || pageformat == null) {
            return;
        }
        HSSFRow row = null;
        String row_level = "";
        short rownum = 0;
        String s = XMLUtils.getAttribValue(sheetnode, "name");
        if (s == null) {
            s = "Ergebnis";
        }
        if (isNewSheetWanted || counter > wb.getNumberOfSheets()) {
            sheet = wb.createSheet(String.valueOf(this.createExcelSheetname(s)) + counter);
        } else {
            sheet = wb.getSheetAt(counter - 1);
            wb.setSheetName(counter - 1, String.valueOf(this.createExcelSheetname(s)) + counter);
        }
        Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.INFO, "Erzeuge Excel Sheet " + counter);
        Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.INFO, "Erzeuge PageFormat f\u00fcr Excel Sheet " + counter);
        if (!hasVorlagendatei) {
            this.createXlsPageFormat(pageformat, sheet);
        }
        if (XMLUtils.hasAttrib(sheetnode, "repeatrowstart")) {
            this.installRepeatRows(counter - 1, sheetnode, wb);
        }
        Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.INFO, "Erzeuge Rows f\u00fcr Excel Sheet " + counter);
        Iterator it = XMLUtils.getChildNodeIterator(sheetnode);
        while (it.hasNext()) {
            Node rownode = (Node)it.next();
            row_level = "";
            if (XMLUtils.hasAttrib(rownode, "jumpover") && XMLUtils.getAttribValue(rownode, "jumpover").equals("true")) {
                rownum = (short)(rownum + 1);
                continue;
            }
            if (XMLUtils.hasAttrib(rownode, "ebene")) {
                row_level = XMLUtils.getAttribValue(rownode, "ebene");
            }
            if (XMLUtils.hasAttrib(rownode, "issumme")) {
                row_level = "summe";
            }
            row = sheet.createRow((int)rownum);
            try {
                s = XMLUtils.getAttribValue(rownode, "height");
                if (s != null) {
                    row.setHeight(Short.parseShort(s));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s = XMLUtils.getAttribValue(rownode, "repeating");
                if (s != null) {
                    if (s.equalsIgnoreCase("true")) {
                        wb.setRepeatingRowsAndColumns(counter - 1, -1, -1, (int)rownum, (int)rownum);
                    } else {
                        wb.setRepeatingRowsAndColumns(counter - 1, -1, -1, (int)rownum, rownum + Integer.parseInt(s) - 1);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            short columnnum = 0;
            Iterator cellit = XMLUtils.getChildNodeIterator(rownode);
            while (cellit.hasNext()) {
                Node cellnode = (Node)cellit.next();
                if (XMLUtils.hasAttrib(cellnode, "jumpover") && XMLUtils.getAttribValue(cellnode, "jumpover").equals("true")) {
                    columnnum = (short)(columnnum + 1);
                    continue;
                }
                this.createXlsCell(wb, sheet, styles, row, rownum, row_level, cellnode, columnnum);
                columnnum = (short)(columnnum + 1);
            }
            rownum = (short)(rownum + 1);
        }
    }

    private void createXlsCell(HSSFWorkbook wb, HSSFSheet sheet, Hashtable styles, HSSFRow row, short rownum, String row_level, Node cellnode, short columnnum) {
        String s;
        String value = null;
        Object laenge = null;
        HSSFCell cell = null;
        try {
            value = XMLUtils.getChildNodeValues(cellnode).trim();
        }
        catch (Exception e2) {
            value = "";
        }
        cell = row.createCell(columnnum);
        try {
            if (row_level != null && !row_level.equals("")) {
                HSSFCellStyle style;
                String datatype = "general";
                if (XMLUtils.hasAttrib(cellnode, "datatype") && (XMLUtils.getAttribValue(cellnode, "datatype").equals("decimal") || XMLUtils.getAttribValue(cellnode, "datatype").equals("integer"))) {
                    datatype = XMLUtils.getAttribValue(cellnode, "datatype");
                }
                if ((style = (HSSFCellStyle)styles.get("int" + datatype + row_level)) == null) {
                    throw new RuntimeException("Kein Style f\u00fcr Ebene +" + row_level + " datatype:" + datatype + " gefunden");
                }
                cell.setCellStyle(style);
            } else {
                s = XMLUtils.getAttribValue(cellnode, "style");
                if (s != null) {
                    cell.setCellStyle((HSSFCellStyle)styles.get(s));
                }
            }
        }
        catch (Exception datatype) {
            // empty catch block
        }
        if (XMLUtils.hasAttrib(cellnode, "numeric") || cell.getCellStyle() != null && cell.getCellStyle().getDataFormat() != 0) {
            cell.setCellType(0);
            cell.setCellValue("");
            if (value != null && !value.trim().equals("")) {
                Double d2 = new Double(1.0);
                try {
                    double d1 = Double.parseDouble(value);
                    cell.setCellValue(d1);
                }
                catch (NumberFormatException e3) {
                    Logger.getLogger("superx_" + this.getMandantenID() + "_xml").log(Level.INFO, "Double konnte nicht codiert werden: " + value);
                }
            }
        } else if (value == null || value.equals("")) {
            cell.setCellType(3);
        } else {
            this.setStringValue(value, cell);
        }
        try {
            s = XMLUtils.getAttribValue(cellnode, "width");
            if (s != null && Integer.parseInt(s) < 32000) {
                sheet.setColumnWidth(columnnum, Short.parseShort(s));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s = XMLUtils.getAttribValue(cellnode, "colspan");
            if (s != null) {
                sheet.addMergedRegion((org.apache.poi.ss.util.Region)new Region((int)rownum, columnnum, (int)rownum, (short)(columnnum + Integer.parseInt(s) - 1)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s = XMLUtils.getAttribValue(cellnode, "rowspan");
            if (s != null) {
                sheet.addMergedRegion((org.apache.poi.ss.util.Region)new Region((int)rownum, columnnum, rownum + Integer.parseInt(s) - 1, columnnum));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setStringValue(String value, HSSFCell cell) {
        try {
            cell.setCellType(1);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        cell.setCellValue(value.trim());
    }

    private void installRepeatRows(int sheetpos, Node sheetnode, HSSFWorkbook wb) {
        String repeatrowstart = XMLUtils.getAttribValue(sheetnode, "repeatrowstart");
        if (!XMLUtils.hasAttrib(sheetnode, "repeatrowend")) {
            throw new IllegalArgumentException("sheet must have both attribs: repeatrowstart and repeatrowend");
        }
        String repeatrowend = XMLUtils.getAttribValue(sheetnode, "repeatrowend");
        int startrow = Integer.parseInt(repeatrowstart);
        int endrow = Integer.parseInt(repeatrowend);
        wb.setRepeatingRowsAndColumns(sheetpos, -1, -1, startrow - 1, endrow - 1);
    }

    String createExcelSheetname(String s) {
        s = SxDBUtils.replaceString(s, "/", "|");
        s = SxDBUtils.replaceString(s, "\\", "");
        s = SxDBUtils.replaceString(s, "?", "");
        s = SxDBUtils.replaceString(s, "*", "");
        s = SxDBUtils.replaceString(s, "[", "");
        if ((s = SxDBUtils.replaceString(s, "]", "")).length() > 28) {
            s = String.valueOf(s.substring(0, 26)) + "..";
        }
        return s;
    }

    private void createNative(StringReader returnTextStringReader) throws FactoryConfigurationError, IOException, ParserConfigurationException, TransformerException, DBServletException {
        Logger.getLogger("superx_" + this.getMandantenID()).log(Level.INFO, "Native Transformation startet " + this.contenttype);
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dfactory.newDocumentBuilder();
        InputSource is = new InputSource(returnTextStringReader);
        org.w3c.dom.Document mydomres = builder.newDocument();
        try {
            mydomres = builder.parse(is);
        }
        catch (SAXException e1) {
            Logger.getLogger("superx_" + this.getMandantenID()).log(Level.SEVERE, "XML-Strom nicht valide: " + e1.toString());
        }
        Logger.getLogger("superx_" + this.getMandantenID()).log(Level.INFO, "Lese native Datei");
        Node colnode = XMLUtils.getFirstNode(mydomres, "col");
        Node filenode = XMLUtils.getChildNode(colnode, "wert");
        String filename = XMLUtils.getChildNodeValues(filenode);
        String pfad = this.getServletConfig().getServletContext().getRealPath("WEB-INF/downloads/" + filename);
        ByteArrayOutputStream myStream = new ByteArrayOutputStream();
        try {
            int len;
            FileInputStream filestream = new FileInputStream(pfad);
            byte[] buf = new byte[4096];
            while ((len = filestream.read(buf)) > 0) {
                myStream.write(buf, 0, len);
            }
            Logger.getLogger("superx_" + this.getMandantenID()).log(Level.INFO, "Datei " + filename + " erfolgreich gelesen ");
            this.response.setContentType(this.contenttype.substring(this.contenttype.indexOf("native_") + 7));
            this.response.setContentLength(myStream.size());
            this.response.setHeader("Content-disposition", "inline; filename=" + filename);
            ServletOutputStream os = this.response.getOutputStream();
            myStream.writeTo((OutputStream)os);
            os.flush();
            myStream.reset();
        }
        catch (IOException e2) {
            Logger.getLogger("superx_" + this.getMandantenID()).log(Level.INFO, "Native Datei " + pfad + " kann nicht gelesen werden: " + e2.toString());
            e2.printStackTrace();
            throw new DBServletException("Download-Datei " + pfad + " kann nicht gelesen werden." + e2.toString());
        }
    }

    private class XlsStyles {
        private Hashtable styles = new Hashtable();

        XlsStyles(NodeList stylenodes, HSSFWorkbook wb) {
            this.initInternalStyles(wb);
            this.initExternalStyles(stylenodes, wb);
        }

        public Hashtable getHashtable() {
            return this.styles;
        }

        private void initInternalStyles(HSSFWorkbook wb) {
            this.initInternal(wb, "general");
            this.initInternal(wb, "decimal");
            this.initInternal(wb, "integer");
        }

        private void initInternal(HSSFWorkbook wb, String datatype) {
            HSSFCellStyle style = wb.createCellStyle();
            style.setFillBackgroundColor((short)22);
            style.setBorderLeft((short)2);
            style.setBorderRight((short)2);
            style.setBorderTop((short)2);
            style.setBorderBottom((short)2);
            style.setFont(XmlTransformer.this.font_1);
            this.adapt(style, datatype);
            this.styles.put("int" + datatype + "1", style);
            style = wb.createCellStyle();
            style.setFillBackgroundColor((short)22);
            style.setBorderLeft((short)8);
            style.setBorderRight((short)8);
            style.setBorderTop((short)8);
            style.setBorderBottom((short)8);
            style.setFont(XmlTransformer.this.font_2);
            this.styles.put("int" + datatype + "2", style);
            style = wb.createCellStyle();
            style.setFillBackgroundColor((short)22);
            style.setBorderLeft((short)4);
            style.setBorderRight((short)4);
            style.setBorderTop((short)4);
            style.setBorderBottom((short)4);
            this.styles.put("int" + datatype + "3", style);
            style = wb.createCellStyle();
            style.setFillBackgroundColor((short)22);
            style.setBorderLeft((short)4);
            style.setBorderRight((short)4);
            style.setBorderTop((short)4);
            style.setBorderBottom((short)4);
            style.setFont(XmlTransformer.this.font_4);
            this.styles.put("int" + datatype + "4", style);
            style = wb.createCellStyle();
            style.setFillBackgroundColor((short)22);
            style.setBorderLeft((short)4);
            style.setBorderRight((short)4);
            style.setBorderTop((short)4);
            style.setBorderBottom((short)4);
            style.setFont(XmlTransformer.this.font_5);
            this.styles.put("int" + datatype + "5", style);
            style = wb.createCellStyle();
            style.setFillBackgroundColor((short)22);
            style.setBorderLeft((short)2);
            style.setBorderRight((short)2);
            style.setBorderTop((short)2);
            style.setBorderBottom((short)2);
            this.styles.put("int" + datatype + "summe", style);
        }

        private void adapt(HSSFCellStyle style, String datatype) {
            if (datatype.equals("decimal")) {
                style.setAlignment((short)3);
                style.setDataFormat((short)4);
            }
            if (datatype.equals("integer")) {
                style.setAlignment((short)3);
                style.setDataFormat((short)3);
            }
        }

        private void initExternalStyles(NodeList stylenodes, HSSFWorkbook wb) {
            HSSFCellStyle cellStyle = wb.createCellStyle();
            cellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"d-mmm-yy"));
            this.styles.put("body_date", cellStyle);
            String s = null;
            String stylename = null;
            if (stylenodes != null) {
                int anz_tags = stylenodes.getLength();
                int i2 = 0;
                while (i2 < anz_tags) {
                    Node stylenode = stylenodes.item(i2);
                    HSSFCellStyle cs = wb.createCellStyle();
                    HSSFDataFormat format = wb.createDataFormat();
                    stylename = XMLUtils.getAttribValue(stylenode, "name");
                    try {
                        Node fontnode = XMLUtils.getChildNode(stylenode, "xls_font");
                        HSSFFont f2 = wb.createFont();
                        cs.setFont(f2);
                        try {
                            s = XMLUtils.getAttribValue(fontnode, "name");
                            if (s != null) {
                                f2.setFontName(s);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            s = XMLUtils.getAttribValue(fontnode, "height");
                            if (s != null) {
                                f2.setFontHeight(Short.parseShort(s));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            s = XMLUtils.getAttribValue(fontnode, "color");
                            if (s != null) {
                                f2.setColor(XmlTransformer.this.getColorIndex(s));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (XMLUtils.getAttribValue(fontnode, "bold") != null) {
                                f2.setBoldweight((short)700);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (XMLUtils.getAttribValue(fontnode, "underline") != null) {
                                f2.setUnderline((byte)1);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception fontnode) {
                        // empty catch block
                    }
                    Iterator it = XMLUtils.getChildNodeIterator(stylenode);
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        if (n.getLocalName() == "xls_border") {
                            try {
                                s = XMLUtils.getAttribValue(n, "type").toUpperCase();
                                int type = 0;
                                if (s != null) {
                                    if (s.equals("DASH_DOT")) {
                                        type = 9;
                                    }
                                    if (s.equals("DASH_DOT_DOT")) {
                                        type = 11;
                                    }
                                    if (s.equals("DASHED")) {
                                        type = 3;
                                    }
                                    if (s.equals("DOTTED")) {
                                        type = 7;
                                    }
                                    if (s.equals("DOUBLE")) {
                                        type = 6;
                                    }
                                    if (s.equals("HAIR")) {
                                        type = 4;
                                    }
                                    if (s.equals("MEDIUM")) {
                                        type = 2;
                                    }
                                    if (s.equals("MEDIUM_DASH_DOT")) {
                                        type = 10;
                                    }
                                    if (s.equals("MEDIUM_DASHED")) {
                                        type = 8;
                                    }
                                    if (s.equals("NONE")) {
                                        type = 0;
                                    }
                                    if (s.equals("SLANTED_DASH_DOT")) {
                                        type = 13;
                                    }
                                    if (s.equals("THICK")) {
                                        type = 5;
                                    }
                                    if (s.equals("THIN")) {
                                        type = 1;
                                    }
                                }
                                if ((s = XMLUtils.getAttribValue(n, "location").toUpperCase()) != null) {
                                    if (s.equals("BOTTOM")) {
                                        cs.setBorderBottom((short)type);
                                    }
                                    if (s.equals("TOP")) {
                                        cs.setBorderTop((short)type);
                                    }
                                    if (s.equals("LEFT")) {
                                        cs.setBorderLeft((short)type);
                                    }
                                    if (s.equals("RIGHT")) {
                                        cs.setBorderRight((short)type);
                                    }
                                }
                            }
                            catch (Exception type) {
                                // empty catch block
                            }
                        }
                        if (n.getLocalName() == "xls_fill") {
                            try {
                                short c2 = XmlTransformer.this.getColorIndex(XMLUtils.getAttribValue(n, "color"));
                                if (c2 != -999) {
                                    cs.setFillPattern((short)1);
                                    cs.setFillForegroundColor(c2);
                                }
                            }
                            catch (Exception c2) {
                                // empty catch block
                            }
                        }
                        if (n.getLocalName() == "xls_align") {
                            try {
                                s = XMLUtils.getAttribValue(n, "align").toUpperCase();
                                if (s != null) {
                                    if (s.equals("ALIGN_CENTER")) {
                                        cs.setAlignment((short)2);
                                    }
                                    if (s.equals("ALIGN_CENTER_SELECTION")) {
                                        cs.setAlignment((short)6);
                                    }
                                    if (s.equals("ALIGN_FILL")) {
                                        cs.setAlignment((short)4);
                                    }
                                    if (s.equals("ALIGN_GENERAL")) {
                                        cs.setAlignment((short)0);
                                    }
                                    if (s.equals("ALIGN_JUSTIFY")) {
                                        cs.setAlignment((short)5);
                                    }
                                    if (s.equals("ALIGN_LEFT")) {
                                        cs.setAlignment((short)1);
                                    }
                                    if (s.equals("ALIGN_RIGHT")) {
                                        cs.setAlignment((short)3);
                                    }
                                }
                            }
                            catch (Exception c2) {
                                // empty catch block
                            }
                            try {
                                s = XMLUtils.getAttribValue(n, "valign").toUpperCase();
                                if (s != null) {
                                    if (s.equals("VERTICAL_BOTTOM")) {
                                        cs.setVerticalAlignment((short)2);
                                    }
                                    if (s.equals("VERTICAL_CENTER")) {
                                        cs.setVerticalAlignment((short)1);
                                    }
                                    if (s.equals("VERTICAL_JUSTIFY")) {
                                        cs.setVerticalAlignment((short)3);
                                    }
                                    if (s.equals("VERTICAL_TOP")) {
                                        cs.setVerticalAlignment((short)0);
                                    }
                                }
                            }
                            catch (Exception c2) {
                                // empty catch block
                            }
                        }
                        if (n.getLocalName().equals("wrapText")) {
                            cs.setWrapText(true);
                        }
                        if (!n.getLocalName().equals("xls_format")) continue;
                        String formatattrib = XMLUtils.getAttribValue(n, "format");
                        try {
                            cs.setDataFormat(Short.parseShort(formatattrib));
                        }
                        catch (NumberFormatException e2) {
                            cs.setDataFormat(format.getFormat(formatattrib));
                        }
                    }
                    this.styles.put(stylename, cs);
                    ++i2;
                }
            }
        }
    }
}

