/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.util.StringUtils;
import de.memtext.util.TimeUtils;
import de.superx.util.SqlStringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ServletBasics {
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected String sessiontype;

    public static String getParameter(HttpServletRequest request, String name) {
        String p = request.getParameter(name);
        if (p != null && StringUtils.containsTags(p)) {
            throw new IllegalArgumentException("Parameter " + name + " enth\u00e4lt unerlaubte Tags");
        }
        return p;
    }

    protected void checkSessionType() throws NichtAngemeldetException {
        HttpSession session = this.request.getSession();
        if (session == null) {
            throw new NichtAngemeldetException("keine Session gefunden");
        }
        Object test = session.getAttribute("sessiontype");
        if (test == null || !test.toString().equals(this.sessiontype)) {
            throw new NichtAngemeldetException("falscher sessiontype, erwartet:" + this.sessiontype + " gefunden:" + test);
        }
        String usera = (String)session.getAttribute("User-A");
        if (usera == null || !usera.equals("nocheck") && !usera.equals(this.request.getHeader("User-Agent"))) {
            System.out.println("Achtung, Browsertyp hat sich w\u00e4hrend der Session ge\u00e4ndert von " + this.request.getRemoteAddr() + " erwartet" + usera + " gefunden:" + this.request.getHeader("User-Agent"));
        }
    }

    public void sendBackHtml(String txt) throws IOException {
        this.sendBack(txt, "text/html; charset=" + SqlStringUtils.getEncoding());
    }

    protected void sendBack(String txt, String contenttype) throws IOException {
        Object out = null;
        TimeUtils t = new TimeUtils();
        t.start();
        byte[] stuff = txt.getBytes(SqlStringUtils.getEncoding());
        String encoding = this.request.getHeader("Accept-Encoding");
        if (encoding != null && encoding.indexOf("gzip") != -1) {
            this.response.setHeader("Content-Encoding", "gzip");
            out = new GZIPOutputStream((OutputStream)this.response.getOutputStream());
        } else if (encoding != null && encoding.indexOf("compress") != -1) {
            this.response.setHeader("Content-Encoding", "compress");
            out = new ZipOutputStream((OutputStream)this.response.getOutputStream());
        } else {
            this.response.setContentLength(txt.length());
            out = this.response.getOutputStream();
        }
        if (contenttype != null) {
            this.response.setContentType(contenttype);
        }
        ((OutputStream)out).write(stuff);
        ((OutputStream)out).close();
    }

    protected void sendBack(String txt) throws IOException {
        this.sendBack(txt, null);
    }

    protected String getJSessionId() {
        String result = "";
        String test = this.response.encodeURL("testlink");
        if (test.indexOf("jsessionid") > -1) {
            result = test.substring(20);
        }
        return result;
    }

    protected void turnCacheOff() {
        this.response.setHeader("Cache-Control", "no-cache");
        this.response.setHeader("Cache-Control", "no-store");
        this.response.setHeader("Pragma", "no-cache");
        this.response.setHeader("Expires", "0");
    }

    protected void setExpires(int secs) {
        this.response.setHeader("Expires", String.valueOf(secs));
    }

    public ServletBasics(HttpServletRequest request, HttpServletResponse response, String sessiontype) throws IOException {
        this.request = request;
        this.response = response;
        this.setSessiontype(sessiontype);
    }

    protected String getBrowser() {
        String browser = this.request.getHeader("User-Agent");
        if (browser == null) {
            browser = "";
        }
        return browser;
    }

    public Locale getDesiredLocale() {
        String locale_param;
        Locale desiredLocale = this.request.getLocale();
        if (this.request.getSession() != null && this.request.getSession().getAttribute("locale") != null) {
            desiredLocale = new Locale((String)this.request.getSession().getAttribute("locale"));
        }
        if ((locale_param = this.request.getParameter("locale")) != null) {
            desiredLocale = new Locale(locale_param);
        }
        return desiredLocale;
    }

    public String getSessiontype() {
        return this.sessiontype;
    }

    public void setSessiontype(String sessiontype) {
        this.sessiontype = sessiontype;
    }
}

