/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.NamedIdObject;
import de.memtext.time.EphemeralI;
import de.memtext.time.Period;
import de.memtext.util.DateUtils;
import java.text.ParseException;
import java.util.Date;

public class RepositoryItem
extends NamedIdObject
implements EphemeralI {
    private Object content = "";
    private int sort1;
    private int sort2;
    private int sort3;
    private Period validityPeriod;
    private String comment;

    public RepositoryItem() {
        try {
            this.validityPeriod = new Period(DateUtils.parse("1.1.1900"), DateUtils.parse("1.1.3000"));
        }
        catch (ParseException e2) {
            e2.printStackTrace();
        }
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content) {
        this.content = content;
        if (this.content == null) {
            this.content = "";
        }
    }

    public int getAsInt() {
        Integer in = (Integer)this.content;
        return in;
    }

    public void setAsInt(int dummy) {
    }

    public String getCaption() {
        return this.getName();
    }

    public void setCaption(String caption) {
        this.setName(caption);
    }

    public int getSort1() {
        return this.sort1;
    }

    public void setSort1(int sort1) {
        this.sort1 = sort1;
    }

    public int getSort2() {
        return this.sort2;
    }

    public void setSort2(int sort2) {
        this.sort2 = sort2;
    }

    public int getSort3() {
        return this.sort3;
    }

    public void setSort3(int sort3) {
        this.sort3 = sort3;
    }

    @Override
    public String toString() {
        return this.content.toString();
    }

    @Override
    public Date getValidSince() {
        return this.validityPeriod.getFrom();
    }

    @Override
    public Date getValidTill() {
        return this.validityPeriod.getTill();
    }

    @Override
    public void setValidSince(Date date) {
        this.validityPeriod.setFrom(date);
    }

    @Override
    public void setValidTill(Date date) {
        this.validityPeriod.setTill(date);
    }

    @Override
    public boolean isValidAt(Date date) {
        return this.validityPeriod.isInPeriod(date);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

