/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.ExceptionHandler;
import de.memtext.util.GetOpts;
import de.superx.bin.SxJdbcClient;
import de.superx.bin.SxTransformer;
import de.superx.util.SqlStringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;

public class Doschema {
    Connection myDb;
    Statement st;
    Statement updateSt;
    DatabaseMetaData dbmd;
    boolean done = false;
    String delim = "";
    String header = "false";
    String logfile = "../conf/logging.properties";
    String dbpropfile = "./conf/db.properties";
    String tabelle = "";
    String outFormat = "xml";
    Logger logger = Logger.getLogger(Doschema.class.toString());
    private ExceptionHandler exceptionHandler = new ExceptionHandler(false);
    private static String usage = "-------------------------------------\nGebrauch: java de.superx.bin.Doschema -logger:<<Pfad zu logging.properties>> -dbproperties:<<Pfad zu db.properties>> -table:<Tabelle> -outFormat:<Ausgabeformat (xml | HIS | pg | ids | ansi ) -outfile:<Ausgabedatei>(optional) \n---------------------------------------------------";

    public Doschema(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        String outfile = "";
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent("-logger,-dbproperties");
        if (isdrin != null) {
            System.err.println("Folgende Optionen fehlen: " + isdrin);
            System.err.println(usage);
            System.exit(1);
        }
        if (GetOpts.isPresent("-logger")) {
            this.logfile = GetOpts.getValue("-logger");
        }
        if (GetOpts.isPresent("-dbproperties")) {
            this.dbpropfile = GetOpts.getValue("-dbproperties");
        }
        if (GetOpts.isPresent("-table")) {
            this.tabelle = GetOpts.getValue("-table");
        }
        if (GetOpts.isPresent("-outFormat")) {
            this.outFormat = GetOpts.getValue("-outFormat");
        }
        if (GetOpts.isPresent("-outfile")) {
            outfile = GetOpts.getValue("-outfile");
        }
        File f2 = new File(this.logfile);
        String confPath = f2.getParent();
        if (!f2.exists()) {
            throw new IOException("Datei nicht gefunden: " + this.logfile);
        }
        FileInputStream ins = new FileInputStream(this.logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        this.logfile = MyLogManager.getProperty(".level");
        this.logger.info("Using Loggging-Level " + this.logfile);
        this.logger.config("Getting Schema.");
        SxJdbcClient myClient = new SxJdbcClient(this.logger, this.dbpropfile);
        this.logger.config("Tabellenkatalog f\u00fcr " + this.tabelle);
        String zs = "";
        zs = "<?xml version='1.0' encoding='" + SqlStringUtils.getEncoding() + "'?>" + "\n";
        zs = String.valueOf(zs) + myClient.getTableSchema(this.tabelle) + "\n";
        SxTransformer myTransformer = null;
        myTransformer = outfile.equals("") ? new SxTransformer(this.logger, System.out) : new SxTransformer(this.logger, new FileWriter(outfile));
        myTransformer.quellstring = zs;
        if (this.outFormat.equals("his")) {
            myTransformer.stylesheet = String.valueOf(confPath) + System.getProperty("file.separator") + "tabschema_his.xsl";
            try {
                myTransformer.transformString("xml");
            }
            catch (TransformerException e2) {
                this.logger.severe("XSL-Transformation fehlgeschlagen:" + e2.toString());
                this.exceptionHandler.handle(e2);
            }
            catch (Exception e3) {
                this.logger.severe("XSL-Transformation fehlgeschlagen:" + e3.toString());
                this.exceptionHandler.handle(e3);
            }
        } else if (this.outFormat.equals("pg") || this.outFormat.equals("ids") || this.outFormat.equals("ansi")) {
            myTransformer.stylesheet = String.valueOf(confPath) + System.getProperty("file.separator") + "tabschema_sql_" + this.outFormat + ".xsl";
            myTransformer.format = this.outFormat;
            try {
                myTransformer.transformString("text");
            }
            catch (TransformerException e4) {
                this.logger.severe("XSL-Transformation nach sql fehlgeschlagen:" + e4.toString());
                this.exceptionHandler.handle(e4);
            }
            catch (Exception e5) {
                this.logger.severe("XSL-Transformation nach sql fehlgeschlagen:" + e5.toString());
                this.exceptionHandler.handle(e5);
            }
        } else {
            myTransformer.outputString();
        }
        this.logger.info("Now closing the connection");
        myClient.close();
    }

    public static void instructions() {
        System.out.println("SuperX @version@\n");
        System.out.println("\nDieses Javaprogramm gibt des Schema einer Tabelle aus");
        System.out.println("Im Classpath muss superx-db.jar,sowie der zugeh\u00f6rige jdbc-Treiber sein.");
        System.out.println("Befehl:\n java doschema <Tabellenname> <Ausgabeformat (txt|xml)>(optional) <delimiter>(optional) <Ausgabe der Feld\u00fcberschriften (optional, true oder false). <Ausgabedatei>(optional)");
        System.out.println("Der Logging-Level wird in ../conf/logging.properties konfiguriert, der DB-Zugriff in ../conf/db.properties ");
        System.out.println("Default:\n java -cp .:$JDBC_CLASSPATH de.superx.bin.Doschema $LOGGER_PROPERTIES $DB_PROPERTIES $tabelle ansi");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            Doschema.instructions();
        }
        try {
            Doschema test = new Doschema(args);
        }
        catch (Exception ex) {
            System.err.println("Exception caught.\n" + ex);
            ex.printStackTrace();
        }
    }
}

