/*
 * Decompiled with CFR 0.152.
 */
package de.superx.applet;

import de.memtext.util.DateUtils;
import de.memtext.util.StringUtils;
import de.memtext.widgets.WarningMessage;
import de.superx.applet.SichtApplet;
import de.superx.applet.SxDefaults;
import de.superx.applet.SxField;
import de.superx.applet.SxForm;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;

public class SxUtils {
    public static final int bufSize = 32768;
    public static final String errString = "--ERROR--";
    private static String COMM_START = "/*";
    private static String COMM_END = "*/";
    private static int COMM_START_LEN = COMM_START.length();
    private static int COMM_END_LEN = COMM_END.length();
    private static String COMMENT1_ANF = "{";
    private static String COMMENT1_END = "}";
    private static String COMMENT2_ANF = "--";
    private static String COMMENT2_END = "\n";
    private static String COMMENT3_ANF = "/*";
    private static String COMMENT3_END = "*/";
    private static String COMMENT1_ANF_MASK = "#K#";
    private static String COMMENT1_END_MASK = "#/K";
    private static String COMMENT2_ANF_MASK = "#S#";
    private static String COMMENT2_END_MASK = "#/S#";
    private static String COMMENT3_ANF_MASK = "#*A#";
    private static String COMMENT3_END_MASK = "#*E#";
    private static String PREV_POS = ">>";
    private static String PREV_POS_MASK = ">#>";
    private static String NEXT_POS = "<<";
    private static String NEXT_POS_MASK = "<#<";
    private static String SELECT_DELIMITER = ";";
    private static String SELECT_DELIMITER_MASK = "^";
    private static String STR_DELIMITER1 = "\"";
    private static String STR_DELIMITER1_MASK = "#s1#";
    private static String STR_DELIMITER2 = "'";
    private static String STR_DELIMITER2_MASK = "#s2#";
    private static StringBuffer buffer = new StringBuffer(32768);
    private static String prev_str;

    public static synchronized void setFieldDelimiter(String field_start, String field_end) {
        if (field_start != null) {
            NEXT_POS = field_start.length() == 0 ? "" : field_start.substring(0, field_start.length() - 1);
        }
        if (field_end != null) {
            PREV_POS = field_end.length() == 0 ? "" : field_end.substring(0, field_end.length() - 1);
        }
    }

    public static String getFieldPrefix() {
        return new String(NEXT_POS);
    }

    public static String getFieldSuffix() {
        return new String(PREV_POS);
    }

    public static synchronized void setComment(String comm_start, String comm_end) {
        if (comm_start != null) {
            COMM_START = comm_start;
            COMM_START_LEN = comm_start.length();
        }
        if (comm_end != null) {
            COMM_END = comm_end;
            COMM_END_LEN = comm_end.length();
        }
    }

    private static String noappletout(String sql_str) {
        while (sql_str != null && sql_str.indexOf("--notinapplet") > -1) {
            int pos = sql_str.indexOf("--notinapplet");
            String prev = sql_str.substring(0, pos);
            if (prev.lastIndexOf("/*") == -1) {
                throw new IllegalStateException("--notinapplet muss eingeschlossen sein von /* */, nicht " + sql_str);
            }
            prev = prev.substring(0, prev.lastIndexOf("/*") - 1);
            if (sql_str.indexOf("*/", pos) == -1) {
                throw new IllegalStateException("--notinapplet muss eingeschlossen sein von /* */, nicht " + sql_str);
            }
            String post = sql_str.substring(sql_str.indexOf("*/", pos) + 2);
            sql_str = String.valueOf(prev) + "\n" + post;
        }
        return sql_str;
    }

    static synchronized String generateSQL(SxForm sxform, String sqlStatement) {
        Object obj = null;
        sqlStatement = SxUtils.noappletout(sqlStatement);
        sqlStatement = SxUtils.replace(sqlStatement, "<<erlaubt>>", sxform.isErlaubt() ? "1" : "0");
        Hashtable hashtable = sxform.getMap();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String fieldname = (String)enumeration.nextElement();
            if (!fieldname.startsWith("F_")) continue;
            SxField sxField = sxform.getField(fieldname);
            String fieldKey = sxform.getFieldKey("F_" + fieldname.substring(2));
            if (fieldKey != null) {
                sqlStatement = SxUtils.replace(sqlStatement, String.valueOf(SxUtils.getFieldPrefix()) + fieldname.substring(2) + SxUtils.getFieldSuffix(), fieldKey);
            }
            if (!sxField.hasSichten()) continue;
            SichtApplet sicht = sxField.getSelectedSicht();
            sqlStatement = SxUtils.replace(sqlStatement, "<<" + sicht.getArt() + ">>", sicht.getId().toString());
            sqlStatement = SxUtils.replace(sqlStatement, "<<" + sxField.getName().substring(2) + "-Sicht>>", sicht.getId().toString());
            String sx_db = (String)SxDefaults.getPropertyValue("SxDB");
            Date date = null;
            try {
                date = DateUtils.parse(sicht.getStand());
            }
            catch (ParseException e2) {
                e2.printStackTrace();
                WarningMessage.show(null, "Datum " + sicht.getStand() + " der Sicht konnte nicht interpretiert werden", "SuperX");
            }
            String replaceStr = null;
            replaceStr = sx_db.equals("Postgres") ? "date_val('" + DateUtils.formatGerman(date) + "')" : "date('" + DateUtils.formatGerman(date) + "')";
            String search = "<<" + sicht.getArt() + "Stand>>";
            sqlStatement = SxUtils.replace(sqlStatement, search, replaceStr);
            if (sicht.getArt() != null && sicht.getArt().endsWith("Sicht")) {
                search = "<<" + StringUtils.removeFromEnd(sicht.getArt(), "Sicht", true) + "Stand>>";
                sqlStatement = SxUtils.replace(sqlStatement, search, replaceStr);
            }
            search = "<<" + sxField.getName().substring(2) + "-Stand>>";
            sqlStatement = SxUtils.replace(sqlStatement, search, replaceStr);
        }
        String sx_db = (String)SxDefaults.getPropertyValue("SxDB");
        String replaceStr = "IDS";
        if (sx_db.equals("Postgres")) {
            replaceStr = "PG";
        }
        sqlStatement = sqlStatement.replaceAll("<<DATABASE_ABBR>>", replaceStr);
        sqlStatement = sqlStatement.replaceAll("<<Organigramm-Stand>>", "today()");
        sqlStatement = SxUtils.deleteComment(sqlStatement, "/*", "*/");
        sqlStatement = SxUtils.deleteComment(sqlStatement, "--", "\n");
        boolean i2 = true;
        return sqlStatement;
    }

    private static String deleteComment(String str, String comm_start_str, String comm_end_str) {
        String search_str = comm_start_str;
        int comm_end = -1;
        int pos = -1;
        int offset = 0;
        int len = str.length();
        int search_len = search_str.length();
        StringBuffer lbuffer = new StringBuffer();
        while (offset < len) {
            pos = str.indexOf(search_str, offset);
            if (pos != -1) {
                if (pos > 0 && comm_start_str.equals("{") && str.charAt(pos - 1) == '$') {
                    lbuffer.append(str.substring(offset, pos + 1));
                    offset = pos + 1;
                    continue;
                }
                prev_str = str.substring(offset, pos);
                comm_end = str.indexOf(comm_end_str, pos + search_len);
                if (comm_end == -1) {
                    comm_end = str.length() - 1;
                }
                lbuffer.append(prev_str);
                offset = comm_end + comm_end_str.length();
                continue;
            }
            lbuffer.append(str.substring(offset, len));
            offset = len;
        }
        return lbuffer.toString();
    }

    public static synchronized String replace(String str, String search_str, String replace_str) {
        boolean delete_comment = false;
        int pos = -1;
        int offset = 0;
        int len = str.length();
        int search_len = search_str.length();
        int comm_start = -1;
        int comm_end = -1;
        int prev_pos = -1;
        int next_pos = -1;
        int mode = -1;
        try {
            delete_comment = replace_str.equals("");
            block7: while (offset < len) {
                mode = -1;
                pos = str.indexOf(search_str, offset);
                if (pos != -1) {
                    prev_str = str.substring(offset, pos);
                    comm_start = prev_str.lastIndexOf(COMM_START);
                    prev_pos = prev_str.lastIndexOf(PREV_POS);
                    comm_end = str.indexOf(COMM_END, pos + search_len);
                    next_pos = str.indexOf(NEXT_POS, pos + search_len);
                    if (comm_start >= 0 && prev_pos >= 0 && comm_start < prev_pos) {
                        comm_start = -1;
                    }
                    if (comm_end >= 0 && next_pos >= 0 && comm_end > next_pos) {
                        comm_end = -1;
                    }
                    mode = comm_start != -1 && comm_end != -1 && comm_start <= pos && comm_end >= pos ? (delete_comment ? 2 : 1) : 0;
                    switch (mode) {
                        case 0: {
                            buffer.append(prev_str);
                            buffer.append(replace_str);
                            offset = pos + search_len;
                            continue block7;
                        }
                        case 1: {
                            buffer.append(prev_str.substring(0, comm_start));
                            buffer.append(prev_str.substring(comm_start + COMM_START_LEN));
                            buffer.append(replace_str);
                            buffer.append(str.substring(pos + search_len, comm_end));
                            offset = comm_end + COMM_END_LEN;
                            continue block7;
                        }
                        case 2: {
                            buffer.append(prev_str.substring(0, comm_start));
                            offset = comm_end + COMM_END_LEN;
                            continue block7;
                        }
                        default: {
                            throw new Exception(errString);
                        }
                    }
                }
                buffer.append(str.substring(offset, len));
                offset = len;
            }
        }
        catch (Exception e2) {
            buffer.append(errString);
            buffer.append(search_str);
        }
        String return_str = buffer.toString();
        buffer.setLength(0);
        return return_str;
    }

    public static synchronized String replaceString(String str, String search_str, String replace_str) {
        String zs = "";
        int offset = 0;
        int pos = str.indexOf(search_str, offset);
        while (pos > -1) {
            zs = String.valueOf(zs) + str.substring(offset, pos);
            zs = String.valueOf(zs) + replace_str;
            offset = pos + search_str.length();
            pos = str.indexOf(search_str, offset);
        }
        zs = String.valueOf(zs) + str.substring(offset, str.length());
        return zs;
    }

    public static synchronized String escapeString(String str) {
        str = SxUtils.replaceString(str, PREV_POS, PREV_POS_MASK);
        str = SxUtils.replaceString(str, NEXT_POS, NEXT_POS_MASK);
        str = SxUtils.replaceString(str, SELECT_DELIMITER, SELECT_DELIMITER_MASK);
        str = SxUtils.replaceString(str, STR_DELIMITER1, STR_DELIMITER1_MASK);
        str = SxUtils.replaceString(str, STR_DELIMITER2, STR_DELIMITER2_MASK);
        str = SxUtils.replaceString(str, COMMENT1_ANF, COMMENT1_ANF_MASK);
        str = SxUtils.replaceString(str, COMMENT2_ANF, COMMENT2_ANF_MASK);
        str = SxUtils.replaceString(str, COMMENT3_ANF, COMMENT3_ANF_MASK);
        str = SxUtils.replaceString(str, COMMENT1_END, COMMENT1_END_MASK);
        String escapeString = str = SxUtils.replaceString(str, COMMENT3_END, COMMENT3_END_MASK);
        return escapeString;
    }

    public static synchronized String unescapeString(String str) {
        str = SxUtils.replaceString(str, PREV_POS_MASK, PREV_POS);
        str = SxUtils.replaceString(str, NEXT_POS_MASK, NEXT_POS);
        str = SxUtils.replaceString(str, STR_DELIMITER1_MASK, STR_DELIMITER1);
        str = SxUtils.replaceString(str, STR_DELIMITER2_MASK, "\\'");
        str = SxUtils.replaceString(str, COMMENT1_ANF_MASK, COMMENT1_ANF);
        str = SxUtils.replaceString(str, COMMENT2_ANF_MASK, COMMENT2_ANF);
        str = SxUtils.replaceString(str, COMMENT3_ANF_MASK, COMMENT3_ANF);
        str = SxUtils.replaceString(str, COMMENT1_END_MASK, COMMENT1_END);
        String unescapeString = str = SxUtils.replaceString(str, COMMENT3_END_MASK, COMMENT3_END);
        return unescapeString;
    }

    public static synchronized String escapeSpecialChars(String str) {
        str = SxUtils.replaceString(str, SELECT_DELIMITER, "\\" + SELECT_DELIMITER);
        str = SxUtils.replaceString(str, STR_DELIMITER1, "\\" + STR_DELIMITER1);
        String escapeSpecialChars = str = SxUtils.replaceString(str, STR_DELIMITER2, "\\" + STR_DELIMITER2);
        return escapeSpecialChars;
    }

    public static synchronized String getValueAsString(Object value) {
        String field_type = "";
        String f_wert = "";
        String fehler = "";
        try {
            f_wert = value instanceof Date ? DateFormat.getDateInstance(2, Locale.GERMANY).format(value) : (value instanceof Timestamp ? DateFormat.getDateTimeInstance(2, 2, Locale.GERMANY).format(value) : (value instanceof Time ? DateFormat.getTimeInstance(2, Locale.GERMANY).format(value) : value.toString()));
        }
        catch (Exception e2) {
            fehler = e2.toString();
            f_wert = fehler.equals("java.lang.NullPointerException") ? "" : "Feldtyp unbekannt:" + fehler;
        }
        return f_wert;
    }

    public static void main(String[] args) {
        System.out.println(SxUtils.noappletout("11764^Projekt^4^0^0^100^300^1^char^4^0^1^<<SQL>> /* execute procedure sp_user_orga_child(<<UserID>>,mdy (1, 1,year(<<Organigramm-Stand>>)),<<Organigramm-Sicht>>,<<Institution>>, <<erlaubt>>); --notinxmlfrontend */ /* execute procedure sp_user_orga(<<UserID>>,mdy (1, 1,year<<Organigramm-Stand>>)),<<Organigramm-Sicht>>); --notinapplet */ select distinct fb, fb ||  || ktobez from mbs_projekte_konto where 1=1 and inst_nr in (select ch110_institut from tmp_ch110_institut) /* and dr in (<<Deckungsring>>)  */ /* and jahr = <<Haushaltsjahr>> */ /* and kap in (<<Kapitel>>) */ order by 2;^ ^^"));
        System.exit(1);
        String sql_str = null;
        Object search_str = null;
        Object replace_str = null;
        Properties props = new Properties();
        if (args.length != 2) {
            System.err.println("Usage: <filename> <propertyfile>");
            System.exit(1);
        }
        String filename = "/" + args[0];
        String propname = "/" + args[1];
        try {
            byte[] buf = new byte[32768];
            byte[] data = new byte[32768];
            int read_len = 0;
            int data_len = 0;
            InputStream is = props.getClass().getResourceAsStream(filename);
            if (is == null) {
                System.err.println("Resource '" + filename + "' not found");
                System.exit(1);
            }
            while (read_len != -1) {
                read_len = is.read(buf, 0, buf.length);
                if (read_len == -1) continue;
                data_len = read_len;
            }
            is.close();
            data = new byte[data_len];
            System.arraycopy(buf, 0, data, 0, data_len);
            sql_str = new String(data);
            is = props.getClass().getResourceAsStream(propname);
            if (is == null) {
                System.err.println("Resource '" + propname + "' not found");
                System.exit(1);
            }
            props.load(is);
            is.close();
            Enumeration<?> en = props.propertyNames();
            System.err.println("sql ... ");
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = props.getProperty(key);
                key = "<<" + key + ">>";
                System.err.println("Key: " + key + " = " + value);
                sql_str = SxUtils.replace(sql_str, key, value);
            }
            sql_str = SxUtils.deleteComment(sql_str, "--", "\n");
            sql_str = SxUtils.deleteComment(sql_str, "/*", "*/");
        }
        catch (FileNotFoundException e2) {
            System.err.println(e2);
            System.exit(1);
        }
        catch (SecurityException e3) {
            System.err.println(e3);
            System.exit(1);
        }
        catch (IOException e4) {
            System.err.println(e4);
            System.exit(1);
        }
        System.err.println("done");
    }
}

