/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    protected EventListenerList listenerList = new EventListenerList();
    protected Object value;
    protected ChangeEvent changeEvent = null;
    protected int clickCountToStart = 1;

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    public void setCellEditorValue(Object value) {
        this.value = value;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return !(anEvent instanceof MouseEvent) || ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.isCellEditable(anEvent) && (anEvent == null || ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart);
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l2) {
        this.listenerList.add(CellEditorListener.class, l2);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l2) {
        this.listenerList.remove(CellEditorListener.class, l2);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return null;
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        int i2 = listeners.length - 2;
        while (i2 >= 0) {
            if (listeners[i2] == CellEditorListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i2 + 1]).editingStopped(this.changeEvent);
            }
            i2 -= 2;
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        int i2 = listeners.length - 2;
        while (i2 >= 0) {
            if (listeners[i2] == CellEditorListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i2 + 1]).editingCanceled(this.changeEvent);
            }
            i2 -= 2;
        }
    }
}

