/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.rights;

import de.memtext.rights.RightsKeyEntry;
import de.memtext.util.EqualsUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class Rights
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isAdmin = false;
    private boolean hasAllRights;
    private Collection keyColl = new TreeSet();

    public Rights() {
    }

    public Rights(boolean isAdmin, boolean hasAllRights) {
        this.setAdmin(isAdmin);
        this.setHasAllRights(hasAllRights);
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void addAllowed(RightsKeyEntry rke) {
        this.keyColl.add(rke);
    }

    public void clear() {
        this.keyColl.clear();
    }

    public boolean isEmpty() {
        return this.keyColl.isEmpty();
    }

    public Iterator iterator() {
        return this.keyColl.iterator();
    }

    public boolean hasAllRights() {
        return this.hasAllRights;
    }

    public void setHasAllRights(boolean b2) {
        this.hasAllRights = b2;
    }

    public boolean isAllowed(Object id) {
        boolean result = false;
        if (this.isAdmin || this.hasAllRights()) {
            result = true;
        } else {
            for (RightsKeyEntry entry : this.keyColl) {
                if (!EqualsUtil.areEqual(entry.getKey(), id)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean isSubordinatesAllowed(Object key) {
        boolean result = false;
        if (this.isAdmin || this.hasAllRights()) {
            result = true;
        } else {
            for (RightsKeyEntry entry : this.keyColl) {
                if (!EqualsUtil.areEqual(entry.getKey(), key)) continue;
                result = entry.isSubordinatesAllowed();
                break;
            }
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        Rights cl = new Rights(this.isAdmin, this.hasAllRights);
        for (RightsKeyEntry key : this.keyColl) {
            cl.keyColl.add(key.clone());
        }
        return cl;
    }
}

