/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.db.DB;
import de.memtext.db.DataSource;
import de.memtext.observ.DocumentListenerObserver;
import de.memtext.widgets.InfoMessage;
import de.memtext.widgets.LabeledPasswordField;
import de.memtext.widgets.LabeledTextField;
import de.memtext.widgets.MultilineEditPanel;
import de.memtext.widgets.WarningMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DataSourceEditPanel
extends MultilineEditPanel {
    private DataSource ds;
    private LabeledTextField hostField = new LabeledTextField("Host", 10);
    private LabeledTextField serverField = new LabeledTextField("Server", 10);
    private LabeledTextField serviceField = new LabeledTextField("Service", 10);
    private LabeledTextField odbcSourceField = new LabeledTextField("Odbc-DSN", 10);
    private LabeledTextField usernameField = new LabeledTextField("Kennung", 10);
    private LabeledTextField passwordField = new LabeledPasswordField("Password", 10);
    private JPanel pButtons = new JPanel();

    public DataSourceEditPanel() {
        this.setBackground(null);
        this.odbcSourceField.setValue("sospos");
        this.odbcSourceField.setBackground(null);
        this.usernameField.setValue("admin");
        this.add(this.hostField);
        this.add(this.serverField);
        this.add(this.serviceField);
        this.add(this.odbcSourceField);
        this.add(this.usernameField);
        this.add(this.passwordField);
        JButton btnTesten = new JButton("testen");
        btnTesten.setBackground(null);
        this.pButtons.setBackground(null);
        btnTesten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DataSourceEditPanel.this.test();
            }
        });
        this.pButtons.add(btnTesten);
        this.add(this.pButtons);
    }

    public void setDataSource(DataSource ds) {
        this.ds = ds;
        this.setMode(ds.getDb());
    }

    public void addButton(JButton btn) {
        this.pButtons.add(btn);
    }

    private void setMode(DB db) {
        if (db.equals(DB.ACCESS)) {
            this.odbcSourceField.setVisible(true);
            this.hostField.setVisible(false);
            this.serverField.setVisible(false);
            this.serviceField.setVisible(false);
        }
        if (db.equals(DB.INFORMIX)) {
            this.odbcSourceField.setVisible(false);
            this.hostField.setVisible(true);
            this.serverField.setVisible(true);
            this.serviceField.setVisible(true);
        }
    }

    protected void test() {
        this.updateDataSource();
        try {
            this.ds.testConnection();
            InfoMessage.show((Component)this, "Verbindung erfolgreich aufgebaut", "Erfolg");
        }
        catch (SQLException e2) {
            if (this.ds.getDb().equals(DB.ACCESS)) {
                WarningMessage.show((Component)this, "Verbindung zur ODBC-Quelle " + this.odbcSourceField.getValue() + " konnte nicht aufgebaut werden.\n" + e2, "Achtung");
            }
        }
        catch (ClassNotFoundException e3) {
            WarningMessage.show((Component)this, "Ben\u00f6tigte Treiber-Klase nicht gefunden ", "Achtung");
        }
    }

    public void updateDataSource() {
        if (this.ds.getDb() == DB.ACCESS) {
            this.ds.setUrl("jdbc:odbc:" + this.odbcSourceField.getValue());
        }
        this.ds.setUsername(this.usernameField.getValue().toString());
        this.ds.setPassword("");
    }

    public void addDocumentListener(DocumentListenerObserver listener) {
        this.hostField.addDocumentListener(listener);
        this.serverField.addDocumentListener(listener);
        this.serviceField.addDocumentListener(listener);
        this.odbcSourceField.addDocumentListener(listener);
        this.usernameField.addDocumentListener(listener);
        this.passwordField.addDocumentListener(listener);
    }
}

