/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AddProc {
    private static DateFormat dfUS = new SimpleDateFormat("yyyy-MM-dd");

    private AddProc() {
    }

    public static String copyFrom(Connection con, String table, String file, String options) throws SQLException {
        if (table == null || table.equals("")) {
            throw new IllegalArgumentException("Table must not be null or empty");
        }
        if (file == null || file.equals("")) {
            throw new IllegalArgumentException("File must not be null or empty");
        }
        File f2 = new File(file);
        if (!f2.exists()) {
            throw new IllegalArgumentException("source file " + file + " doesn't exist");
        }
        String tableNameInMetaData = table.startsWith("\"") ? table.substring(1, table.length() - 1) : table.toUpperCase();
        StringBuffer buf = new StringBuffer("create temp text table TMP_COPYFROM(");
        ResultSet rs = con.getMetaData().getColumns(null, null, tableNameInMetaData, null);
        boolean tableFound = false;
        while (rs.next()) {
            tableFound = true;
            String colname = rs.getObject(4).toString();
            String coltype = rs.getObject(6).toString();
            buf.append(String.valueOf(colname) + " " + coltype + ",");
        }
        rs.close();
        if (!tableFound) {
            throw new SQLException("Copy from failed - table " + table + " not found");
        }
        buf.deleteCharAt(buf.lastIndexOf(","));
        buf.append("); SET TABLE TMP_COPYFROM SOURCE \"" + file);
        if (options != null) {
            buf.append(";" + options);
        }
        buf.append("\";");
        buf.append("insert into " + table + " select * from TMP_COPYFROM");
        System.out.println(buf);
        Statement stmt = con.createStatement();
        try {
            stmt.execute(buf.toString());
            return "success";
        }
        finally {
            stmt.execute("drop table TMP_COPYFROM IF EXISTS");
        }
    }

    public static String toDate(String year, String month, String day) throws ParseException {
        Date d2 = dfUS.parse(String.valueOf(year.trim()) + "-" + month.trim() + "-" + day.trim());
        String result = dfUS.format(d2);
        return result;
    }

    public static String toDate(String year, int month, int day) throws ParseException {
        return AddProc.toDate(String.valueOf(year), String.valueOf(month), String.valueOf(day));
    }

    public static String toDate(int year, int month, int day) throws ParseException {
        return AddProc.toDate(String.valueOf(year), String.valueOf(month), String.valueOf(day));
    }

    public static void main(String[] a2) {
        Connection conn = null;
        try {
            try {
                Class.forName("org.hsqldb.jdbcDriver");
                conn = DriverManager.getConnection("jdbc:hsqldb:test", "sa", "");
                Statement stmt = conn.createStatement();
                stmt.execute("drop table \"test\" if exists;create table \"test\" (col1 integer,col2 varchar, col3 double,col4 date)");
                AddProc.copyFrom(conn, "\"test\"", "test.csv", "fs=;");
                System.out.println("2");
                AddProc.copyFrom(conn, "\"test\"", "test.csv", "fs=;");
                stmt.close();
            }
            catch (ClassNotFoundException e2) {
                e2.printStackTrace();
                try {
                    conn.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            catch (SQLException e3) {
                e3.printStackTrace();
                try {
                    conn.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }
}

