/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jns;

import com.informix.jns.FileSqlhosts;
import com.informix.jns.IfxJNSException;
import com.informix.jns.ServerGroup;
import com.informix.jns.ServerInfo;
import com.informix.util.IfxErrMsg;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapSqlhosts {
    static String NSNETTYPE = "dsf1_nettype";
    static String NSHOSTNAME = "dsf1_hostname";
    static String NSSERVICE = "dsf1_service";
    static String NSOPTIONS = "dsf1_options";
    static String LDAP_VERSION = "3";
    static String LDAP_INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";
    static String LDAP_FILTER = "objectclass=*";
    static String LDAP_DEF_AUTH = "none";
    static String LDAP_DEF_URL = "ldap://localhost:389";
    static String LDAP_DEF_IFXBASE = "cn=Informix,cn=Software,o=Informix,c=US";
    static String LDAP_AUTH_SIMPLE = "simple";
    static String LDAP_SQHRDN = "cn=sqlhosts";
    static int LDAP_SCOPE0 = 0;
    static int LDAP_SCOPE1 = 1;
    static int LDAP_SCOPE2 = 2;
    private DirContext sqhctx;
    private String ldap_ifxDn;
    private String ldap_sqhDn;
    private String ldap_sqhrdn;
    private String ldap_sqhName;
    private String ClientLocale = null;
    private Properties sqhEnv;

    public LdapSqlhosts(Properties properties) throws IfxJNSException {
        this.sqhEnv = properties;
        this.ClientLocale = properties.getProperty("CLIENT_LOCALE");
        String string = properties.getProperty("LDAP_URL");
        if (string == null) {
            string = LDAP_DEF_URL;
        }
        if ((this.ldap_ifxDn = properties.getProperty("LDAP_IFXBASE")) == null) {
            this.ldap_ifxDn = LDAP_DEF_IFXBASE;
        }
        if ((this.ldap_sqhrdn = properties.getProperty("LDAP_SQHRDN")) == null) {
            this.ldap_sqhrdn = LDAP_SQHRDN;
        }
        String string2 = LDAP_DEF_AUTH;
        String string3 = properties.getProperty("LDAP_USER");
        if (string3 != null) {
            string2 = LDAP_AUTH_SIMPLE;
        }
        String string4 = properties.getProperty("LDAP_PASSWD");
        Properties properties2 = new Properties();
        properties2.put("java.naming.factory.initial", LDAP_INITCTX);
        properties2.put("java.naming.ldap.version", LDAP_VERSION);
        properties2.put("java.naming.provider.url", string);
        properties2.put("java.naming.security.authentication", string2);
        if (string2.equalsIgnoreCase(LDAP_AUTH_SIMPLE)) {
            properties2.put("java.naming.security.principal", string3);
            properties2.put("java.naming.security.credentials", string4);
        }
        this.ldap_sqhDn = this.ldap_sqhrdn + "," + this.ldap_ifxDn;
        this.ldap_sqhName = this.ldap_sqhrdn.substring(this.ldap_sqhrdn.indexOf(61) + 1);
        try {
            this.sqhctx = new InitialDirContext(properties2);
        }
        catch (NamingException namingException) {
            throw IfxErrMsg.getLocIfxJNSException(-80282, this.ClientLocale);
        }
    }

    public ServerInfo getServer(String string) throws IfxJNSException {
        String string2 = "default_nettype";
        String string3 = "default_hostname";
        String string4 = "default_service";
        String string5 = "default_options";
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(LDAP_SCOPE0);
            String string6 = "cn=" + string + "," + this.ldap_sqhDn;
            NamingEnumeration<SearchResult> namingEnumeration = this.sqhctx.search(string6, LDAP_FILTER, searchControls);
            if (namingEnumeration != null && namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                NamingEnumeration<? extends Attribute> namingEnumeration2 = attributes.getAll();
                while (namingEnumeration2.hasMoreElements()) {
                    Attribute attribute = namingEnumeration2.next();
                    String string7 = attribute.getID();
                    NamingEnumeration<?> namingEnumeration3 = attribute.getAll();
                    if (string7.compareTo(NSNETTYPE) == 0) {
                        string2 = (String)namingEnumeration3.nextElement();
                        continue;
                    }
                    if (string7.compareTo(NSHOSTNAME) == 0) {
                        string3 = (String)namingEnumeration3.nextElement();
                        continue;
                    }
                    if (string7.compareTo(NSSERVICE) == 0) {
                        string4 = (String)namingEnumeration3.nextElement();
                        continue;
                    }
                    if (string7.compareTo(NSOPTIONS) != 0) continue;
                    string5 = (String)namingEnumeration3.nextElement();
                }
                return new ServerInfo(string, string2, string3, string4, string5);
            }
        }
        catch (NamingException namingException) {
            throw IfxErrMsg.getLocIfxJNSException(-25555, this.ClientLocale);
        }
        throw IfxErrMsg.getLocIfxJNSException(-80283, this.ClientLocale);
    }

    public ServerGroup getServerGroup(String string) throws IfxJNSException {
        Vector<String> vector = new Vector<String>();
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(LDAP_SCOPE1);
            String string2 = string.length() == 0 ? this.ldap_sqhDn : "cn=" + string + "," + this.ldap_sqhDn;
            NamingEnumeration<SearchResult> namingEnumeration = this.sqhctx.search(string2, LDAP_FILTER, searchControls);
            while (namingEnumeration != null && namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                String string3 = searchResult.getName();
                vector.addElement(string3.substring(3));
            }
        }
        catch (NamingException namingException) {
            throw IfxErrMsg.getLocIfxJNSException(-25555, this.ClientLocale);
        }
        return new ServerGroup(vector);
    }

    public ServerGroup listServers() throws IfxJNSException {
        return this.getServerGroup("");
    }

    void addServer(ServerInfo serverInfo) throws IfxJNSException {
        String string = serverInfo.getSname();
        String string2 = serverInfo.getNettype();
        String string3 = serverInfo.getHostname();
        String string4 = serverInfo.getService();
        String string5 = serverInfo.getOptfield();
        BasicAttribute basicAttribute = new BasicAttribute("objectclass", "extensibleobject");
        BasicAttribute basicAttribute2 = new BasicAttribute("cn", string);
        BasicAttribute basicAttribute3 = new BasicAttribute(NSNETTYPE, string2);
        BasicAttribute basicAttribute4 = new BasicAttribute(NSHOSTNAME, string3);
        BasicAttribute basicAttribute5 = new BasicAttribute(NSSERVICE, string4);
        BasicAttribute basicAttribute6 = new BasicAttribute(NSOPTIONS, string5);
        String string6 = "cn=" + string;
        BasicAttributes basicAttributes = new BasicAttributes();
        basicAttributes.put(basicAttribute);
        basicAttributes.put(basicAttribute2);
        basicAttributes.put(basicAttribute3);
        basicAttributes.put(basicAttribute4);
        basicAttributes.put(basicAttribute5);
        basicAttributes.put(basicAttribute6);
        String string7 = string6 + "," + this.ldap_sqhDn;
        try {
            System.out.println(IfxErrMsg.getMinorMsg(-80251, (String)null) + string7);
            this.sqhctx.createSubcontext(string7, (Attributes)basicAttributes);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            System.out.println(IfxErrMsg.getMinorMsg(-80253, (String)null));
        }
        catch (NamingException namingException) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
    }

    void addEntry(String string, Properties properties) throws IfxJNSException {
        String string2 = string + "," + this.ldap_sqhDn;
        BasicAttributes basicAttributes = new BasicAttributes();
        basicAttributes.put(new BasicAttribute("objectclass", "extensibleobject"));
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)properties.get(string3);
            basicAttributes.put(new BasicAttribute(string3, string4));
        }
        try {
            System.out.println(IfxErrMsg.getMinorMsg(-80251, (String)null) + string2);
            this.sqhctx.createSubcontext(string2, (Attributes)basicAttributes);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            System.out.println(IfxErrMsg.getMinorMsg(-80253, (String)null));
        }
        catch (NamingException namingException) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
    }

    void delServer(String string) throws IfxJNSException {
        String string2 = "," + this.ldap_sqhDn;
        try {
            String string3;
            ServerInfo serverInfo = this.getServer(string);
            if (serverInfo.isGroupEntry()) {
                ServerGroup serverGroup = this.getServerGroup(string);
                while (serverGroup.hasMoreElements()) {
                    String string4 = (String)serverGroup.nextElement();
                    string3 = "cn=" + string4 + "," + "cn=" + string + string2;
                    System.out.println(IfxErrMsg.getMinorMsg(-80252, (String)null) + string3);
                    this.sqhctx.destroySubcontext(string3);
                }
            }
            string3 = "cn=" + string + string2;
            System.out.println(IfxErrMsg.getMinorMsg(-80252, (String)null) + string3);
            this.sqhctx.destroySubcontext(string3);
        }
        catch (NamingException namingException) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
    }

    public void destroySqlhosts() throws IfxJNSException {
        try {
            ServerGroup serverGroup = this.listServers();
            while (serverGroup.hasMoreElements()) {
                String string = (String)serverGroup.nextElement();
                this.delServer(string);
            }
            System.out.println(IfxErrMsg.getMinorMsg(-80252, (String)null) + this.ldap_sqhDn);
            this.sqhctx.destroySubcontext(this.ldap_sqhDn);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
    }

    public void uploadSqlhosts(String string) throws IfxJNSException {
        BasicAttributes basicAttributes = new BasicAttributes();
        basicAttributes.put(new BasicAttribute("objectclass", "extensibleobject"));
        basicAttributes.put("cn", this.ldap_sqhName);
        basicAttributes.put("desc", "Sql Hosts");
        try {
            System.out.println(IfxErrMsg.getMinorMsg(-80251, (String)null) + this.ldap_sqhDn);
            this.sqhctx.createSubcontext(this.ldap_sqhDn, (Attributes)basicAttributes);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            System.out.println(IfxErrMsg.getMinorMsg(-80253, (String)null));
        }
        catch (NamingException namingException) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
        try {
            this.sqhEnv.put("SQLH_FILE", string);
            FileSqlhosts fileSqlhosts = new FileSqlhosts(this.sqhEnv);
            fileSqlhosts.uploadToLdap(this);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getLocIfxJNSException(-80284, this.ClientLocale);
        }
    }
}

