/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.MethodOptimizationInfo;

public class OptimizationInfoMemberFilter
implements MemberVisitor {
    private final MemberVisitor memberVisitor;

    public OptimizationInfoMemberFilter(MemberVisitor memberVisitor) {
        this.memberVisitor = memberVisitor;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (FieldOptimizationInfo.getFieldOptimizationInfo(programField) != null) {
            this.memberVisitor.visitProgramField(programClass, programField);
        }
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (FieldOptimizationInfo.getFieldOptimizationInfo(libraryField) != null) {
            this.memberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (MethodOptimizationInfo.getMethodOptimizationInfo(programMethod) != null) {
            this.memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (MethodOptimizationInfo.getMethodOptimizationInfo(libraryMethod) != null) {
            this.memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }
}

