/*
 * Decompiled with CFR 0.152.
 */
package de.superx.test;

import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import de.memtext.util.LogUtils;
import de.memtext.util.PlafUtils;
import de.memtext.util.WindowUtils;
import de.memtext.widgets.LabeledTextField;
import de.memtext.widgets.LogFrame;
import de.memtext.widgets.MBFrame;
import de.memtext.widgets.WarningMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

abstract class BasicServletTester
extends MBFrame
implements ActionListener {
    WebConversation wc = new WebConversation();
    WebRequest request;
    public WebResponse homepage;
    public WebResponse menuFrame;
    public WebResponse maskenFrame;
    String url;
    String kennung;
    String passwd;
    static String defaultUrl = "http://localhost:8080/superx/xml";
    static String defaultKennung = "superx";
    static String defaultPasswd = "anfang12";
    boolean isGuiWanted = false;
    Logger logger = Logger.getLogger((String)"ServletTester");
    LogFrame logFrame = new LogFrame();
    JPanel pSouth = new JPanel();
    LabeledTextField lUsers;
    LabeledTextField lRuns;
    JButton btnStressTest;

    String getKennung() {
        return this.kennung;
    }

    void setKennung(String kennung) {
        this.kennung = kennung;
    }

    String getPasswd() {
        return this.passwd;
    }

    void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    String getUrl() {
        return this.url;
    }

    void setUrl(String url) {
        this.url = url;
    }

    public BasicServletTester(String url, String kennung, String passwd) {
        super("Servlet-Tester");
        this.url = url;
        this.kennung = kennung;
        this.passwd = passwd;
        PlafUtils.setWindowsLook(this);
        try {
            LogUtils.initRaw(this.logger);
            this.logFrame.setSize(900, 700);
            WindowUtils.center(this.logFrame);
            this.logger.setLevel(Level.TRACE);
            JPanel p = this.prepareCenter();
            this.setCenter(p);
            this.lUsers = new LabeledTextField("users", "3", 5);
            this.lRuns = new LabeledTextField("Durchl\u00e4ufe", "8", 5);
            this.btnStressTest = new JButton("StressTest");
            this.btnStressTest.addActionListener(this);
            this.pSouth.add(this.lUsers);
            this.pSouth.add(this.lRuns);
            this.pSouth.add(this.btnStressTest);
            this.setSouth(this.pSouth);
            this.pack();
            WindowUtils.center(this);
        }
        catch (Exception e) {
            WarningMessage.show((Component)this, e.toString(), "");
            System.err.println(e);
        }
    }

    abstract JPanel prepareCenter();

    abstract void testByThread() throws IOException, SAXException;

    void checkContent(String page, String content) throws TestException {
        if (page.indexOf(content) == -1) {
            throw new TestException(page);
        }
    }

    abstract void login() throws MalformedURLException, IOException, SAXException;

    WebResponse getMenuPage() throws MalformedURLException, IOException, SAXException {
        return this.menuFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    abstract void stressTest() throws MalformedURLException, IOException, SAXException;

    public boolean isGuiWanted() {
        return this.isGuiWanted;
    }

    public void setGuiWanted(boolean isGuiWanted) {
        this.isGuiWanted = isGuiWanted;
    }

    class TestException
    extends Exception {
        private String page;

        TestException(String page) {
            this.page = page;
        }

        String getPage() {
            return this.page;
        }
    }

    class MaskenTester {
        private WebResponse response;
        private String name;
        private JButton btn;

        MaskenTester(String name) throws SAXException, IOException {
            this.name = name;
            this.btn = new JButton("test " + name);
            this.btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        MaskenTester.this.abschicken();
                    }
                    catch (IOException e) {
                        WarningMessage.show(null, e.toString(), "");
                        e.printStackTrace();
                    }
                    catch (SAXException e) {
                        WarningMessage.show(null, e.toString(), "");
                        e.printStackTrace();
                    }
                }
            });
            WebLink link = BasicServletTester.this.menuFrame.getLinkWith(name);
            if (link == null) {
                System.out.println(BasicServletTester.this.menuFrame.getText());
                throw new RuntimeException("Kein Link f\u00fcr Abfrage " + name + " im Men\u00fc gefunden");
            }
            this.response = BasicServletTester.this.wc.getResponse(link.getRequest());
            boolean i = true;
        }

        private JButton getButton() {
            return this.btn;
        }

        String abschicken() throws IOException, SAXException {
            WebForm form = this.response.getForms()[0];
            if (form == null) {
                throw new RuntimeException("Kein Formular gefunden in Maske " + BasicServletTester.this.getName());
            }
            WebResponse rs = form.submit();
            return rs.getText();
        }

        void setParam(String name, String value) throws SAXException {
            WebForm form = this.response.getForms()[0];
            if (form == null) {
                throw new RuntimeException("Kein Formular gefunden in Maske " + BasicServletTester.this.getName());
            }
            form.getParameterNames();
            form.setParameter(name, value);
        }
    }
}

