/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.CannotReadScriptException;
import org.springframework.jdbc.datasource.init.ScriptException;
import org.springframework.jdbc.datasource.init.ScriptParseException;
import org.springframework.jdbc.datasource.init.ScriptStatementFailedException;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import org.springframework.jdbc.datasource.init.UncategorizedScriptException;
import org.springframework.lang.Nullable;

public abstract class SuperxScriptUtils
extends ScriptUtils {
    private static Logger logger = LoggerFactory.getLogger(SuperxScriptUtils.class);

    public static List<Throwable> executeSqlScript(Connection connection, EncodedResource resource, boolean continueOnError, boolean ignoreFailedDrops, int debugLimit) throws ScriptException {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        int numOfDebugStmts = 0;
        try {
            String script;
            if (logger.isDebugEnabled()) {
                logger.debug("Executing SQL script from " + String.valueOf(resource));
                if (debugLimit != -1) {
                    logger.debug("Limit debug statements to " + debugLimit + " lines");
                }
            }
            long startTime = System.currentTimeMillis();
            try {
                script = SuperxScriptUtils.readScript(resource, DEFAULT_COMMENT_PREFIXES, ";", "*/");
            }
            catch (IOException ex) {
                throw new CannotReadScriptException(resource, (Throwable)ex);
            }
            String separator = ";";
            if (!"^^^ END OF SCRIPT ^^^".equals(separator) && !SuperxScriptUtils.containsSqlScriptDelimiters(script, separator)) {
                separator = "\n";
            }
            ArrayList<String> statements = new ArrayList<String>();
            SuperxScriptUtils.splitSqlScript(resource, script, separator, DEFAULT_COMMENT_PREFIXES, "/*", "*/", statements);
            int stmtNumber = 0;
            for (String statement : statements) {
                ++stmtNumber;
                try {
                    Statement stmt = connection.createStatement();
                    try {
                        if (logger.isDebugEnabled() && debugLimit == -1 || numOfDebugStmts < debugLimit) {
                            ++numOfDebugStmts;
                            logger.debug("Executing SQL: " + statement);
                        }
                        stmt.execute(statement);
                        int rowsAffected = stmt.getUpdateCount();
                        if ((!logger.isDebugEnabled() || debugLimit != -1) && numOfDebugStmts >= debugLimit) continue;
                        ++numOfDebugStmts;
                        logger.debug(rowsAffected + " returned as update count.");
                        for (SQLWarning warningToLog = stmt.getWarnings(); warningToLog != null; warningToLog = warningToLog.getNextWarning()) {
                            logger.debug("SQLWarning ignored: SQL state '" + warningToLog.getSQLState() + "', error code '" + warningToLog.getErrorCode() + "', message [" + warningToLog.getMessage() + "]");
                        }
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                catch (SQLException ex) {
                    boolean dropStatement = StringUtils.startsWithIgnoreCase((CharSequence)statement.trim(), (CharSequence)"drop");
                    if (continueOnError || dropStatement && ignoreFailedDrops) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(ScriptStatementFailedException.buildErrorMessage((String)statement, (int)stmtNumber, (EncodedResource)resource), (Throwable)ex);
                        }
                        logger.error("ERROR EXCUTING SQL STATEMENT: ", (Throwable)ex);
                        errors.add(new RuntimeException("ERROR in SQL: " + statement + " CAUSE: " + ex.getMessage()));
                        continue;
                    }
                    throw new ScriptStatementFailedException(statement, stmtNumber, resource, (Throwable)ex);
                }
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (logger.isDebugEnabled()) {
                logger.debug("Executed SQL script from " + String.valueOf(resource) + " in " + elapsedTime + " ms.");
            }
        }
        catch (Exception ex) {
            if (ex instanceof ScriptException) {
                throw (ScriptException)ex;
            }
            throw new UncategorizedScriptException("Failed to execute database script from resource [" + String.valueOf(resource) + "]", (Throwable)ex);
        }
        return errors;
    }

    private static String readScript(EncodedResource resource, @Nullable String[] commentPrefixes, @Nullable String separator, @Nullable String blockCommentEndDelimiter) throws IOException {
        try (LineNumberReader lnr = new LineNumberReader(resource.getReader());){
            String string = SuperxScriptUtils.readScript(lnr, commentPrefixes, separator, blockCommentEndDelimiter);
            return string;
        }
    }

    private static String readScript(LineNumberReader lineNumberReader, @Nullable String[] commentPrefixes, @Nullable String separator, @Nullable String blockCommentEndDelimiter) throws IOException {
        String currentStatement = lineNumberReader.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (currentStatement != null) {
            if (blockCommentEndDelimiter != null && currentStatement.contains(blockCommentEndDelimiter) || commentPrefixes != null && !SuperxScriptUtils.startsWithAny(currentStatement, commentPrefixes, 0)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lineNumberReader.readLine();
        }
        SuperxScriptUtils.appendSeparatorToScriptIfNecessary(scriptBuilder, separator);
        return scriptBuilder.toString();
    }

    private static boolean startsWithAny(String script, String[] prefixes, int offset) {
        for (String prefix : prefixes) {
            if (!script.startsWith(prefix, offset)) continue;
            return true;
        }
        return false;
    }

    private static void appendSeparatorToScriptIfNecessary(StringBuilder scriptBuilder, @Nullable String separator) {
        if (separator == null) {
            return;
        }
        String trimmed = separator.trim();
        if (trimmed.length() == separator.length()) {
            return;
        }
        if (scriptBuilder.lastIndexOf(trimmed) == scriptBuilder.length() - trimmed.length()) {
            scriptBuilder.append(separator.substring(trimmed.length()));
        }
    }

    public static boolean containsSqlScriptDelimiters(String script, String delim) {
        boolean inLiteral = false;
        boolean inEscape = false;
        for (int i = 0; i < script.length(); ++i) {
            char thisChar = script.charAt(i);
            if (thisChar == '\\') {
                inEscape = !inEscape;
                continue;
            }
            if (inEscape) {
                inEscape = false;
                continue;
            }
            if (thisChar == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (inLiteral || !script.startsWith(delim, i)) continue;
            return true;
        }
        return false;
    }

    static void splitSqlScript(@Nullable EncodedResource resource, String script, String separator, String[] commentPrefixes, String blockCommentStartDelimiter, String blockCommentEndDelimiter, List<String> statements) throws ScriptException {
        StringBuilder sb = new StringBuilder();
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean inEscape = false;
        for (int i = 0; i < script.length(); ++i) {
            int c = script.charAt(i);
            if (inEscape) {
                inEscape = false;
                sb.append((char)c);
                continue;
            }
            if (c == 92) {
                inEscape = true;
                sb.append((char)c);
                continue;
            }
            if (!inDoubleQuote && c == 39) {
                inSingleQuote = !inSingleQuote;
            } else if (!inSingleQuote && c == 34) {
                boolean bl = inDoubleQuote = !inDoubleQuote;
            }
            if (!inSingleQuote && !inDoubleQuote) {
                if (script.startsWith(separator, i)) {
                    if (sb.length() > 0) {
                        statements.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    i += separator.length() - 1;
                    continue;
                }
                if (SuperxScriptUtils.startsWithAny(script, commentPrefixes, i)) {
                    int indexOfNextNewline = script.indexOf(10, i);
                    if (indexOfNextNewline <= i) break;
                    i = indexOfNextNewline;
                    continue;
                }
                if (script.startsWith(blockCommentStartDelimiter, i)) {
                    int indexOfCommentEnd = script.indexOf(blockCommentEndDelimiter, i);
                    if (indexOfCommentEnd > i) {
                        i = indexOfCommentEnd + blockCommentEndDelimiter.length() - 1;
                        continue;
                    }
                    throw new ScriptParseException("Missing block comment end delimiter: " + blockCommentEndDelimiter, resource);
                }
                if (c == 32 || c == 13 || c == 10 || c == 9) {
                    if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') continue;
                    c = 32;
                }
            }
            sb.append((char)c);
        }
        if (SuperxScriptUtils.hasText(sb)) {
            statements.add(sb.toString());
        }
    }

    public static boolean hasText(@Nullable CharSequence str) {
        if (str == null) {
            return false;
        }
        int strLen = str.length();
        if (strLen == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

