/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.util;

import de.superx.job.ActionNode;
import de.superx.job.ContainerNode;
import de.superx.job.LoadAction;
import de.superx.job.SqlAction;
import de.superx.job.SqlScriptAction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedSqlScriptParser {
    private static Logger logger = LoggerFactory.getLogger(MixedSqlScriptParser.class);
    private String scriptName;
    private String moduleAbbr;
    private Integer systemInfoId;
    private List<DataTuple<LineType, String>> preSteps = new ArrayList<DataTuple<LineType, String>>();
    private static final Pattern PECHO = Pattern.compile("^\\s*\\\\!\\s+echo\\s+[\\\"`](.+)[\\\"`]$");
    private static final Pattern PSQLS = Pattern.compile("^\\s*\\\\!\\s+DOSQL\\s+(\\$\\w+\\S+)$");
    private static final Pattern PSQL = Pattern.compile("^.*;$");
    private static final Pattern PCOMMENT = Pattern.compile("^--.*$");
    private static final Pattern PUNL = Pattern.compile("^\\s*\\\\!\\s+sx_auto_upload_table.x\\s+(\\S+)\\s+(\\$\\w+\\S+)$");
    private static final Pattern PFMS = Pattern.compile("^\\s*<#.+$");
    private static final Pattern PFME = Pattern.compile("^\\s*</#.+$");

    public MixedSqlScriptParser(File sqlScript, String moduleAbbr, Integer systemInfoId) {
        this.scriptName = sqlScript.getName();
        this.moduleAbbr = moduleAbbr;
        this.systemInfoId = systemInfoId;
        try (BufferedReader br = new BufferedReader(new FileReader(sqlScript));){
            String line;
            while ((line = br.readLine()) != null) {
                this.preSteps.add(this.evaluateLine(line.trim()));
            }
        }
        catch (FileNotFoundException e) {
            logger.error("Couldn't find SQl Script at " + sqlScript.getAbsolutePath());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error("Couldn't read SQl Script at " + sqlScript.getAbsolutePath());
            e.printStackTrace();
        }
    }

    public ContainerNode parseScript() {
        ContainerNode root = new ContainerNode("Uninstall " + this.scriptName + "_" + this.moduleAbbr.toLowerCase(), ContainerNode.JobType.uninstall.createName(this.moduleAbbr.toLowerCase()), this.systemInfoId);
        root.addAll(this.getActions());
        return root;
    }

    private DataTuple<LineType, String> evaluateLine(String line) {
        DataTuple<LineType, Object> result = null;
        Matcher echo = PECHO.matcher(line);
        Matcher sqlS = PSQLS.matcher(line);
        Matcher sql = PSQL.matcher(line);
        Matcher comment = PCOMMENT.matcher(line);
        Matcher unl = PUNL.matcher(line);
        Matcher fms = PFMS.matcher(line);
        Matcher fme = PFME.matcher(line);
        result = line.isBlank() ? new DataTuple<LineType, String>(LineType.EMPTY, line) : (echo.matches() ? new DataTuple<LineType, String>(LineType.ECHO, echo.group(1)) : (comment.matches() ? new DataTuple<LineType, String>(LineType.COMMENT, line) : (sqlS.matches() ? new DataTuple<LineType, String>(LineType.SQL_SCRIPT, sqlS.group(1)) : (sql.matches() ? new DataTuple<LineType, String>(LineType.SQL_STATEMENT, line) : (unl.matches() ? new DataTuple<LineType, CallSite>(LineType.UNLOAD, (CallSite)((Object)(unl.group(2) + "," + unl.group(1)))) : (fms.matches() ? new DataTuple<LineType, String>(LineType.FREEMARKER_START, line) : (fme.matches() ? new DataTuple<LineType, String>(LineType.FREEMARKER_END, line) : new DataTuple<LineType, String>(LineType.INCOMPLETE, line))))))));
        return result;
    }

    private List<ActionNode> getActions() {
        ArrayList<ActionNode> steps = new ArrayList<ActionNode>();
        Object incompleteBuffer = "";
        int fmBlock = 0;
        for (DataTuple<LineType, String> tuple : this.preSteps) {
            switch (tuple.getX()) {
                case EMPTY: {
                    break;
                }
                case ECHO: {
                    logger.info(tuple.getY());
                    break;
                }
                case COMMENT: {
                    break;
                }
                case SQL_SCRIPT: {
                    steps.add(this.createSqlScriptAction(tuple.getY()));
                    break;
                }
                case SQL_STATEMENT: {
                    if (fmBlock == 0) {
                        String sql = (String)incompleteBuffer + tuple.getY();
                        if (!sql.contains("xdummy")) {
                            steps.add(this.createSqlAction(sql));
                        }
                        incompleteBuffer = "";
                        break;
                    }
                    incompleteBuffer = (String)incompleteBuffer + tuple.getY() + " ";
                    break;
                }
                case UNLOAD: {
                    String[] s = tuple.getY().split(",");
                    steps.add(this.createLoadAction(s[0], s[1]));
                    break;
                }
                case FREEMARKER_START: {
                    ++fmBlock;
                    incompleteBuffer = (String)incompleteBuffer + tuple.getY() + " ";
                    break;
                }
                case FREEMARKER_END: {
                    --fmBlock;
                    steps.add(this.createSqlAction((String)incompleteBuffer + tuple.getY()));
                    incompleteBuffer = "";
                    break;
                }
                case INCOMPLETE: {
                    incompleteBuffer = (String)incompleteBuffer + tuple.getY() + " ";
                }
            }
        }
        return steps;
    }

    private SqlAction createSqlAction(String sql) {
        if (this.scriptName.contains("pg")) {
            return new SqlAction(null, this.systemInfoId, "postgres", "eduetl", null, sql);
        }
        return new SqlAction(null, this.systemInfoId, "informix", "eduetl", null, sql);
    }

    private SqlScriptAction createSqlScriptAction(String scriptfile) {
        if (this.scriptName.contains("pg")) {
            return new SqlScriptAction("postgres", this.systemInfoId, scriptfile);
        }
        return new SqlScriptAction("informix", this.systemInfoId, scriptfile);
    }

    private LoadAction createLoadAction(String path, String table) {
        return new LoadAction(this.systemInfoId, true, "^", false, "eduetl", table, path);
    }

    private class DataTuple<T, S> {
        private T obj_1;
        private S obj_2;

        public DataTuple(T x, S y) {
            this.obj_1 = x;
            this.obj_2 = y;
        }

        public T getX() {
            return this.obj_1;
        }

        public S getY() {
            return this.obj_2;
        }
    }

    public static enum LineType {
        COMMENT,
        SQL_SCRIPT,
        SQL_STATEMENT,
        ECHO,
        UNLOAD,
        INCOMPLETE,
        EMPTY,
        FREEMARKER_START,
        FREEMARKER_END;

    }
}

