/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.superx.bianalysis.models.Info;
import de.superx.common.Maske;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxUser;
import de.superx.rest.model.Column;
import de.superx.rest.model.ColumnType;
import de.superx.rest.model.Item;
import de.superx.rest.model.Legend;
import de.superx.rest.model.ResultType;
import de.superx.rest.model.Row;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Result {
    public ResultType resultType;
    public Info info = new Info();
    public Legend legend = new Legend();
    public List<Column> columns = new ArrayList<Column>();
    public List<Row> rows = new ArrayList<Row>();
    public List<Result> subResults = new ArrayList<Result>();

    @JsonIgnore
    public Row getTotalRow() {
        return this.rows.stream().filter(r -> r.aggregated == -1).findAny().get();
    }

    public void addRows(SuperX_el sxel) {
        for (SxResultRow sxrw : sxel.getResultSet()) {
            this.addRow(sxel, sxrw);
        }
    }

    private void addRow(SuperX_el sxel, SxResultRow sxrw) {
        TreeMap<String, Object> cells = new TreeMap<String, Object>();
        String[] columnNames = sxel.getColumnNames();
        for (int i = 0; i < sxrw.size(); ++i) {
            ColumnType type = this.columns.get((int)i).type;
            Object value = type.formatValue(sxrw.get(i));
            String colName = columnNames[i];
            cells.put(colName, value);
        }
        this.rows.add(new Row(cells));
    }

    public void addRow(Map<String, Object> cells, boolean readOnly) {
        cells.forEach((key, value) -> {
            Column column = this.columns.stream().filter(col -> key.equals(col.field)).findFirst().orElse(null);
            cells.put((String)key, column.type.formatValue(value));
        });
        this.rows.add(new Row(cells, readOnly));
    }

    public void addColumns(List<Column> cols) {
        this.columns = cols;
    }

    public void addColumns(SuperX_el sxel, Maske maske) {
        String[] columnNames = sxel.getColumnNames();
        ColumnType[] columnTypes = ColumnType.getColumnTypes(sxel.getColumnTypes(), columnNames);
        List<String> columnCaptions = Result.getColumnCaptions(maske);
        for (int i = 0; i < sxel.getColumnCount(); ++i) {
            String caption = columnCaptions.size() > i ? columnCaptions.get(i) : columnNames[i];
            this.columns.add(new Column(columnNames[i], caption, columnTypes[i]));
        }
    }

    private static List<String> getColumnCaptions(Maske maske) {
        String superxNewLineRegEx = "(\\s*\\r\\s*)";
        List<String> result = maske.getHeaderCaptionList(maske.getMandantenId(), true);
        result.forEach(caption -> caption.replaceAll(superxNewLineRegEx, "\n"));
        return result;
    }

    public static List<List<Row>> getRowsFromReports(List<Result> reports) {
        List<List<Row>> rows = reports.stream().map(r -> r.rows).collect(Collectors.toList());
        return rows;
    }

    public void determineTableType(SuperX_el sxel) {
        this.resultType = sxel != null && (sxel.hasEbeneCol() || sxel.hasLvCol()) ? ResultType.DrilldownTableSuperXStyle : ResultType.FlatTable;
    }

    public void addLegend(Maske maske, SxUser user) throws ParseException {
        this.legend = maske.getSplitLegend(user.getName());
    }

    public void withStandartParam(String label, String value) {
        this.legend.standardParams.add(new Item(label, value));
    }

    public void addStandartParam(Item item) {
        this.legend.standardParams.add(item);
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public void setSubResults(List<Result> reportResults) {
        this.subResults = reportResults;
    }

    public void setResultType(ResultType type) {
        this.resultType = type;
    }
}

