/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest.config;

import de.superx.common.UngueltigeEingabeException;
import de.superx.rest.config.ValueFormatTool;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberListFormatTool
extends ValueFormatTool {
    private static Pattern LIST_NUMBER_FORMAT_PATTERN = Pattern.compile("-?\\d+(,-?\\d+)*");

    @Override
    public String escapeForFormular(String inputValue) throws UngueltigeEingabeException {
        if (inputValue == null) {
            return "";
        }
        if (!this.confirmFormat(inputValue)) {
            throw new UngueltigeEingabeException("Multiselectauswahl muss im Listenformat sein");
        }
        return inputValue;
    }

    @Override
    public boolean confirmFormat(String input) {
        if (input == null || input.equals("")) {
            return true;
        }
        Matcher matcher = LIST_NUMBER_FORMAT_PATTERN.matcher(input);
        boolean matcher_result = matcher.matches();
        return matcher_result;
    }
}

