/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest;

import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.superx.bianalysis.FaultyMetadataException;
import de.superx.common.AccessDeniedException;
import de.superx.common.ConfigurationException;
import de.superx.common.DBServletException;
import de.superx.common.EtlConfigurationException;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidEntityException;
import de.superx.common.InvalidKeyException;
import de.superx.common.NotYetImplementedException;
import de.superx.common.ObligatoryFieldEmptyException;
import de.superx.common.SichtException;
import de.superx.common.UngueltigeEingabeException;
import de.superx.rest.InputValidationError;
import de.superx.rest.model.ExceptionResponse;
import de.superx.rest.model.RestMessageWrapperException;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.relational.core.conversion.DbActionExecutionException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

public abstract class RestControllerBase {
    protected static ResponseEntity<ExceptionResponse> handleServerError(String message) {
        ExceptionResponse er = new ExceptionResponse(null, message, null);
        ResponseEntity re = new ResponseEntity((Object)er, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        return re;
    }

    protected static ResponseEntity<ExceptionResponse> handleUserInputError(String message) {
        ExceptionResponse er = new ExceptionResponse(null, message, null);
        ResponseEntity re = new ResponseEntity((Object)er, (HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
        return re;
    }

    protected static ResponseEntity<ExceptionResponse> handleUserInputError(ExceptionResponse er, HttpStatus status) {
        ResponseEntity re = new ResponseEntity((Object)er, (HttpStatusCode)status);
        return re;
    }

    protected abstract Logger getLogger();

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ExceptionResponse> dispatchExceptionHandler(Exception ex) {
        if (ex instanceof MethodArgumentTypeMismatchException) {
            return this.handleMethodArgumentTypeMismatchException((MethodArgumentTypeMismatchException)ex);
        }
        if (ex instanceof DBServletException) {
            return this.handleDBServletException((DBServletException)ex);
        }
        if (ex instanceof IOException) {
            return this.handleIOException((IOException)ex);
        }
        if (ex instanceof CloneNotSupportedException) {
            return this.handleCloneNotSupportedException((CloneNotSupportedException)ex);
        }
        if (ex instanceof TemplateException) {
            return this.handleTemplateException((TemplateException)((Object)ex));
        }
        if (ex instanceof SQLException) {
            return this.handleSQLException((SQLException)ex);
        }
        if (ex instanceof ParserConfigurationException) {
            return this.handleParserConfigurationException((ParserConfigurationException)ex);
        }
        if (ex instanceof ParseException) {
            return this.handleParseException((ParseException)ex);
        }
        if (ex instanceof JRException) {
            return this.handleJRException((JRException)((Object)ex));
        }
        if (ex instanceof KeyParentEqualException) {
            return this.handleKeyParentEqualException((KeyParentEqualException)ex);
        }
        if (ex instanceof NoMainEntryException) {
            return this.handleNoMainEntryException((NoMainEntryException)ex);
        }
        if (ex instanceof InvalidDataTypeException) {
            return this.handleInvalidDataTypeException((InvalidDataTypeException)ex);
        }
        if (ex instanceof SichtException) {
            return this.handleSichtException((SichtException)ex);
        }
        if (ex instanceof UngueltigeEingabeException) {
            return this.handleUngueltigeEingabeException((UngueltigeEingabeException)ex);
        }
        if (ex instanceof ObligatoryFieldEmptyException) {
            return this.handleObligatoryFieldEmptyException((ObligatoryFieldEmptyException)ex);
        }
        if (ex instanceof InvalidKeyException) {
            return this.handleInvalidKeyException((InvalidKeyException)ex);
        }
        if (ex instanceof TransformerException) {
            return this.handleTransformerException((TransformerException)ex);
        }
        if (ex instanceof NotYetImplementedException) {
            return this.handleNotYetImplementedException((NotYetImplementedException)ex);
        }
        if (ex instanceof InvalidEntityException) {
            return this.handleInvalidEntityException((InvalidEntityException)ex);
        }
        if (ex instanceof DbActionExecutionException) {
            return this.handleDbActionExecutionException((DbActionExecutionException)ex);
        }
        if (ex instanceof EtlConfigurationException) {
            return this.handleEtlConfigurationException((EtlConfigurationException)ex);
        }
        if (ex instanceof ConfigurationException) {
            return this.handleConfigurationException((ConfigurationException)ex);
        }
        if (ex instanceof AccessDeniedException) {
            return this.handleAccessDeniedException((AccessDeniedException)ex);
        }
        if (ex instanceof InputValidationError) {
            return RestControllerBase.handleUserInputError(ex.getMessage());
        }
        if (ex instanceof FaultyMetadataException) {
            return this.handleFaultyMetadataException((FaultyMetadataException)ex);
        }
        if (ex instanceof RestMessageWrapperException) {
            return this.handleRestMessageWrapperException((RestMessageWrapperException)ex);
        }
        if (ex instanceof RuntimeException) {
            this.getLogger().error((Object)"RuntimeException:", (Throwable)ex);
        }
        this.getLogger().error((Object)"an unexpected exception occured; exception type: ", (Throwable)ex);
        return RestControllerBase.handleServerError("an exception occured");
    }

    public ResponseEntity<ExceptionResponse> handleMethodArgumentTypeMismatchException(MethodArgumentTypeMismatchException ex) {
        this.getLogger().error((Object)"MethodArgumentTypeMismatchException occured", (Throwable)ex);
        return RestControllerBase.handleUserInputError(ex.getMessage());
    }

    public ResponseEntity<ExceptionResponse> handleDBServletException(DBServletException ex) {
        this.getLogger().error((Object)"DBServletException occured", (Throwable)ex);
        return RestControllerBase.handleServerError("Interner Serverfehler");
    }

    public ResponseEntity<ExceptionResponse> handleIOException(IOException ex) {
        this.getLogger().error((Object)"IOException occured", (Throwable)ex);
        return RestControllerBase.handleServerError("Interner Serverfehler");
    }

    public ResponseEntity<ExceptionResponse> handleCloneNotSupportedException(CloneNotSupportedException ex) {
        this.getLogger().error((Object)"CloneNotSupportedException occured", (Throwable)ex);
        return RestControllerBase.handleServerError("Interner Serverfehler");
    }

    public ResponseEntity<ExceptionResponse> handleTemplateException(TemplateException ex) {
        this.getLogger().error((Object)"TemplateException occured", (Throwable)ex);
        return RestControllerBase.handleServerError("Interner Serverfehler");
    }

    public ResponseEntity<ExceptionResponse> handleAccessDeniedException(AccessDeniedException ex) {
        this.getLogger().error((Object)"AccessDeniedException occured", (Throwable)ex);
        ExceptionResponse exceptionResponse = new ExceptionResponse("", "Kein Zugriff", null);
        ResponseEntity responseEntity = new ResponseEntity((Object)exceptionResponse, (HttpStatusCode)HttpStatus.UNAUTHORIZED);
        return responseEntity;
    }

    public ResponseEntity<ExceptionResponse> handleSQLException(SQLException ex) {
        this.getLogger().error((Object)"SQLException occured", (Throwable)ex);
        return RestControllerBase.handleServerError("Interner Serverfehler");
    }

    public ResponseEntity<ExceptionResponse> handleParserConfigurationException(ParserConfigurationException ex) {
        this.getLogger().error((Object)"ParserConfigurationException occured", (Throwable)ex);
        return RestControllerBase.handleServerError("Interner Serverfehler");
    }

    public ResponseEntity<ExceptionResponse> handleParseException(ParseException ex) {
        this.getLogger().error((Object)"ParseException occured", (Throwable)ex);
        return RestControllerBase.handleServerError("Interner Serverfehler");
    }

    public ResponseEntity<ExceptionResponse> handleJRException(JRException ex) {
        this.getLogger().error((Object)"ParserConfigurationException occured", (Throwable)ex);
        return RestControllerBase.handleServerError("Interner Serverfehler");
    }

    public ResponseEntity<ExceptionResponse> handleKeyParentEqualException(KeyParentEqualException ex) {
        this.getLogger().error((Object)"KeyParentEqualException occured", (Throwable)ex);
        return RestControllerBase.handleServerError("Interner Serverfehler");
    }

    public ResponseEntity<ExceptionResponse> handleNoMainEntryException(NoMainEntryException ex) {
        this.getLogger().error((Object)"NoMainEntryException occured", (Throwable)ex);
        return RestControllerBase.handleServerError("Interner Serverfehler");
    }

    public ResponseEntity<ExceptionResponse> handleInvalidDataTypeException(InvalidDataTypeException ex) {
        this.getLogger().error((Object)"InvalidDataTypeException occured", (Throwable)ex);
        return RestControllerBase.handleUserInputError(ex.getMessage());
    }

    public ResponseEntity<ExceptionResponse> handleSichtException(SichtException ex) {
        this.getLogger().error((Object)"SichtException occured", (Throwable)ex);
        return RestControllerBase.handleServerError(ex.getMessage());
    }

    public ResponseEntity<ExceptionResponse> handleUngueltigeEingabeException(UngueltigeEingabeException ex) {
        this.getLogger().error((Object)"UngueltigeEingabeException occured", (Throwable)ex);
        return RestControllerBase.handleUserInputError(ex.getMessage());
    }

    public ResponseEntity<ExceptionResponse> handleObligatoryFieldEmptyException(ObligatoryFieldEmptyException ex) {
        this.getLogger().error((Object)"ObligatoryFieldEmptyException occured", (Throwable)ex);
        return RestControllerBase.handleUserInputError(ex.getMessage());
    }

    public ResponseEntity<ExceptionResponse> handleInvalidKeyException(InvalidKeyException ex) {
        this.getLogger().error((Object)"InvalidKeyException occured", (Throwable)ex);
        return RestControllerBase.handleUserInputError(ex.getMessage());
    }

    public ResponseEntity<ExceptionResponse> handleTransformerException(TransformerException ex) {
        this.getLogger().error((Object)"TransformerException occured", (Throwable)ex);
        return RestControllerBase.handleServerError(ex.getMessage());
    }

    public ResponseEntity<ExceptionResponse> handleNotYetImplementedException(NotYetImplementedException ex) {
        this.getLogger().error((Object)"NotYetImplementedException occured", (Throwable)ex);
        return RestControllerBase.handleServerError(ex.getMessage());
    }

    public ResponseEntity<ExceptionResponse> handleFaultyMetadataException(FaultyMetadataException ex) {
        this.getLogger().error((Object)"FaultyMetadataException occured", (Throwable)ex);
        return RestControllerBase.handleServerError(ex.getMessage());
    }

    public ResponseEntity<ExceptionResponse> handleInvalidEntityException(InvalidEntityException ex) {
        this.getLogger().error((Object)"InvalidEntityException occured", (Throwable)ex);
        return RestControllerBase.handleUserInputError(ex.getMessage());
    }

    public ResponseEntity<ExceptionResponse> handleDbActionExecutionException(DbActionExecutionException ex) {
        this.getLogger().error((Object)"DbActionExecutionException occured", (Throwable)ex);
        String nestedExceptionMessage = ex.getCause().getCause().getMessage();
        if (ex.getCause().getClass().equals(DuplicateKeyException.class)) {
            return RestControllerBase.handleUserInputError(nestedExceptionMessage);
        }
        if (ex.getCause().getClass().equals(DataIntegrityViolationException.class)) {
            return RestControllerBase.handleUserInputError(nestedExceptionMessage);
        }
        return RestControllerBase.handleServerError("Interner Serverfehler");
    }

    public ResponseEntity<ExceptionResponse> handleEtlConfigurationException(EtlConfigurationException ex) {
        this.getLogger().error((Object)"EtlConfigurationException occured", (Throwable)ex);
        return RestControllerBase.handleServerError("Invalid etl configuration: " + ex.getMessage());
    }

    public ResponseEntity<ExceptionResponse> handleConfigurationException(ConfigurationException ex) {
        this.getLogger().error((Object)"ConfigurationException occured", (Throwable)ex);
        return RestControllerBase.handleUserInputError(ex.getMessage());
    }

    public ResponseEntity<ExceptionResponse> handleRestMessageWrapperException(RestMessageWrapperException ex) {
        this.getLogger().error((Object)"RestMessageWrapperException occured", (Throwable)ex);
        return RestControllerBase.handleUserInputError(ex.exceptionResponse, ex.httpStatus);
    }
}

