/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest;

import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.FileUtils;
import de.superx.common.AbstractSicht;
import de.superx.common.ConfigurationException;
import de.superx.common.DBServletException;
import de.superx.common.Field;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidKeyException;
import de.superx.common.Maske;
import de.superx.common.ObligatoryFieldEmptyException;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import de.superx.common.SelectableItemTree;
import de.superx.common.SichtException;
import de.superx.common.Sichtgruppe;
import de.superx.common.SuperX_el;
import de.superx.common.SxUser;
import de.superx.common.UngueltigeEingabeException;
import de.superx.rest.ReportApiBase;
import de.superx.rest.model.ColumnType;
import de.superx.rest.model.Data;
import de.superx.rest.model.Download;
import de.superx.rest.model.ReportInfo;
import de.superx.rest.model.Result;
import de.superx.rest.model.ResultType;
import de.superx.rest.model.StylesheetInfo;
import de.superx.rest.model.TreeNode;
import de.superx.rest.model.View;
import de.superx.rest.model.ViewGroup;
import de.superx.rest.util.HttpServletStreamInterceptor;
import de.superx.rest.util.RequestWrapper;
import de.superx.servlet.JasperCreator;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.servlet.XmlTransformer;
import de.superx.spring.service.MaskStatisticService;
import de.superx.spring.service.UserService;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.sql.DataSource;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/report"})
public class Report
extends ReportApiBase {
    @Autowired
    MaskStatisticService maskStatisticService;
    @Autowired
    DataSource dataSource;
    @Autowired
    UserService userService;
    private static final String CSV_CONTENTTYPE = "text/csv;charset=utf-8";
    static Logger logger = Logger.getLogger(Report.class);
    private static int MAX_OFFSET = 1000000;
    private static String mandantenId = SxSQL_Server.DEFAULT_MANDANTEN_ID;

    @Override
    protected Logger getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET})
    public ReportInfo getInfo(@RequestParam(value="tid") int tid, HttpServletRequest inRequ) throws SQLException, KeyParentEqualException, NoMainEntryException, SichtException, TemplateException, CloneNotSupportedException, IOException, DBServletException, ParseException, UngueltigeEingabeException, TransformerException, InvalidDataTypeException {
        HttpSession httpSession = inRequ.getSession();
        synchronized (httpSession) {
            ReportInfo reportInfo = new ReportInfo(tid);
            SxUser user = (SxUser)this.userService.currentUserDetails();
            this.userService.checkRights(tid, user);
            Maske maske = Report.initMaske(tid, inRequ, user);
            reportInfo.name = maske.getName();
            reportInfo.description = maske.getExplanation();
            reportInfo.setSachgebiet(this.dataSource, tid);
            return reportInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, path={"stylesheets"})
    public StylesheetInfo getStylesheets(@RequestParam(value="tid") int tid, HttpServletRequest inRequ) throws SQLException, KeyParentEqualException, NoMainEntryException, SichtException, TemplateException, CloneNotSupportedException, IOException, DBServletException, ParseException, UngueltigeEingabeException, TransformerException, InvalidDataTypeException {
        HttpSession httpSession = inRequ.getSession();
        synchronized (httpSession) {
            StylesheetInfo stylesheets = new StylesheetInfo();
            SxUser user = (SxUser)this.userService.currentUserDetails();
            this.userService.checkRights(tid, user);
            Maske maske = Report.initMaske(tid, inRequ, user);
            stylesheets.stylesheets = maske.getFilteredStylesheets();
            stylesheets.selectedStylesheet = maske.getDefaultStylesheetForNg();
            return stylesheets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, path={"views"})
    public ViewGroup getViews(@RequestParam(value="tid") int tid, @RequestParam(value="fieldName") String fieldName, HttpServletRequest request) throws ParseException, KeyParentEqualException, NoMainEntryException, SQLException, InvalidDataTypeException, SichtException, UngueltigeEingabeException, TemplateException, CloneNotSupportedException, IOException, DBServletException, TransformerException {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            ArrayList<View> views = new ArrayList<View>();
            SxUser user = (SxUser)this.userService.currentUserDetails();
            this.userService.checkRights(tid, user);
            ViewGroup viewGroup = null;
            Maske report = Report.initMaske(tid, request, user);
            Field field = report.getField(fieldName);
            Sichtgruppe sichtGruppe = field.getSichtgruppe();
            Collection sichten = sichtGruppe.getSichtenlist();
            sichten.forEach(v -> {
                AbstractSicht aSicht = (AbstractSicht)v;
                String validityDate = aSicht.getStand();
                if (validityDate == null || validityDate.isEmpty()) {
                    validityDate = (String)ColumnType.DateColumn.formatValue(Calendar.getInstance().getTime());
                }
                boolean isValidityDateSelectable = aSicht.isStandbuttonWanted();
                views.add(new View(aSicht.getName(), (Integer)aSicht.getId(), validityDate, isValidityDateSelectable));
            });
            viewGroup = new ViewGroup(views, field.getZeilenanzahl() == 1);
            return viewGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, path={"view"})
    public ArrayList<TreeNode> getView(@RequestParam(value="tid") int tid, @RequestParam(value="fieldName") String fieldName, @RequestParam(value="viewId") int viewId, @RequestParam(value="validityDate") String validityDate, HttpServletRequest request) throws ParseException, KeyParentEqualException, NoMainEntryException, SQLException, InvalidDataTypeException, SichtException, UngueltigeEingabeException, TemplateException, CloneNotSupportedException, IOException, DBServletException, TransformerException {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            ArrayList<TreeNode> root = new ArrayList<TreeNode>();
            SxUser user = (SxUser)this.userService.currentUserDetails();
            Maske report = Report.initMaske(tid, request, user);
            Field field = report.getField(fieldName);
            report.setSelectedFeldSicht(fieldName, Integer.toString(viewId), user);
            SelectableItemTree tree = Report.getSelectableItemTree(viewId, validityDate, report, field);
            if (tree != null) {
                Enumeration<javax.swing.tree.TreeNode> startnodes = tree.getRoot().children();
                while (startnodes.hasMoreElements()) {
                    SelectableItemNode startnode = (SelectableItemNode)startnodes.nextElement();
                    SelectableItem item = (SelectableItem)startnode.getUserObject();
                    String value = (String)item.getId();
                    String label = item.getName();
                    TreeNode node = new TreeNode(startnode.hashCode(), label, value);
                    node.children = Report.getChildrenFor(startnode);
                    node.expanded = true;
                    root.add(node);
                }
            }
            return root;
        }
    }

    public static SelectableItemTree getSelectableItemTree(int viewId, String validityDate, Maske report, Field field) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        Sichtgruppe sichtGruppe = field.getSichtgruppe();
        sichtGruppe.setSelectedSicht(viewId);
        sichtGruppe.setStand(report.getFormularCopy(), new HashMap(), report.getIndividualFields(), validityDate);
        SelectableItemTree tree = (SelectableItemTree)((Object)sichtGruppe.getById(viewId));
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST})
    public Result getData(@RequestParam(value="tid") int tid, @RequestBody Map<String, String> params, HttpServletRequest inRequ) throws ParseException, KeyParentEqualException, NoMainEntryException, SQLException, InvalidDataTypeException, SichtException, UngueltigeEingabeException, TemplateException, CloneNotSupportedException, IOException, ObligatoryFieldEmptyException, InvalidKeyException, DBServletException, TransformerException {
        HttpSession httpSession = inRequ.getSession();
        synchronized (httpSession) {
            SxUser user = (SxUser)this.userService.currentUserDetails();
            this.userService.checkRights(tid, user);
            Maske maske = Report.initMaske(tid, inRequ, user);
            this.maskStatisticService.logUsage(tid);
            Map<String, String> cleanedParams = params;
            cleanedParams = Report.removeViewInformation(params);
            HttpServletRequest request = RequestWrapper.wrapHttpServletRequest(cleanedParams, inRequ, maske.getIndividualFields());
            Result result = Report.createResult(user, request, maske);
            Report.handleProjectFinanceReport(tid, result);
            return result;
        }
    }

    private static Result createResult(SxUser user, HttpServletRequest request, Maske maske) throws TemplateException, IOException, SQLException, KeyParentEqualException, CloneNotSupportedException, SichtException, TransformerConfigurationException, ObligatoryFieldEmptyException, ParseException, InvalidKeyException, TransformerException, DBServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException, ConfigurationException {
        Result result = new Result();
        if (maske != null) {
            maske.runQuery(user, request, null);
            SuperX_el sxel = maske.getResult_el();
            String SxelRuntimeMessage = sxel.getRuntimeMessage();
            if (SxelRuntimeMessage != null && SxelRuntimeMessage.startsWith("Warnung: die Abfrage kann nicht ausgef\u00fchrt werden")) {
                throw new ConfigurationException(SxelRuntimeMessage);
            }
            if (sxel.getColumnCount() == 0) {
                return result;
            }
            result.determineTableType(sxel);
            result.addLegend(maske, user);
            result.addColumns(sxel, maske);
            result.addRows(sxel);
        }
        return result;
    }

    private static void handleProjectFinanceReport(int tid, Result result) {
        if (tid == 600020) {
            result.resultType = ResultType.DrilldownTableGroupable;
            String[] groupableCols = new String[]{"project_uniquename_defaulttext", "budget_source_shorttext", "business_defaulttext", "report_year"};
            result.columns.forEach(col -> {
                col.groupable = Arrays.asList(groupableCols).contains(col.field);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST}, path={"download"})
    public Download getDownload(@RequestParam(value="tid") int tid, @RequestBody Map<String, String> params, HttpServletRequest request, HttpServletResponse response) throws SQLException, ParserConfigurationException, JRException, ParseException, KeyParentEqualException, NoMainEntryException, InvalidDataTypeException, SichtException, UngueltigeEingabeException, TemplateException, CloneNotSupportedException, ObligatoryFieldEmptyException, InvalidKeyException, DBServletException, IOException, TransformerException {
        HttpSession httpSession = request.getSession();
        synchronized (httpSession) {
            HttpServletStreamInterceptor response_interceptor = new HttpServletStreamInterceptor(response);
            SxUser user = (SxUser)this.userService.currentUserDetails();
            this.userService.checkRights(tid, user);
            Maske maske = new Maske(mandantenId, user, tid, Locale.GERMANY);
            HttpServletRequest request_wrapper = RequestWrapper.wrapHttpServletRequest(Report.removeViewInformation(params), request, maske.getIndividualFields());
            maske.setMaxOffset(MAX_OFFSET);
            String currentXml = maske.runQuery(user, request_wrapper, null);
            Report.addStylesheetAndFormatToMask(params, maske);
            this.writeOutputToRespons(params, request_wrapper, response_interceptor, maske, currentXml);
            response_interceptor.setContentType("application/json");
            Download dl = Report.createDownloadObject(response_interceptor, maske, user);
            return dl;
        }
    }

    private void writeOutputToRespons(Map<String, String> params, HttpServletRequest request_wrapper, HttpServletStreamInterceptor response_interceptor, Maske maske, String currentXml) throws IOException, JRException, UnsupportedEncodingException, DBServletException, FactoryConfigurationError, ParserConfigurationException, TransformerException {
        if (maske.getSelectedTableStylesheetFilename().endsWith(".jrxml")) {
            this.runJasperGeneration(request_wrapper, response_interceptor, maske, currentXml);
        } else if (params.get("contenttype").equals("text/xml")) {
            Report.createXml(response_interceptor, currentXml, maske.getName());
        } else if (params.get("contenttype").equals("text/csv")) {
            Report.createCsv(response_interceptor, maske);
        } else {
            Report.runGenericGeneration(request_wrapper, response_interceptor, maske, currentXml, params.get("contenttype"), params.get("stylesheet"));
        }
    }

    public static BufferedImage toBufferedImage(byte[] bytes) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        BufferedImage bi = ImageIO.read(is);
        return bi;
    }

    private static void addStylesheetAndFormatToMask(Map<String, String> params, Maske maske) {
        String tablestylesheet = params.get("tablestylesheet");
        if (tablestylesheet != null && tablestylesheet.endsWith(".jrxml")) {
            maske.setSelectedTableStylesheetFileAndContenttype(tablestylesheet);
            maske.setDesiredContenttype(params.get("contenttype"));
        }
    }

    private void runJasperGeneration(HttpServletRequest request, HttpServletStreamInterceptor response_intercepted, Maske maske, String currentXml) throws IOException, JRException {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        String stylesheetFile = maske.getSelectedTableStylesheetFilename();
        logger.debug((Object)("Select jr_datasource for stylesheet " + stylesheetFile));
        String jr_datasource = (String)jt.queryForObject("SELECT TRIM(jr_datasource) FROM sx_stylesheets WHERE TRIM(filename)='" + stylesheetFile + "' ORDER BY 1 LIMIT 1", String.class);
        logger.debug((Object)("Selected jr_datasource " + jr_datasource));
        jr_datasource = jr_datasource == null ? "" : jr_datasource;
        JasperCreator jc = Report.initJasperCreator(request, response_intercepted, maske);
        if ("xml".equalsIgnoreCase(jr_datasource) || "".equals(jr_datasource) && stylesheetFile.indexOf("_xmlsource") > -1) {
            String localizedXml = SxPools.get(ServletUtils.getMandantenID(request)).localize(currentXml, request.getLocale());
            jc.perform(ServletUtils.getMandantenID(request), localizedXml, null);
        } else {
            jc.perform(ServletUtils.getMandantenID(request), maske, null);
        }
    }

    private static JasperCreator initJasperCreator(HttpServletRequest request, HttpServletStreamInterceptor response_intercepted, Maske maske) throws IOException, JRException {
        String reports_dir = SuperXManager.getWEB_INFPfad() + File.separator + "reports" + File.separator;
        JasperCreator jc = new JasperCreator(request, (HttpServletResponse)response_intercepted, (SxUser)request.getSession().getAttribute("user"), maske, maske.getSelectedTableStylesheetFilename(), maske.getDesiredContenttype(), reports_dir);
        return jc;
    }

    private static void runGenericGeneration(HttpServletRequest request, HttpServletStreamInterceptor response_intercepted, Maske maske, String currentXml, String contenttype, String stylesheet) throws IOException, DBServletException, FactoryConfigurationError, ParserConfigurationException, TransformerException {
        String stylesheetDir = SuperXManager.getWEB_INFPfad().substring(0, SuperXManager.getWEB_INFPfad().lastIndexOf(File.separator)) + File.separator + "xml" + File.separator;
        XmlTransformer xmlTransformer = new XmlTransformer(null, request, (HttpServletResponse)response_intercepted, maske.getMandantenId(), null);
        xmlTransformer.setMaske(maske);
        xmlTransformer.transform(maske.getName(), maske.getTmpFiles(), currentXml, Locale.GERMANY, stylesheetDir + stylesheet, contenttype, null);
    }

    private static void createXml(HttpServletStreamInterceptor response_interceptor, String currentXml, String maskenName) throws IOException {
        response_interceptor.setHeader("Content-disposition", "attachment; filename=" + FileUtils.removeProblemChars(maskenName) + ".xml");
        response_interceptor.setHeader("Cache-Control", "expires=0");
        HttpServletStreamInterceptor.SxServletOutputStream out = response_interceptor.getOutputStream();
        byte[] stuff = currentXml.getBytes(SqlStringUtils.getEncoding());
        out.write(stuff);
        out.close();
    }

    private static void createCsv(HttpServletStreamInterceptor response_intercepted, Maske maske) throws IOException, UnsupportedEncodingException {
        StringBuffer csv = maske.getCSV(maske.getMandantenId());
        response_intercepted.setHeader("Content-disposition", "attachment; filename=" + FileUtils.removeProblemChars(maske.getName()) + ".csv");
        response_intercepted.setHeader("Cache-Control", "expires=0");
        response_intercepted.setContentType(CSV_CONTENTTYPE);
        HttpServletStreamInterceptor.SxServletOutputStream out = response_intercepted.getOutputStream();
        byte[] stuff = csv.toString().getBytes(SqlStringUtils.getEncoding());
        out.write(stuff);
        out.close();
    }

    private static Download createDownloadObject(HttpServletStreamInterceptor response, Maske maske, SxUser user) throws ParseException {
        byte[] ba = response.getOutputStream().toByteArray();
        String base64String = Base64.getEncoder().encodeToString(ba);
        Download dl = new Download();
        dl.base64String = base64String;
        String contentDisposition = response.getHeader("Content-disposition");
        if (contentDisposition != null && contentDisposition.contains("filename=")) {
            String[] parts = contentDisposition.split("filename=");
            dl.filename = parts[1];
        }
        dl.contentType = response.getContentType();
        dl.addLegend(maske, user);
        return dl;
    }

    private static List<TreeNode<Data>> getChildrenFor(SelectableItemNode node) {
        int childCount = node.getChildCount();
        ArrayList<TreeNode<Data>> children = new ArrayList<TreeNode<Data>>(childCount);
        for (int i = 0; i < childCount; ++i) {
            SelectableItemNode child = (SelectableItemNode)node.getChildAt(i);
            SelectableItem item = (SelectableItem)child.getUserObject();
            TreeNode treeNode = new TreeNode(item.hashCode(), item.getName(), (String)item.getId());
            treeNode.children = Report.getChildrenFor(child);
            children.add(treeNode);
        }
        return children;
    }

    private static Map<String, String> removeViewInformation(Map<String, String> params) {
        HashMap<String, String> result = new HashMap<String, String>();
        params.forEach((key, value) -> {
            int idx = -1;
            if (value != null) {
                idx = value.lastIndexOf(58);
            }
            String outValue = idx > -1 ? value.substring(idx + 1) : value;
            result.put((String)key, outValue);
        });
        return result;
    }
}

