/*
 * Decompiled with CFR 0.152.
 */
package de.superx.db;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.NamingException;
import org.codehaus.groovy.control.CompilationFailedException;

public class H2InMemoryCreator {
    public static final String JDBC_H2_IN_MEMORY_URL = "jdbc:h2:mem:eduetl;DB_CLOSE_DELAY=-1;MODE=POSTGRESQL;DATABASE_TO_LOWER=TRUE;NON_KEYWORDS=KEY,VALUE;BUILTIN_ALIAS_OVERRIDE=TRUE";
    public static final String JDBC_H2_IN_FILE_URL = "jdbc:h2:~/eduetl;MODE=POSTGRESQL;DATABASE_TO_LOWER=TRUE;NON_KEYWORDS=KEY,VALUE";
    private String h2Url = "jdbc:h2:mem:eduetl;DB_CLOSE_DELAY=-1;MODE=POSTGRESQL;DATABASE_TO_LOWER=TRUE;NON_KEYWORDS=KEY,VALUE;BUILTIN_ALIAS_OVERRIDE=TRUE";
    private String schemaDir;
    private String viewDir;
    private String unlDir;
    private String userName;
    private String tablePattern;
    private String viewPattern;

    public H2InMemoryCreator() {
    }

    public H2InMemoryCreator(String url) {
        this.h2Url = url;
    }

    public void createH2InMemory() throws CompilationFailedException, IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NamingException {
        System.setProperty("h2.consoleTimeout", "20000");
        try (Connection con = DriverManager.getConnection(this.h2Url, "sa", "");
             Statement st = con.createStatement();){
            st.execute("DROP ALL OBJECTS");
        }
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader();
        File buildDbScript = new File("scripts/groovy/build_db.groovy");
        Class buildDbGroovy = groovyClassLoader.parseClass(buildDbScript);
        groovyClassLoader.close();
        GroovyObject buildDbInstance = (GroovyObject)buildDbGroovy.newInstance();
        Object[] params = new Object[]{"-schemaDir", this.schemaDir, "-viewDir", this.viewDir, "-unlDir", this.unlDir, "-jdbcUrl", this.h2Url, "-jdbcDriverClass", "org.h2.Driver", "-username", this.userName, "-tablePattern", this.tablePattern, "-viewPattern", this.viewPattern, "-p", "-v"};
        buildDbInstance.invokeMethod("main", (Object)params);
    }

    public String getSchemaDir() {
        return this.schemaDir;
    }

    public H2InMemoryCreator setSchemaDir(String schemaDir) {
        this.schemaDir = schemaDir;
        return this;
    }

    public String getViewDir() {
        return this.viewDir;
    }

    public H2InMemoryCreator setViewDir(String viewDir) {
        this.viewDir = viewDir;
        return this;
    }

    public String getUnlDir() {
        return this.unlDir;
    }

    public H2InMemoryCreator setUnlDir(String unlDir) {
        this.unlDir = unlDir;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public H2InMemoryCreator setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getTablePattern() {
        return this.tablePattern;
    }

    public H2InMemoryCreator setTablePattern(String tablePattern) {
        this.tablePattern = tablePattern;
        return this;
    }

    public String getViewPattern() {
        return this.viewPattern;
    }

    public H2InMemoryCreator setViewPattern(String viewPattern) {
        this.viewPattern = viewPattern;
        return this;
    }
}

