/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.service;

import de.superx.bianalysis.FaultyMetadataException;
import de.superx.bianalysis.ReportDefinition;
import de.superx.bianalysis.ReportMetadata;
import de.superx.bianalysis.StoredReport;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.Condition;
import de.superx.bianalysis.models.CriteriaGroup;
import de.superx.bianalysis.models.Dimension;
import de.superx.bianalysis.models.DimensionAttribute;
import de.superx.bianalysis.models.FactTable;
import de.superx.bianalysis.models.Filter;
import de.superx.bianalysis.models.Measure;
import de.superx.bianalysis.repository.DimensionAttributeRepository;
import de.superx.bianalysis.repository.DimensionRepository;
import de.superx.bianalysis.repository.MeasureFilterRepository;
import de.superx.bianalysis.repository.MeasureRepository;
import de.superx.bianalysis.repository.StoredReportRepository;
import de.superx.bianalysis.repository.dto.AttributeDto;
import de.superx.bianalysis.repository.dto.DimensionDto;
import de.superx.bianalysis.repository.dto.FactDto;
import de.superx.bianalysis.repository.dto.MeasureDto;
import de.superx.bianalysis.repository.dto.MeasureFilterDto;
import de.superx.bianalysis.sqlgeneration.AttributeGroupQueryBuilder;
import de.superx.bianalysis.sqlgeneration.SqlQuery;
import de.superx.common.NotYetImplementedException;
import de.superx.jdbc.entity.Sachgebiet;
import de.superx.jdbc.entity.Systeminfo;
import de.superx.jdbc.repository.SachgebieteRepository;
import de.superx.jdbc.repository.SysteminfoRepository;
import de.superx.rest.model.Item;
import de.superx.spring.service.UserService;
import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
public class DbMetaAdapter
implements InitializingBean {
    @Autowired
    MeasureRepository measureRepository;
    @Autowired
    DimensionRepository dimensionRepository;
    @Autowired
    DimensionAttributeRepository dimensionAttrRepo;
    @Autowired
    MeasureFilterRepository measureFilterRepo;
    @Autowired
    StoredReportRepository storedReportRepository;
    @Autowired
    SachgebieteRepository sachgebieterepository;
    @Autowired
    SysteminfoRepository systeminfoRepository;
    @Autowired
    UserService userService;
    @Autowired
    DataSource dataSource;
    private JdbcTemplate jt;
    public static final Rechtekonzept rechteModus = Rechtekonzept.None;

    public void afterPropertiesSet() throws Exception {
        this.jt = new JdbcTemplate(this.dataSource);
    }

    private List<FactDto> getFactDtos(String sql) {
        ArrayList<FactDto> factDtos = new ArrayList<FactDto>();
        SqlRowSet result = this.jt.queryForRowSet(sql);
        result.beforeFirst();
        while (result.next()) {
            FactDto fd = new FactDto();
            fd.id = new Identifier(result.getString("id"));
            fd.caption = result.getString("caption");
            fd.tablename = result.getString("tablename");
            fd.defaultRelease = result.getString("default_release");
            fd.sachgebiettid = result.getInt("sachgebiettid");
            fd.description = result.getString("description");
            factDtos.add(fd);
        }
        return factDtos;
    }

    public List<FactTable> getFactTables() throws NotYetImplementedException {
        return this.getFactTables(new ArrayList<Integer>(), new ArrayList<Identifier>());
    }

    public List<FactTable> getFactTables(List<Integer> sachgebieteTids, List<Identifier> facts) throws NotYetImplementedException {
        try {
            List<FactDto> fdtos = this.getFactDtos("SELECT * FROM " + this.getSchemaName("metadata") + ".facttable;");
            List<FactTable> factTables = fdtos.stream().filter(f -> this.getSachgebietForFacttable((int)f.sachgebiettid.intValue()).tid != -1).filter(f -> sachgebieteTids.isEmpty() || sachgebieteTids.contains((int)f.sachgebiettid)).filter(f -> facts.isEmpty() || facts.contains(f.id) || !this.hasSachgebietTopicRestrictions(facts, f.sachgebiettid)).map(f -> {
                FactTable fact = new FactTable((FactDto)f);
                fact.setSachgebiet(this.getSachgebietForFacttable(f.sachgebiettid));
                fact.setConformedDimensions(this.getConformedDimensionsForFacttable(f.id));
                return fact;
            }).collect(Collectors.toList());
            return factTables;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e.getCause().getMessage().contains("FEHLER: Relation \u00bbmetadata.facttable\u00ab existiert nicht")) {
                throw new NotYetImplementedException("Bitte installieren Sie zuerst die Komponente 'BI-Analyse-Daten' und f\u00fchren Sie anschlie\u00dfend den Konnektor aus.");
            }
            throw e;
        }
    }

    private boolean hasSachgebietTopicRestrictions(List<Identifier> facts, int tid) {
        for (Identifier factId : facts) {
            if (this.getFactTable(factId).getSachgebiettid() != tid) continue;
            return true;
        }
        return false;
    }

    public List<Dimension> getConformedDimensionsForFacttable(Identifier factId) {
        ArrayList<Dimension> conformedDimension = new ArrayList<Dimension>();
        List<Identifier> ids = this.dimensionRepository.getUsedConformedDimensionsByFactTable(factId.composedId);
        for (Identifier id : ids) {
            Dimension dimension = this.getDimension(id);
            List<DimensionAttribute> attributes = this.getAttributesOfDimension(dimension.getId());
            dimension.setDimensionAttributes(attributes);
            for (DimensionAttribute a : attributes) {
                a.setDimension(dimension);
            }
            conformedDimension.add(this.getDimension(id));
        }
        return conformedDimension;
    }

    public List<DimensionAttribute> getDimensionAttributeMetadata(List<Identifier> attributeIds, Identifier factId) {
        if (attributeIds == null || attributeIds.size() <= 0) {
            return null;
        }
        ArrayList<DimensionAttribute> result = new ArrayList<DimensionAttribute>();
        for (Identifier id : attributeIds) {
            Optional<AttributeDto> optAttributeConf;
            Identifier rpId;
            Optional<AttributeDto> optAttribute = this.dimensionAttrRepo.findById(id);
            if (optAttribute.isEmpty()) {
                throw new FaultyMetadataException(id, "Attribute");
            }
            DimensionAttribute attr = new DimensionAttribute(optAttribute.get());
            Dimension dim = null;
            if (factId != null && (rpId = this.getRolePlayingDimensionWithNoAttributes(id.composedId, factId.composedId)) != null) {
                dim = this.getDimension(rpId);
            }
            if (dim == null) {
                dim = this.getDimension(attr.getDimensionId());
            }
            attr.setDimension(dim);
            if (attr.getAttrConformedId() != null && (optAttributeConf = this.dimensionAttrRepo.findById(new Identifier(attr.getAttrConformedId()))).isPresent()) {
                Dimension dimConf = this.getDimension(optAttributeConf.get().dimensionId);
                attr.setDimConformedId(dimConf.getId().composedId);
            }
            result.add(attr);
        }
        return result;
    }

    public List<Measure> getMeasureMetadata(List<Identifier> measureIds) {
        if (measureIds != null && measureIds.size() > 0) {
            ArrayList<Measure> result = new ArrayList<Measure>();
            for (Identifier id : measureIds) {
                Measure measure = this.getMeasure(id);
                if (measure.getMeasureFilterId() != null) {
                    MeasureFilterDto filter = (MeasureFilterDto)this.measureFilterRepo.findById(measure.getMeasureFilterId()).get();
                    if (filter.dimensionAttributeId != null) {
                        DimensionAttribute attribute = this.getDimensionAttributeById(filter.dimensionAttributeId);
                        Dimension dimension = this.getDimension(attribute.getDimensionId());
                        measure.setMeasureFilterAttributes(filter, attribute, dimension);
                    } else if (filter.factColumnFilter != null) {
                        measure.setFactColumnFilter(filter);
                    }
                }
                result.add(measure);
            }
            return result;
        }
        return null;
    }

    public List<Dimension> getDimensionsWithoutHidden(Identifier factTableId) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        for (Dimension dimension : this.getDimensions(factTableId)) {
            if (dimension.isHidden()) continue;
            dimensions.add(dimension);
            ArrayList<DimensionAttribute> attributes = new ArrayList<DimensionAttribute>();
            for (DimensionAttribute attribute : dimension.getDimensionAttributes()) {
                if (attribute.isHidden()) continue;
                attributes.add(attribute);
            }
            dimension.setDimensionAttributes(attributes);
        }
        return dimensions;
    }

    public List<Dimension> getDimensions(Identifier factTableId) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        for (DimensionDto dimensionDto : this.dimensionRepository.findByFactTableId(factTableId)) {
            Dimension dimension = new Dimension(dimensionDto);
            dimensions.add(dimension);
            List<DimensionAttribute> attr = this.getAttributesOfDimension(dimension.getId());
            dimension.setDimensionAttributes(attr);
            if (dimension.getConformed() != null) {
                boolean allAttributesAreCustom;
                Dimension dimConf = this.getDimension(new Identifier(dimension.getConformed()));
                dimension.conformedCaption = dimConf.getCaption();
                dimension.conformedDescription = dimConf.getDescription();
                boolean bl = allAttributesAreCustom = attr.isEmpty() || attr.stream().allMatch(a -> "custom".equals(a.getDefaultRelease()));
                if (allAttributesAreCustom && !dimension.getConformed().isEmpty()) {
                    List<DimensionAttribute> conformedAttrs = this.getAttributesOfDimension(new Identifier(dimension.getConformed()));
                    conformedAttrs.forEach(a -> {
                        a.setAttrConformedId(a.getStringId());
                        a.setHierarchy(dimConf.isHierarchy());
                        a.setCriteriaGroups(a.getCriteriaGroups());
                    });
                    attr.addAll(conformedAttrs);
                    dimension.setDimensionAttributes(attr);
                    continue;
                }
            }
            for (DimensionAttribute a2 : attr) {
                if (a2.getAttrConformedId() != null) {
                    DimensionAttribute attribute = this.getDimensionAttributeById(new Identifier(a2.getAttrConformedId()));
                    a2.setConformedCaption(attribute.getCaption());
                    a2.setConformedDescription(attribute.getDescription());
                }
                a2.setDimension(dimension);
            }
        }
        dimensions.sort(Comparator.comparing(Dimension::getPosition, Comparator.nullsLast(Integer::compareTo)));
        return dimensions;
    }

    public List<DimensionAttribute> getAllowedDimensionAttributes(List<Identifier> ids, List<Integer> sachgebietTids, List<Identifier> factTables) {
        ArrayList<DimensionAttribute> attributes = new ArrayList<DimensionAttribute>();
        for (Identifier id : ids) {
            DimensionAttribute attr = this.getDimensionAttributeById(id);
            Dimension dim = this.getDimension(attr.getDimensionId());
            attr.setDimension(dim);
            Optional<FactDto> factOpt = this.getFactDtoById(dim.getId());
            if (factOpt.isPresent()) {
                if (!factTables.contains(factOpt.get().id)) continue;
                Integer sachgebiettsTid = (int)factOpt.get().sachgebiettid;
                if (!sachgebietTids.isEmpty() && !sachgebietTids.contains(sachgebiettsTid)) continue;
            }
            attributes.add(attr);
        }
        return attributes;
    }

    private Optional<FactDto> getFactDtoById(Identifier id) {
        String sql = String.format("SELECT * FROM %s.facttable WHERE id = '%s';", this.getSchemaName("metadata"), id.toString());
        List<FactDto> fdtos = this.getFactDtos(sql);
        Optional<Object> factOpt = Optional.ofNullable(null);
        if (fdtos.size() > 0) {
            factOpt = Optional.ofNullable(fdtos.get(0));
        }
        return factOpt;
    }

    public List<String> getDimensionAttributeValues(List<DimensionAttribute> attributes, List<Identifier> factTables) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> tables = new ArrayList<String>();
        for (DimensionAttribute attr : attributes) {
            if (tables.contains(attr.getTablename())) continue;
            tables.add(attr.getTablename());
            for (Identifier factId : factTables) {
                result.addAll(this.getValuesOfAttribute(attr, factId, null, null));
            }
        }
        return result;
    }

    public List<String> getValuesOfAttribute(DimensionAttribute attr, Identifier factId, List<Filter> filtersInDimension, Boolean hideEmptyColumns) {
        FactTable fact = this.getFactTable(factId);
        Identifier dimId = this.getRolePlayingDimensionWithNoAttributes(attr.getId().composedId, factId.composedId);
        Dimension dim = null;
        dim = dimId != null ? this.getDimension(dimId) : this.getDimension(attr.getDimensionId());
        List<String> values = this.getDimensionAttributeValues(attr, dim, fact, filtersInDimension, hideEmptyColumns);
        return values;
    }

    public List<List<Object>> getDimensionAttributeValuesHierarchy(Identifier attribute_id) {
        DimensionAttribute attr = this.getDimensionAttributeById(attribute_id);
        Dimension dim = this.getDimension(attr.getDimensionId());
        return this.getDimensionAttributeValuesHierarchy(attr.getColumnname(), dim.getTablename());
    }

    public List<Filter> getFilterMetadata(List<Filter> filters) {
        for (Filter filter : filters) {
            DimensionAttribute attr = this.getDimensionAttributeById(filter.dimensionAttributeId);
            Dimension dim = this.getDimension(attr.getDimensionId());
            attr.setDimension(dim);
            filter.setDimension(dim);
            filter.setDimensionAttribute(attr);
        }
        return filters;
    }

    public List<String> getDimensionAttributeValues(DimensionAttribute attr, Dimension dim, FactTable factTable, List<Filter> filtersInDimension, Boolean hideEmptyColumns) {
        String idColumn;
        String sortOrderColumnName = attr.getSortOrderColumn() != null ? attr.getSortOrderColumn() : attr.getColumnname();
        String templateSql = "SELECT DISTINCT d.%s AS value, d.%s, array_position(array[%s], d.%s::text) FROM " + this.getSchemaName() + ".%s d";
        if ((factTable != null && attr.getFilterSelection() == null || dim != null && attr.getFilterSelection().equals("show_existing_only")) && hideEmptyColumns == null || hideEmptyColumns != null && hideEmptyColumns.booleanValue()) {
            idColumn = "id";
            if (attr.getDimIdJoinColumn() != null && !attr.getDimIdJoinColumn().isBlank()) {
                idColumn = attr.getDimIdJoinColumn();
            }
            templateSql = templateSql + " INNER JOIN " + this.getSchemaName() + "." + factTable.getTablename() + " f ON d." + idColumn + " = f." + dim.getJoincolumn();
        }
        templateSql = templateSql + " WHERE d.%s IS NOT NULL ";
        if (dim != null && attr.getFilterSelection() != null && attr.getFilterSelection().equals("show_range")) {
            idColumn = "id";
            if (attr.getDimIdJoinColumn() != null && !attr.getDimIdJoinColumn().isBlank()) {
                idColumn = attr.getDimIdJoinColumn();
            }
            templateSql = templateSql + " AND d." + idColumn + " BETWEEN (SELECT MIN(" + dim.getJoincolumn() + ") FROM " + this.getSchemaName() + "." + factTable.getTablename() + ") AND (SELECT MAX(" + dim.getJoincolumn() + " FROM " + this.getSchemaName() + "." + factTable.getTablename() + ")";
        }
        if (filtersInDimension != null) {
            boolean first = true;
            for (Filter filter : filtersInDimension) {
                templateSql = templateSql + " AND ";
                first = true;
                for (String filterValue : filter.filterValues) {
                    if (first) {
                        first = false;
                    } else {
                        templateSql = templateSql + " OR ";
                    }
                    templateSql = templateSql + " d." + filter.columnname + " = '" + filterValue + "'";
                }
            }
        }
        templateSql = templateSql + " ORDER BY 3, 2 ASC;";
        String query = String.format(templateSql, attr.getColumnname(), sortOrderColumnName, DimensionAttribute.specialValueListForSql(), attr.getColumnname(), attr.getTablename(), attr.getColumnname());
        List<String> values = this.jt.query(query, (rs, rowNum) -> rs.getString("value")).stream().distinct().collect(Collectors.toList());
        return values;
    }

    public List<List<Object>> getDimensionAttributeValuesHierarchy(final String columname, String tablename) {
        String query = "select distinct id, parent_id, " + columname + " from " + this.getSchemaName() + "." + tablename;
        List values = this.jt.query(query, new Object[0], (RowMapper)new RowMapper<List<Object>>(){

            public List<Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(rs.getInt("id"));
                result.add(rs.getInt("parent_id"));
                result.add(rs.getString(columname));
                return result;
            }
        });
        return values;
    }

    public DimensionAttribute getDimensionAttributeMetadataById(Identifier id) {
        DimensionAttribute attr = this.getDimensionAttributeById(id);
        Dimension dim = this.getDimension(attr.getDimensionId());
        attr.setDimension(dim);
        return attr;
    }

    public Sachgebiet getSachgebietById(int sachgebietId) {
        return (Sachgebiet)this.sachgebieterepository.findById(sachgebietId).get();
    }

    public int saveReportDefinition(StoredReport report) {
        StoredReport savedStoredReport = (StoredReport)this.storedReportRepository.save(report);
        return savedStoredReport.id;
    }

    public int getBridgeMaxLevel(DimensionAttribute bridgeAttr, ReportMetadata metadata) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String sql = this.buildMaxHierarchyLvlSQL(bridgeAttr, metadata.factTable.getTablename(), metadata.getFilterNoHierarchy(), bridgeAttr.getTablename());
        int value = (Integer)jdbcTemplate.queryForObject(sql, Integer.class) + 1;
        return value;
    }

    public int getBridgeMaxLevel(DimensionAttribute bridgeAttr, ReportMetadata metadata, String factTableName) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String sql = this.buildMaxHierarchyLvlSQL(bridgeAttr, factTableName, metadata.getFilterNoHierarchy(), bridgeAttr.getTablename());
        int value = (Integer)jdbcTemplate.queryForObject(sql, Integer.class) + 1;
        return value;
    }

    public int getBridgeMinLevel(List<Filter> filters, int maxLvl, String dimTable) {
        if (filters == null || filters.isEmpty()) {
            return 0;
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        ArrayList<CallSite> filterValues = new ArrayList<CallSite>();
        for (Filter filter : filters) {
            filterValues.add((CallSite)((Object)("ancestor_" + filter.columnname + "[%s] IN ( " + filter.getValues() + " )")));
        }
        for (int i = 0; i < maxLvl; ++i) {
            String sql = "select count(*) from " + this.getSchemaName() + "." + dimTable + "_hierarchy where ";
            StringJoiner filterJoiner = new StringJoiner(" OR ");
            for (String string : filterValues) {
                filterJoiner.add(String.format(string, i + 1));
            }
            int value = (Integer)jdbcTemplate.queryForObject(sql = sql + filterJoiner.toString(), Integer.class);
            if (value <= 0) continue;
            return i;
        }
        return -1;
    }

    public boolean isAttributeHierarchyBridge(Identifier leftDimensionAttributeId) {
        Optional<AttributeDto> dimAttrOpt = this.dimensionAttrRepo.findById(leftDimensionAttributeId);
        if (dimAttrOpt.isEmpty()) {
            return false;
        }
        Optional<DimensionDto> dimOpt = this.dimensionRepository.findById(dimAttrOpt.get().dimensionId);
        if (dimOpt.isEmpty()) {
            return false;
        }
        if (dimOpt.get().isHierarchy == null) {
            return false;
        }
        return dimOpt.get().isHierarchy;
    }

    public int getColNumbers(List<DimensionAttribute> topDimensionAttributes, List<Filter> filters) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        int num = 1;
        for (DimensionAttribute dimensionAttribute : topDimensionAttributes) {
            Filter filter;
            if (filters != null && filters.size() > 0 && (filter = Filter.findFilterById(filters, dimensionAttribute.getId())) != null && filter.filterValues.size() > 0) {
                num *= filter.filterValues.size();
                continue;
            }
            String sql = String.format("SELECT count(DISTINCT %s) FROM " + this.getSchemaName() + ".%s WHERE %s IS NOT NULL", dimensionAttribute.getColumnname(), dimensionAttribute.getTablename(), dimensionAttribute.getColumnname());
            int value = (Integer)jdbcTemplate.queryForObject(sql, new Object[0], Integer.class);
            num *= value;
        }
        return num;
    }

    public Identifier getRolePlayingDimensionWithNoAttributes(String attrId, String factId) {
        Identifier confDimId = this.dimensionRepository.findDimensionIdForAttribute(attrId);
        List<Identifier> preids = this.dimensionRepository.getRolePlayingIds(confDimId.composedId, factId);
        if (preids.size() == 1) {
            return preids.get(0);
        }
        if (preids.size() > 1) {
            throw new RuntimeException("Not yet implemented: Can't use conformed dimension more than once for the same facttable.");
        }
        return null;
    }

    public Identifier checkIfFactTableHasDimensionAttribute(Identifier conformedAttrId, Identifier fact) {
        Identifier rpId = this.getRolePlayingDimensionWithNoAttributes(conformedAttrId.composedId, fact.composedId);
        if (rpId != null) {
            return conformedAttrId;
        }
        List<Identifier> ids = this.dimensionAttrRepo.findAttributesByConformedAttributeAndFactTable(conformedAttrId.composedId, fact.composedId);
        if (ids.size() == 1) {
            return ids.get(0);
        }
        if (ids.size() > 1) {
            throw new FaultyMetadataException("F\u00fcr die Faktentabelle mit der ID '" + fact.composedId + "' existieren zwei Role-Playing Dimensions zugeh\u00f6rig zu der Conformed Dimension mit der ID '" + conformedAttrId.composedId + "'. Dieser Fall ist zurzeit noch nicht umgesetzt.");
        }
        Identifier id = this.dimensionAttrRepo.findAttributesByIdAndFactTable(conformedAttrId.composedId, fact.composedId);
        return id;
    }

    public boolean checkIfFactTableHasMeasure(Identifier measure, Identifier fact) {
        String sql = String.format("SELECT *  FROM %s.facttable f  LEFT JOIN %s.measure m    ON m.facttable_id = f.id WHERE f.id = '%s'   AND m.id = '%s'", this.getSchemaName("metadata"), this.getSchemaName("metadata"), fact.composedId, measure.composedId);
        List<FactDto> fdtos = this.getFactDtos(sql);
        return fdtos.size() > 0;
    }

    public String getLastUpdate(int tid) {
        Optional systeminfoOpt = this.systeminfoRepository.findById(tid);
        if (systeminfoOpt.isPresent()) {
            Date lastUpdate = ((Systeminfo)systeminfoOpt.get()).datum;
            return new SimpleDateFormat("dd.MM.yyyy hh:mm").format(lastUpdate);
        }
        return "Unknown";
    }

    public String getFactTableNameMaxBridgeLvl(Identifier fact, Identifier attr) {
        String sql = String.format("SELECT *  FROM %s.dimension_attribute da  LEFT JOIN %s.dimension d    ON d.id = da.dimension_id  LEFT JOIN %s.facttable f    ON f.id = d.facttable_id WHERE f.id = '%s'   AND (da.conformed = '%s' OR da.id = '%s')", this.getSchemaName("metadata"), this.getSchemaName("metadata"), this.getSchemaName("metadata"), fact.composedId, attr.composedId, attr.composedId);
        List<FactDto> fdtos = this.getFactDtos(sql);
        return fdtos.get((int)0).tablename;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public int getSachgebietByFactTableId(String factTableId) {
        Optional<FactDto> fact = this.getFactDtoById(new Identifier(factTableId));
        if (fact.isPresent()) {
            return fact.get().sachgebiettid;
        }
        return -1;
    }

    public List<Integer> getSachgebieteForReport(ReportDefinition reportDefinition) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Identifier factTableId : reportDefinition.factTableIds) {
            int sachgebiet = this.getSachgebietByFactTableId(factTableId.composedId);
            result.add(sachgebiet);
        }
        return result;
    }

    public List<StoredReport> findAllStoredReports() {
        ArrayList<StoredReport> reports = new ArrayList<StoredReport>();
        for (StoredReport report : this.storedReportRepository.findAll()) {
            StoredReport.setReportDefinitionFromJson(report);
            reports.add(report);
        }
        return reports;
    }

    public Optional<StoredReport> findById(int id) {
        Optional<StoredReport> report = this.storedReportRepository.findById(id);
        if (report.isPresent()) {
            StoredReport.setReportDefinitionFromJson(report.get());
        }
        return report;
    }

    public void deleteById(int id) {
        this.storedReportRepository.deleteById(id);
    }

    private Sachgebiet getSachgebietForFacttable(int sachgebiettid) {
        Optional sachgebiet = this.sachgebieterepository.findById(sachgebiettid);
        if (sachgebiet.isPresent()) {
            return (Sachgebiet)sachgebiet.get();
        }
        return new Sachgebiet(-1, "Unknown", null);
    }

    public List<String> getSachgebieteForFactTables(List<String> rightParamValues) {
        ArrayList<String> result = new ArrayList<String>();
        for (String id : rightParamValues) {
            int sachgebiet = this.getSachgebietByFactTableId(id);
            if (sachgebiet == -1) continue;
            result.add(String.valueOf(sachgebiet));
        }
        return result;
    }

    public List<DimensionAttribute> getAttributesOfDimension(Identifier dimId) {
        List<AttributeDto> attr = this.dimensionAttrRepo.findByDimensionId(dimId);
        List<DimensionAttribute> attributes = attr.stream().map(a -> new DimensionAttribute((AttributeDto)a)).collect(Collectors.toList());
        attributes.sort(Comparator.comparing(DimensionAttribute::getPosition, Comparator.nullsLast(Integer::compareTo)));
        return attributes;
    }

    public Dimension getDimension(Identifier id) {
        Optional<DimensionDto> dimOpt = this.dimensionRepository.findById(id);
        if (dimOpt.isEmpty()) {
            throw new FaultyMetadataException(id, "Dimension");
        }
        Dimension dimension = new Dimension(dimOpt.get());
        return dimension;
    }

    public Measure getMeasure(Identifier id) {
        Optional measureOpt = this.measureRepository.findById(id);
        if (measureOpt.isEmpty()) {
            throw new FaultyMetadataException(id, "Measure");
        }
        Measure measure = new Measure((MeasureDto)measureOpt.get());
        return measure;
    }

    public DimensionAttribute getDimensionAttributeById(Identifier dimAttrId) {
        Optional<AttributeDto> optAttr = this.dimensionAttrRepo.findById(dimAttrId);
        if (optAttr.isEmpty()) {
            throw new FaultyMetadataException(dimAttrId, "Attribute");
        }
        return new DimensionAttribute(optAttr.get());
    }

    public List<Measure> getMeasures(Identifier factTableId) {
        ArrayList<Measure> measures = new ArrayList<Measure>();
        for (MeasureDto measureDto : this.measureRepository.findByFactTableId(factTableId)) {
            if (measureDto.isHidden.booleanValue()) continue;
            measures.add(new Measure(measureDto));
        }
        return measures;
    }

    public FactTable getFactTable(Identifier factTableId) {
        Optional<FactDto> optFact = this.getFactDtoById(factTableId);
        if (optFact.isEmpty()) {
            throw new FaultyMetadataException(factTableId, "Fact");
        }
        return new FactTable(optFact.get());
    }

    private String buildMaxHierarchyLvlSQL(DimensionAttribute bridgeAttr, String factTable, List<Filter> filters, String dimTab) {
        String idColumn = bridgeAttr.getDimIdJoinColumn();
        if (idColumn == null) {
            idColumn = "id";
        }
        String sql = "SELECT MAX(lvl) FROM " + this.getSchemaName() + "." + factTable + " fw LEFT JOIN " + this.getSchemaName() + "." + dimTab + "_hierarchy h ON h." + idColumn + " = fw." + bridgeAttr.getJoincolumn();
        return sql;
    }

    public static List<Item> getDefaultReleaseValues(DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        String sql = "SELECT default_release FROM metadata.facttable UNION SELECT default_release FROM metadata.dimension UNION SELECT default_release FROM metadata.dimension_attribute UNION SELECT default_release FROM metadata.measure UNION SELECT default_release FROM metadata.measure_filter";
        List results = jdbcTemplate.queryForList(sql, String.class);
        if (!results.contains("custom")) {
            results.add("custom");
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (String value : results) {
            if (value == null || value.isEmpty()) continue;
            items.add(new Item(value, value));
        }
        return items;
    }

    public void saveAllAttributeGroups() {
        List<AttributeDto> groups = this.dimensionAttrRepo.findByNonEmptyCriteriaGroup();
        for (AttributeDto attribute : groups) {
            this.saveAttributeGroupColumn(attribute, false);
            this.saveAttributeGroupColumn(attribute, true);
        }
    }

    public void saveAttributeGroupColumn(AttributeDto attribute, boolean isSortOrder) {
        DimensionDto dimension = this.dimensionRepository.findByIdOrThrow(attribute.dimensionId);
        Object columnname = attribute.columnname;
        if (isSortOrder) {
            columnname = attribute.sortOrderColumn != null && !attribute.sortOrderColumn.isBlank() ? (String)columnname + attribute.sortOrderColumn : (String)columnname + "_sort_order";
        }
        String tableName = "presentation." + dimension.tablename;
        String columnSql = String.format("ALTER TABLE %s DROP COLUMN IF EXISTS %s;\nALTER TABLE %s ADD COLUMN %s text;\n", tableName, columnname, tableName, columnname);
        List<CriteriaGroup> groups = attribute.readCriteriaGroups();
        SqlQuery query = AttributeGroupQueryBuilder.buildColumnQuery(groups, tableName, isSortOrder, (String)columnname);
        this.jt.execute(columnSql);
        this.jt.update(query.getSql(), query.getParams(), query.getTypes());
    }

    private static List<String> getAllColumns(List<CriteriaGroup> groups) {
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        for (CriteriaGroup group : groups) {
            if (group.isElse) continue;
            DbMetaAdapter.collectColumns(group.conditions, columns);
        }
        return new ArrayList<String>(columns);
    }

    private static void collectColumns(List<Object> conditions, Set<String> columns) {
        for (Object obj : conditions) {
            if (Condition.isCondition(obj)) {
                Condition condition = Condition.fromMap(obj);
                columns.add(condition.column);
                continue;
            }
            if (!CriteriaGroup.isGroup(obj)) continue;
            CriteriaGroup subgroup = CriteriaGroup.fromMap(obj);
            DbMetaAdapter.collectColumns(subgroup.conditions, columns);
        }
    }

    public List<String> validateAttibuteGroup(AttributeDto attribute, Identifier dimensionId) {
        DimensionDto dimension = this.dimensionRepository.findByIdOrThrow(dimensionId);
        String tableName = "presentation." + dimension.tablename;
        List<CriteriaGroup> groups = attribute.readCriteriaGroups();
        List<String> allColumns = DbMetaAdapter.getAllColumns(groups);
        String colList = String.join((CharSequence)", ", allColumns);
        SqlQuery query = AttributeGroupQueryBuilder.buildValidationQuery(tableName, colList, groups);
        List results = this.jt.query(query.getSql(), query.getParams(), query.getTypes(), (rs, rowNum) -> {
            StringJoiner row = new StringJoiner(", ");
            for (String col : allColumns) {
                row.add(col + "=\"" + rs.getString(col) + "\"");
            }
            return row.toString();
        });
        return results;
    }

    public AttributeDto saveAttributeGroup(AttributeDto attributeGroup, Identifier dimensionId) {
        List<CriteriaGroup> groups;
        List<String> allColumns;
        List attributeColumns;
        AttributeDto updatedOrCreatedAttribute;
        boolean editAttribute;
        boolean bl = editAttribute = attributeGroup.id != null && attributeGroup.id.composedId != null && !attributeGroup.id.composedId.isEmpty();
        if (attributeGroup.caption == null || attributeGroup.caption.isBlank()) {
            throw new FaultyMetadataException("Die Bezeichnung des Attributes darf nicht leer sein.");
        }
        Optional<AttributeDto> attributeOpt = this.dimensionAttrRepo.findByDimensionId(dimensionId).stream().filter(a -> a.caption.equals(attributeGroup.caption)).findFirst();
        if (!editAttribute && attributeOpt.isPresent()) {
            throw new FaultyMetadataException("Attribut mit der Bezeichnung '" + attributeGroup.caption + "' existiert bereits.");
        }
        Identifier targetAttributeId = attributeGroup.id;
        Identifier targetDimensionId = dimensionId;
        if (editAttribute) {
            String conformedDimensionId = this.dimensionAttrRepo.findByIdOrThrow((Identifier)attributeGroup.id).attrConformedId;
            updatedOrCreatedAttribute = this.saveAttribute(attributeGroup, targetAttributeId, targetDimensionId, false, new Identifier(conformedDimensionId));
        } else {
            updatedOrCreatedAttribute = this.saveAttribute(attributeGroup, null, targetDimensionId, false, null);
        }
        DimensionDto dimension = this.dimensionRepository.findByIdOrThrow(dimensionId);
        if (dimension.conformed != null && !dimension.conformed.isBlank() && (attributeColumns = this.dimensionAttrRepo.findByDimensionId(dimensionId).stream().map(d -> d.columnname).collect(Collectors.toList())).containsAll(allColumns = DbMetaAdapter.getAllColumns(groups = attributeGroup.readCriteriaGroups()))) {
            targetDimensionId = new Identifier(dimension.conformed);
            if (editAttribute) {
                Identifier confId = new Identifier(updatedOrCreatedAttribute.attrConformedId);
                this.saveAttribute(attributeGroup, confId, targetDimensionId, true, null);
            } else {
                AttributeDto confAttr = this.saveAttribute(attributeGroup, null, targetDimensionId, true, null);
                updatedOrCreatedAttribute = this.saveAttribute(attributeGroup, updatedOrCreatedAttribute.id, dimensionId, false, confAttr.id);
            }
        }
        if (targetDimensionId.namespace.startsWith("conf")) {
            ArrayList<DimensionDto> rolePlayingDimensions = new ArrayList<DimensionDto>();
            for (DimensionDto d2 : this.dimensionRepository.findAll()) {
                if (d2.conformed == null || !d2.conformed.equals(targetDimensionId.composedId) || d2.id.equals(dimensionId)) continue;
                rolePlayingDimensions.add(d2);
            }
            for (DimensionDto dimensionDto : rolePlayingDimensions) {
                Identifier targetAttribute = null;
                if (editAttribute) {
                    Optional<AttributeDto> attr;
                    String conformedId = updatedOrCreatedAttribute.attrConformedId;
                    if (conformedId == null || conformedId.isBlank()) {
                        conformedId = updatedOrCreatedAttribute.id.composedId;
                    }
                    if ((attr = this.dimensionAttrRepo.findByDimensionIdAndAttrConformedId(dimensionDto.id, conformedId)).isPresent()) {
                        targetAttribute = attr.get().id;
                    }
                }
                this.saveAttribute(attributeGroup, targetAttribute, dimensionDto.id, true, new Identifier(updatedOrCreatedAttribute.attrConformedId));
            }
        }
        return updatedOrCreatedAttribute;
    }

    private AttributeDto saveAttribute(AttributeDto attributeGroup, Identifier targetAttributeId, Identifier targetDimensionId, boolean isHidden, Identifier conformedAttribute) {
        AttributeDto newAttrDto = new AttributeDto();
        newAttrDto.id = targetAttributeId;
        newAttrDto.dimensionId = targetDimensionId;
        newAttrDto.caption = attributeGroup.caption;
        newAttrDto.description = attributeGroup.description;
        newAttrDto.columnname = attributeGroup.getColumnNameFromCaption();
        newAttrDto.criteriaGroups = attributeGroup.criteriaGroups;
        newAttrDto.isHidden = isHidden;
        newAttrDto.defaultRelease = "custom";
        if (conformedAttribute != null) {
            newAttrDto.attrConformedId = conformedAttribute.composedId;
        }
        return (AttributeDto)this.dimensionAttrRepo.save(newAttrDto);
    }

    public void deleteAttributeGroupById(Identifier attributeId) {
        AttributeDto attribute = this.dimensionAttrRepo.findByIdOrThrow(attributeId);
        this.deleteColumnForAttributeGroup(attributeId, attribute.dimensionId);
        if (attribute.attrConformedId != null) {
            for (AttributeDto rolePlayingAttribute : this.dimensionAttrRepo.findAll()) {
                if (rolePlayingAttribute.attrConformedId == null || rolePlayingAttribute.attrConformedId.isBlank() || !rolePlayingAttribute.attrConformedId.equals(attribute.attrConformedId)) continue;
                this.dimensionAttrRepo.deleteById(rolePlayingAttribute.id);
            }
            this.dimensionAttrRepo.deleteById(attribute.attrConformedId);
        } else {
            this.dimensionAttrRepo.deleteById(attribute.id);
        }
        this.dimensionAttrRepo.deleteById(attributeId);
    }

    public void deleteColumnForAttributeGroup(Identifier attrId, Identifier dimId) {
        AttributeDto attribute = this.dimensionAttrRepo.findByIdOrThrow(attrId);
        DimensionDto dimension = this.dimensionRepository.findByIdOrThrow(dimId);
        String tablename = dimension.tablename;
        String columnname = attribute.columnname;
        String sql = "ALTER TABLE presentation.%s\nDROP COLUMN IF EXISTS %s;\n\nALTER TABLE presentation.%s\nDROP COLUMN IF EXISTS %s_sort_order;\n".formatted(tablename, columnname, tablename, columnname);
        this.jt.update(sql);
    }

    public List<AttributeDto> getAttributeGroups() {
        return this.dimensionAttrRepo.findByNonEmptyCriteriaGroup();
    }

    public List<String> getValuesForAttributes(List<Identifier> ids) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> tables = new ArrayList<String>();
        for (Identifier id : ids) {
            DimensionAttribute attr = this.getDimensionAttributeById(id);
            Dimension dim = this.getDimension(attr.getDimensionId());
            attr.setDimension(dim);
            if (tables.contains(attr.getTablename())) continue;
            tables.add(attr.getTablename());
            String sortOrderColumnName = attr.getSortOrderColumn() != null ? attr.getSortOrderColumn() : attr.getColumnname();
            Object templateSql = "SELECT DISTINCT d.%s AS value, d.%s, array_position(array[%s], d.%s::text) FROM presentation.%s d";
            templateSql = (String)templateSql + " WHERE d.%s IS NOT NULL ";
            templateSql = (String)templateSql + " ORDER BY 3, 2 ASC;";
            String query = String.format((String)templateSql, attr.getColumnname(), sortOrderColumnName, DimensionAttribute.specialValueListForSql(), attr.getColumnname(), attr.getTablename(), attr.getColumnname());
            List values = this.jt.query(query, (rs, rowNum) -> rs.getString("value")).stream().distinct().collect(Collectors.toList());
            result.addAll(values);
        }
        return result;
    }

    public void hideAttributeById(Identifier id, Boolean hide) {
        AttributeDto attributeDto = this.dimensionAttrRepo.findByIdOrThrow(id);
        attributeDto.isHidden = hide;
        this.dimensionAttrRepo.save(attributeDto);
    }

    private String getSchemaName() {
        return this.getSchemaName("presentation");
    }

    private String getSchemaName(String sourceSchema) {
        String userName = this.userService.currentUserDetails().getUsername();
        Object schemaName = sourceSchema;
        if (rechteModus == Rechtekonzept.SchemaBased) {
            schemaName = sourceSchema + "_" + userName;
        }
        return schemaName;
    }

    public static enum Rechtekonzept {
        None,
        SchemaBased,
        CTEBased;

    }
}

