/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class HideableNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    protected boolean isHidden;

    public HideableNode() {
        this(null);
    }

    public HideableNode(Object userObject) {
        this(userObject, true, false);
    }

    public HideableNode(Object userObject, boolean allowsChildren) {
        this(userObject, allowsChildren, false);
    }

    public HideableNode(Object userObject, boolean allowsChildren, boolean isHidden) {
        super(userObject, allowsChildren);
        this.isHidden = isHidden;
    }

    public TreeNode getChildAt(int index, boolean filterIsActive) {
        if (!filterIsActive) {
            return super.getChildAt(index);
        }
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        int realIndex = -1;
        int visibleIndex = -1;
        Enumeration en = this.children.elements();
        int size = this.children.size();
        while (en.hasMoreElements()) {
            HideableNode node = (HideableNode)en.nextElement();
            if (!node.isHidden()) {
                ++visibleIndex;
            }
            ++realIndex;
            if (visibleIndex != index) continue;
            return (TreeNode)this.children.elementAt(realIndex);
        }
        if (realIndex < size) {
            return this.getChildAt(index, filterIsActive);
        }
        throw new ArrayIndexOutOfBoundsException("index unmatched");
    }

    public int getChildCount(boolean filterIsActive) {
        if (!filterIsActive) {
            return super.getChildCount();
        }
        if (this.children == null) {
            return 0;
        }
        int count = 0;
        Enumeration en = this.children.elements();
        while (en.hasMoreElements()) {
            HideableNode node = (HideableNode)en.nextElement();
            if (node.isHidden()) continue;
            ++count;
        }
        return count;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
        Enumeration<TreeNode> en = this.children();
        while (en.hasMoreElements()) {
            HideableNode n = (HideableNode)en.nextElement();
            n.setHidden(isHidden);
        }
    }

    public boolean isHidden() {
        boolean result = this.isHidden;
        if (!result) {
            TreeNode[] tp = this.getPath();
            for (int i = 0; i < tp.length; ++i) {
                if (tp[i] == this || !(tp[i] instanceof HideableNode) || !((HideableNode)tp[i]).isHidden()) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

