/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.stat;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class Statistics {
    public static double getAverage(Collection zahlen) {
        double summe = 0.0;
        int nonNullValues = 0;
        for (Object obj : zahlen) {
            if (obj == null) continue;
            BigDecimal aNumber = new BigDecimal(obj.toString());
            summe += aNumber.doubleValue();
            ++nonNullValues;
        }
        return summe / (double)nonNullValues;
    }

    public static double getStd(Collection zahlen) {
        double quadrate = 0.0;
        double mittelwert = Statistics.getAverage(zahlen);
        Iterator it = zahlen.iterator();
        int nonNullValues = 0;
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj == null) continue;
            BigDecimal aNumber = new BigDecimal(obj.toString());
            double zahl = aNumber.doubleValue();
            quadrate += (zahl - mittelwert) * (zahl - mittelwert);
            ++nonNullValues;
        }
        double std = Math.sqrt(quadrate / (double)(nonNullValues - 1));
        return std;
    }

    public static double getAverage(Vector zahlen) {
        return Statistics.getAverage((Collection)zahlen);
    }

    public static double getStd(Vector zahlen) {
        return Statistics.getStd((Collection)zahlen);
    }

    public static Double getZValue(double zahl, double mittelwert, double std) {
        double z = (zahl - mittelwert) / std;
        Double test = z;
        return test;
    }

    public static float getMedian(float[] a) {
        Arrays.sort(a);
        int x = a.length / 2;
        if (a.length % 2 == 0) {
            return (a[x] + a[x - 1]) / 2.0f;
        }
        return a[x];
    }

    public static double getMedian(double[] a) {
        Arrays.sort(a);
        int x = a.length / 2;
        if (a.length % 2 == 0) {
            return (a[x] + a[x - 1]) / 2.0;
        }
        return a[x];
    }

    public static int getMedian(int[] a) {
        Arrays.sort(a);
        int x = a.length / 2;
        if (a.length % 2 == 0) {
            return (a[x] + a[x - 1]) / 2;
        }
        return a[x];
    }

    public static void main(String[] arg) {
        Integer i1 = 1;
        Integer i2 = 2;
        Integer i3 = 3;
        Double d3 = 3.5;
        Double d4m = -4.5;
        Long l5 = 5L;
        Long l11 = 11L;
        BigDecimal bd = new BigDecimal(8.7);
        Vector<Number> allzahlen = new Vector<Number>();
        allzahlen.add(i1);
        allzahlen.add(i2);
        allzahlen.add(i3);
        allzahlen.add(d3);
        allzahlen.add(d4m);
        allzahlen.add(null);
        allzahlen.add(l5);
        allzahlen.add(l11);
        allzahlen.add(bd);
        System.out.println(Statistics.getAverage(allzahlen));
        System.out.println(Statistics.getStd(allzahlen));
    }
}

