/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.db;

import de.memtext.baseobjects.NamedIdObject;
import de.memtext.baseobjects.NamedIdObjectWithParent;
import de.memtext.baseobjects.coll.NamedIdObjectList;
import de.memtext.baseobjects.coll.NamedIdObjectWithParentList;
import de.memtext.db.DbUtils;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DBAccess {
    private String name;
    private Connection con = null;
    private Statement stmt = null;
    private boolean isInJar = false;
    private int updateCount;
    private static IllegalStateException illegalStateEx = new IllegalStateException("DBAccess not inited - connection is null");
    private static Map<String, DBAccess> entries = new HashMap<String, DBAccess>();

    public static DBAccess get(String name) {
        DBAccess one = entries.get(name);
        if (one != null) {
            Connection con = one.getConnection();
            try {
                if (con.isClosed()) {
                    throw new RuntimeException("DBAccess: Connection already closed!");
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("DBAccess: Cannot check for closed connection.", e);
            }
        }
        return one;
    }

    public Connection getConn() {
        return this.con;
    }

    public static boolean hasConnection(String name) {
        return entries.containsKey(name);
    }

    public static void addConnection(String name, Connection con) throws SQLException {
        DBAccess dba = DBAccess.get(name);
        if (dba == null || dba.getConnection().isClosed()) {
            entries.put(name, new DBAccess(name, con));
        }
    }

    public static void removeConnection(String name) throws SQLException {
        DBAccess dba = DBAccess.get(name);
        if (dba != null && !dba.getConnection().isClosed()) {
            dba.closeConnection();
            entries.remove(name);
        }
    }

    public void closeConnection() throws SQLException {
        if (this.stmt != null) {
            this.stmt.close();
        }
        this.con.close();
        this.con = null;
        entries.remove(this);
    }

    public static void closeConnection(String name) throws SQLException {
        DBAccess.get(name).closeConnection();
    }

    private DBAccess(String name, Connection con) throws SQLException {
        this.name = name;
        this.con = con;
        if (con.getMetaData().getDriverName().equals("HSQL Database Engine Driver") && con.getMetaData().getURL().indexOf("res:") > 0) {
            this.isInJar = true;
        }
        this.stmt = con.createStatement();
    }

    public Connection getConnection() {
        return this.con;
    }

    public boolean isInJar() {
        return this.isInJar;
    }

    public String getName() {
        return this.name;
    }

    public String getTableNames() throws SQLException {
        StringBuffer result = new StringBuffer("Tabellen in der Datenbank:");
        DatabaseMetaData meta = this.con.getMetaData();
        ResultSet rs = null;
        rs = meta.getTables(null, null, null, null);
        while (rs.next()) {
            result.append(String.valueOf(rs.getObject(3)) + "  ");
        }
        rs.close();
        return result.toString();
    }

    public boolean hasTable(String tablename) throws SQLException {
        boolean result = false;
        ResultSet rs = this.con.getMetaData().getTables(null, null, null, null);
        while (rs.next()) {
            if (!tablename.equalsIgnoreCase(rs.getObject(3).toString())) continue;
            result = true;
            break;
        }
        rs.close();
        return result;
    }

    public static boolean hasTable(Connection c, String tablename) throws SQLException {
        boolean result = false;
        ResultSet rs = c.getMetaData().getTables(null, null, null, null);
        while (rs.next()) {
            if (!tablename.equalsIgnoreCase(rs.getObject(3).toString())) continue;
            result = true;
            break;
        }
        rs.close();
        return result;
    }

    public StringBuffer getSeperatedString(String sql) throws SQLException {
        return this.getSeperatedString(sql, ",");
    }

    public StringBuffer getSeperatedString(String sql, String separator) throws SQLException {
        StringBuffer erg = new StringBuffer();
        ResultSet result = this.stmt.executeQuery(sql);
        while (result.next()) {
            Object value = result.getObject(1);
            if (value == null) {
                erg.append("null" + separator);
                continue;
            }
            erg.append("'" + String.valueOf(value) + "'" + separator);
        }
        result.close();
        if (erg.length() > 0) {
            StringUtils.deleteLastChar(erg);
        }
        return erg;
    }

    public String getString(String pstSql, Object ... args) throws SQLException {
        String erg = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = this.con.prepareStatement(pstSql);
        int paramPos = 1;
        for (Object arg : args) {
            pst.setObject(paramPos, arg);
            ++paramPos;
        }
        rs = pst.executeQuery();
        if (rs.next()) {
            erg = rs.getString(1);
        }
        rs.close();
        return erg;
    }

    public int execute(String sql) throws SQLException {
        if (this.con == null) {
            throw illegalStateEx;
        }
        this.updateCount = this.stmt.executeUpdate(sql);
        return this.updateCount;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.con == null) {
            throw illegalStateEx;
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
        this.stmt = this.con.createStatement();
        ResultSet rs = this.stmt.executeQuery(sql);
        return rs;
    }

    public Object[] getTablesStartingWith(String prefix) throws SQLException {
        if (this.con == null) {
            throw illegalStateEx;
        }
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = this.con.getMetaData().getTables(null, null, prefix + "%", null);
        while (rs.next()) {
            list.add(rs.getString(3));
        }
        rs.close();
        Object[] result = list.toArray();
        Arrays.sort(result);
        return result;
    }

    public Double getDoubleValue(String sql) throws SQLException {
        Double val = null;
        ResultSet rs = this.executeQuery(sql);
        rs.next();
        Object o = rs.getObject(1);
        rs.close();
        if (o instanceof Double) {
            val = (Double)o;
        } else if (o instanceof BigDecimal) {
            BigDecimal merk = (BigDecimal)o;
            val = merk.doubleValue();
        } else if (o != null) {
            val = Double.valueOf(o.toString());
        }
        return val;
    }

    public boolean hasColumn(String aTablename, String colname) throws SQLException {
        if (this.con == null) {
            throw illegalStateEx;
        }
        boolean result = false;
        if (!this.hasTable(aTablename)) {
            throw new IllegalArgumentException("Database doesn't contain table " + aTablename);
        }
        ResultSet rs = this.con.getMetaData().getColumns(null, null, aTablename.toUpperCase(), colname.toUpperCase());
        while (rs.next()) {
            result = true;
        }
        rs.close();
        return result;
    }

    public int getInt(String query, Object ... args) throws SQLException {
        Integer result = this.getInteger(query, args);
        if (result == null) {
            throw new RuntimeException("nothing or null found");
        }
        return result;
    }

    public Integer getInteger(String pstSQL, Object ... args) throws SQLException {
        Integer erg = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = this.con.prepareStatement(pstSQL);
        int paramPos = 1;
        for (Object arg : args) {
            pst.setObject(paramPos, arg);
            ++paramPos;
        }
        rs = pst.executeQuery();
        Object o = null;
        boolean isFirst = true;
        while (rs.next()) {
            if (!isFirst) continue;
            o = rs.getObject(1);
            isFirst = false;
        }
        if (o != null) {
            if (o instanceof Integer) {
                erg = (Integer)o;
            } else if (o instanceof Long) {
                erg = ((Long)o).intValue();
            } else if (o instanceof Short) {
                erg = ((Short)o).intValue();
            } else {
                throw new IllegalArgumentException("Unbekannter Datentyp in DBAccess getInteger:" + String.valueOf(o.getClass()) + " - " + pstSQL);
            }
        }
        rs.close();
        return erg;
    }

    public List getTableList() throws SQLException {
        if (this.con == null) {
            throw illegalStateEx;
        }
        LinkedList<String> result = new LinkedList<String>();
        ResultSet rs = this.con.getMetaData().getTables(null, null, null, null);
        while (rs.next()) {
            result.add(rs.getObject(3).toString());
        }
        rs.close();
        return result;
    }

    public List getResultList(String sql) throws SQLException {
        List result = new LinkedList();
        ResultSet rs = this.executeQuery(sql);
        result = DbUtils.toResultList(rs);
        rs.close();
        return result;
    }

    public int getColumnType(String tablename, String colname) throws SQLException {
        int result = -9999;
        if (!this.hasTable(tablename)) {
            throw new RuntimeException("Database doesn't contain table " + tablename);
        }
        if (!this.hasColumn(tablename, colname)) {
            throw new RuntimeException("Table " + tablename + " doesn't have column:" + colname);
        }
        ResultSet rs = this.con.getMetaData().getColumns(null, null, tablename.toUpperCase(), colname.toUpperCase());
        while (rs.next()) {
            result = rs.getInt(5);
        }
        rs.close();
        return result;
    }

    public int getColumnCount(String tablename) throws SQLException {
        int result = 0;
        if (!this.hasTable(tablename)) {
            throw new RuntimeException("Database doesn't contain table " + tablename);
        }
        ResultSet rs = this.con.getMetaData().getColumns(null, null, tablename.toUpperCase(), null);
        while (rs.next()) {
            ++result;
        }
        rs.close();
        return result;
    }

    public List getColumnNames(String tablename) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        if (!this.hasTable(tablename)) {
            throw new RuntimeException("Database doesn't contain table " + tablename);
        }
        ResultSet rs = this.con.getMetaData().getColumns(null, null, tablename.toUpperCase(), null);
        while (rs.next()) {
            result.add(rs.getObject(4).toString());
        }
        rs.close();
        return result;
    }

    public void executeAndCheckUpdate1Row(String sql) throws SQLException {
        int updateRowCount = this.execute(sql);
        if (updateRowCount != 1) {
            throw new IllegalStateException("Es wurde nicht 1 Zeile geupdated, sondern " + updateRowCount);
        }
    }

    public void setProperty(String key, String value) throws SQLException {
        if (key == null || value == null) {
            throw new IllegalArgumentException("no nulls allowed in properties table");
        }
        this.execute("delete from properties where name='key';insert into properties (name,value) values('" + key + "','" + value + "');");
    }

    public String getProperty(String key) throws SQLException {
        return this.getString("select value from properties where name='" + key + "'", new Object[0]);
    }

    public NamedIdObjectList getNamedIdObjectList(String tablename, String idColName, String nameColName, String restriction, String orderby, Class targetClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SQLException {
        NamedIdObjectList result = new NamedIdObjectList();
        if (restriction == null) {
            restriction = "";
        }
        List rawList = this.getResultList("select " + idColName + "," + nameColName + " from " + tablename + " " + restriction + " " + orderby);
        Class[] constparams = new Class[]{Object.class, String.class};
        Object[] data = new Object[2];
        Constructor constr = targetClass.getConstructor(constparams);
        for (List row : rawList) {
            Object id = row.get(0);
            String name = "";
            if (row.get(1) != null) {
                name = row.get(1).toString();
            }
            data[0] = id;
            data[1] = name;
            Object o = constr.newInstance(data);
            result.add(o);
        }
        return result;
    }

    public NamedIdObjectList getNamedIdObjectList(String tablename, String idColName, String nameColName, String restriction, String orderby) throws IllegalArgumentException, SQLException, SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        NamedIdObjectList result = null;
        result = this.getNamedIdObjectList(tablename, idColName, nameColName, restriction, orderby, NamedIdObject.class);
        return result;
    }

    public NamedIdObjectWithParentList getNamedIdObjectWithParentList(String tablename, String idColName, String nameColName, String restriction) throws KeyParentEqualException, SQLException {
        NamedIdObjectWithParentList result = new NamedIdObjectWithParentList();
        if (restriction == null) {
            restriction = "";
        }
        List rawList = this.getResultList("select " + idColName + "," + nameColName + ",parent from " + tablename + " " + restriction);
        for (List row : rawList) {
            Object id = row.get(0);
            String name = "";
            if (row.get(1) != null) {
                name = row.get(1).toString();
            }
            Object parentKey = row.get(2);
            NamedIdObjectWithParent one = new NamedIdObjectWithParent(id, name, parentKey);
            result.add(one);
        }
        return result;
    }

    public void execute(StringBuffer sql) throws SQLException {
        this.execute(sql.toString());
    }
}

