/*
 * Decompiled with CFR 0.152.
 */
package de.superx.util;

import de.memtext.util.XMLUtils;
import de.superx.servlet.SuperXManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class PathAndFileUtils {
    public static String MODULE_PATH = String.join((CharSequence)File.separator, "conf", "edustore", "db", "module");
    public static final String PATHSEP = File.separator;
    static Logger logger = LoggerFactory.getLogger(PathAndFileUtils.class);
    private static DocumentBuilderFactory documentBuilderFactory = XMLUtils.createSecureDocumentBuilderFactory();

    public static String getModulePath(String componentAbbreviation) {
        String modulePath = "kern".equals(componentAbbreviation) || "superx".equals(componentAbbreviation) ? String.join((CharSequence)File.separator, PathAndFileUtils.getWebinfPath(), "conf", "edustore", "db", "install") : String.join((CharSequence)File.separator, PathAndFileUtils.getWebinfPath(), MODULE_PATH, componentAbbreviation);
        return modulePath;
    }

    public static File getDbFormsTemplateFile(String componentAbbreviation, String database) {
        return new File(PathAndFileUtils.getWebinfPath() + File.separator + componentAbbreviation + "_dbforms-config_" + database + ".xml");
    }

    public static File getDbFormsConfigFile() {
        return new File(PathAndFileUtils.getWebinfPath() + File.separator + "dbforms-config.xml");
    }

    public static File getXmlFile(String componentAbbreviation) {
        String xmlFilePath = String.join((CharSequence)File.separator, PathAndFileUtils.getModulePath(componentAbbreviation), "conf", componentAbbreviation + ".xml");
        logger.info("XML File Path: " + xmlFilePath);
        return new File(xmlFilePath);
    }

    public static File getUnloadXmlFile(String componentAbbreviation) {
        String xmlFilePath = String.join((CharSequence)File.separator, PathAndFileUtils.getModulePath(componentAbbreviation), "rohdaten", componentAbbreviation + "_unload.xml");
        logger.info("Unload XML File Path: " + xmlFilePath);
        return new File(xmlFilePath);
    }

    public static String getUnloadPath(String componentAbbreviation) {
        String unloadPath = String.join((CharSequence)File.separator, PathAndFileUtils.getModulePath(componentAbbreviation), "rohdaten");
        logger.info("Unload Path: " + unloadPath);
        return unloadPath;
    }

    public static String getDbtJsonPath(String path) {
        return PathAndFileUtils.substituteParamStrings(path);
    }

    public static String getStoredReportDir(String project) {
        Path dbtProjectDir = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "projects", project, "stored_reports");
        return dbtProjectDir.toAbsolutePath().toString();
    }

    public static String getReportGeneratorDir(String project) {
        Path dbtProjectDir = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "projects", project, "bianalysis_metadata");
        return dbtProjectDir.toAbsolutePath().toString();
    }

    public static String getSourcesYML(String project) {
        Path yml = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "projects", project, "transform", "models", "sources.yml");
        return yml.toAbsolutePath().toString();
    }

    public static String getSourcesDbt(String project) {
        Path yml = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "projects", project, "transform", "models");
        return yml.toAbsolutePath().toString();
    }

    public static String getDbtTransformDirectory(String project) {
        Path yml = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "projects", project, "transform", "models");
        return yml.toAbsolutePath().toString();
    }

    public static String buildUnlFile(String compAbbr, String table) {
        return "$" + compAbbr.toUpperCase() + "_LOAD_PFAD/unl/" + table + ".unl";
    }

    public static File getUnlFile(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        int cutIndex = path.indexOf(95);
        int fileIndex = path.lastIndexOf(47);
        String componentAbbreviation = path.substring(1, cutIndex).toLowerCase();
        String unlFile = path.substring(fileIndex + 1);
        String unloadPath = String.join((CharSequence)File.separator, PathAndFileUtils.getModulePath(componentAbbreviation), "rohdaten", "unl", unlFile);
        return new File(unloadPath);
    }

    public static File getScriptFile(String path) {
        int cutIndex = path.indexOf(95);
        String componentAbbreviation = path.substring(1, cutIndex).toLowerCase();
        int fileIndex = path.indexOf(47) + ("superx".equals(componentAbbreviation) ? 11 : 0);
        CharSequence[] scriptFilePathComponents = path.substring(fileIndex + 1).split("//");
        String scriptFilePath = String.join((CharSequence)File.separator, scriptFilePathComponents);
        String scriptPath = String.join((CharSequence)File.separator, PathAndFileUtils.getModulePath(componentAbbreviation), scriptFilePath);
        return new File(scriptPath);
    }

    public static File getDbiFileForManualEtlStep(String componentAbbreviation, String etlStepId, String dbmAbbreviation) {
        String xmlFilePath = String.join((CharSequence)File.separator, PathAndFileUtils.getModulePath(componentAbbreviation), "conf", "his1", "edustore_update", "edustore_" + componentAbbreviation + "_man_" + etlStepId + "_" + dbmAbbreviation + ".xml");
        logger.info("XML File Path: " + xmlFilePath);
        return new File(xmlFilePath);
    }

    public static String getWebinfPath() {
        String result = SuperXManager.getWEB_INFPfad();
        if (result.equals(".")) {
            if (PathAndFileUtils.runningFromJar()) {
                try {
                    return PathAndFileUtils.getWebinfDirectoryFromJar();
                }
                catch (URISyntaxException e) {
                    return "superx/WEB-INF";
                }
            }
            return PathAndFileUtils.getWebinfDirectoryFromClass();
        }
        return result;
    }

    public static File getXslFile(String fileName) {
        String path = String.join((CharSequence)File.separator, PathAndFileUtils.getWebinfPath(), "conf", "edustore", "db", "conf", fileName);
        return new File(path);
    }

    public static String substituteParamStrings(String path) {
        if (!path.startsWith("$")) {
            return path;
        }
        int firstPathSep = path.indexOf(47);
        String result = path.substring(firstPathSep + 1);
        String param = path.substring(1, firstPathSep);
        CharSequence[] filePathComponents = result.split("//");
        String filePath = String.join((CharSequence)File.separator, filePathComponents);
        if (param.endsWith("_LOAD_PFAD") || param.endsWith("_LOAD_PATH")) {
            String componentAbbreviation = param.replaceFirst("_LOAD_PFAD", "").toLowerCase();
            if (param.endsWith("_LOAD_PATH")) {
                componentAbbreviation = param.replaceFirst("_LOAD_PATH", "").toLowerCase();
            }
            result = String.join((CharSequence)File.separator, PathAndFileUtils.getUnloadPath(componentAbbreviation), filePath);
        } else if (param.endsWith("_PFAD") || param.endsWith("_PATH")) {
            String componentAbbreviation = param.substring(0, param.lastIndexOf(95)).toLowerCase();
            result = String.join((CharSequence)File.separator, PathAndFileUtils.getModulePath(componentAbbreviation), filePath);
        } else if ("SUPERX_DIR".equals(param)) {
            result = String.join((CharSequence)File.separator, PathAndFileUtils.getWebinfPath(), "conf", "edustore", filePath);
        }
        return result;
    }

    public static Document readXml(String componentAbbreviation, boolean load) {
        String xmlFilePath = "";
        xmlFilePath = load ? String.join((CharSequence)File.separator, PathAndFileUtils.getModulePath(componentAbbreviation), "conf", componentAbbreviation + ".xml") : String.join((CharSequence)File.separator, PathAndFileUtils.getModulePath(componentAbbreviation), "rohdaten", componentAbbreviation + "_unload.xml");
        Document document = null;
        File xmlFile = new File(xmlFilePath);
        if (!xmlFile.exists()) {
            logger.warn("File not found: " + xmlFilePath);
            return null;
        }
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(xmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return document;
    }

    public static Document readXmlFile(File xmlFile) throws IOException {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(xmlFile);
        }
        catch (Exception e) {
            logger.error("Couldn't read xml file " + xmlFile, (Throwable)e);
            throw new IOException();
        }
        return document;
    }

    public static String getComponentName(String abbreviation) throws IOException {
        File xmlFile = PathAndFileUtils.getXmlFile(abbreviation);
        Document document = PathAndFileUtils.readXmlFile(xmlFile);
        Node module = document.getElementsByTagName("module").item(0);
        return PathAndFileUtils.getAttribute(module.getAttributes(), "thema");
    }

    public static String getModuleVersion(String abbreviation) throws IOException {
        File moduleXml = PathAndFileUtils.getXmlFile(abbreviation);
        Document xml = PathAndFileUtils.readXmlFile(moduleXml);
        NodeList nodes = xml.getElementsByTagName("module");
        Node root = nodes.item(0);
        return PathAndFileUtils.getAttribute(root.getAttributes(), "version");
    }

    public static String getAttribute(NamedNodeMap attributes, String attributeName) {
        Node attribute = attributes != null ? attributes.getNamedItem(attributeName) : null;
        return attribute != null ? attribute.getNodeValue() : "";
    }

    public static String getModuleHash(String abbreviation) throws IOException {
        String moduleDir = PathAndFileUtils.getModulePath(abbreviation);
        String result = "";
        File hashFile = new File(moduleDir + File.separator + "version_hash");
        if (hashFile.canRead()) {
            result = StringUtils.chomp((String)FileUtils.readFileToString((File)hashFile));
        }
        return result;
    }

    public static String getSystemInfoId(String abbreviation) throws IOException {
        File moduleXml = PathAndFileUtils.getXmlFile(abbreviation);
        Document xml = PathAndFileUtils.readXmlFile(moduleXml);
        NodeList nodes = xml.getElementsByTagName("module");
        Node root = nodes.item(0);
        return PathAndFileUtils.getAttribute(root.getAttributes(), "systeminfo_id");
    }

    private static String getJarName() {
        return new File(PathAndFileUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getName();
    }

    private static boolean runningFromJar() {
        String jarName = PathAndFileUtils.getJarName();
        return jarName.contains(".jar");
    }

    public static String getWebinfDirectory() throws URISyntaxException {
        if (PathAndFileUtils.runningFromJar()) {
            return PathAndFileUtils.getWebinfDirectoryFromJar();
        }
        return PathAndFileUtils.getWebinfDirectoryFromClass();
    }

    private static String getWebinfDirectoryFromClass() {
        File f = new File(PathAndFileUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile();
        return f.getAbsolutePath();
    }

    private static String getWebinfDirectoryFromJar() throws URISyntaxException {
        File f1 = new File(PathAndFileUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        File f2 = new File(f1.getParent());
        return f2.getParent();
    }

    public static List<String> getSourceSystems(Document unloadXml) {
        ArrayList<String> result = new ArrayList<String>();
        NodeList sourcesystems = unloadXml.getElementsByTagName("sourcesystem");
        int count = sourcesystems.getLength();
        for (int i = 0; i < count; ++i) {
            Node sourcesystem = sourcesystems.item(i);
            result.add(PathAndFileUtils.getAttribute(sourcesystem.getAttributes(), "name"));
        }
        return result;
    }

    public static List<String> findSourceSystems(String componentAbbreviation) {
        File xmlFile = PathAndFileUtils.getUnloadXmlFile(componentAbbreviation);
        List<String> sourceSystems = new ArrayList<String>();
        if (xmlFile.exists()) {
            Document unloadXml = null;
            try {
                unloadXml = PathAndFileUtils.readXmlFile(xmlFile);
            }
            catch (IOException e) {
                logger.error("Couldn't read unload xml file for " + componentAbbreviation, (Throwable)e);
            }
            sourceSystems = PathAndFileUtils.getSourceSystems(unloadXml);
        }
        return sourceSystems;
    }

    public static List<String> getModules() {
        String[] mods;
        final ArrayList<String> modulesToIgnore = new ArrayList<String>();
        Properties props = new Properties();
        String path = PathAndFileUtils.getWebinfPath() + File.separator + MODULE_PATH + File.separator;
        try (FileInputStream fis = new FileInputStream(path + "/module_ignore.properties");){
            props.load(fis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String mod : mods = props.getProperty("ignore.modules").split(",")) {
            logger.info(mod + " module ignored and not loaded for install");
        }
        modulesToIgnore.addAll(Arrays.asList(mods));
        ArrayList<String> modules = new ArrayList<String>();
        File moduleDirectory = new File(path);
        String[] moduleAbbr = moduleDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File moduleXmlFile = PathAndFileUtils.getXmlFile(name);
                return moduleXmlFile.exists() && !modulesToIgnore.contains(name);
            }
        });
        modules.addAll(Arrays.asList(moduleAbbr));
        modules.add("kern");
        return modules;
    }
}

