/*
 * Decompiled with CFR 0.152.
 */
package de.superx.stat.pl;

import com.google.common.base.Joiner;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.text.WordUtils;

public class SuperxPlausiFehler {
    private String key;
    private PlausiFehler plausiFehler;

    private SuperxPlausiFehler() {
    }

    public SuperxPlausiFehler(PlausiFehler fehler) {
        this.plausiFehler = fehler;
    }

    public String[] getAbschnittInfos() {
        return this.plausiFehler.getAbschnittInfos();
    }

    public int getFehlerArt() {
        return this.plausiFehler.getFehlerArt();
    }

    public String getFehlerArtFuerDBExport() {
        int fehlerArt = this.plausiFehler.getFehlerArt();
        if (fehlerArt == 1) {
            return PlausiArt.MUSS.name();
        }
        if (fehlerArt == 2) {
            return PlausiArt.KANN.name();
        }
        return null;
    }

    public int getFehlerGewicht() {
        return this.plausiFehler.getFehlerGewicht();
    }

    public String getFehlerId() {
        return this.plausiFehler.getFehlerId();
    }

    public int getFehlerInfoTyp() {
        return this.plausiFehler.getFehlerInfoTyp();
    }

    public String getFehlerKorrekturhinweis() {
        return this.plausiFehler.getFehlerKorrekturhinweis();
    }

    public String getFehlerSchluessel() {
        return this.plausiFehler.getFehlerSchluessel();
    }

    public String getFehlertextKurz() {
        return this.plausiFehler.getFehlertextKurz();
    }

    public String getFehlertextLang() {
        return this.plausiFehler.getFehlertextLang();
    }

    public FeldDeskriptorInterface[] getFelder() {
        return this.plausiFehler.getFelder();
    }

    public Throwable getLaufzeitException() {
        return this.plausiFehler.getLaufzeitException();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<String> getEfs() {
        FeldDeskriptorInterface[] felder;
        ArrayList<String> efs = new ArrayList<String>();
        for (FeldDeskriptorInterface feld : felder = this.getFelder()) {
            efs.add(feld.getFeldNameDSB());
        }
        return efs;
    }

    public String getEfList() {
        return WordUtils.wrap((String)Joiner.on((String)", ").join(this.getEfs()), (int)40);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Fehler " + this.getFehlerSchluessel() + " (key " + this.getKey() + "): \n");
        result.append(this.getFehlertextLang() == null || this.getFehlertextLang().isEmpty() ? this.getFehlertextKurz() : this.getFehlertextLang());
        result.append("\n");
        if (this.getFehlerKorrekturhinweis() != null && !this.getFehlerKorrekturhinweis().isEmpty()) {
            result.append("Korrekturhinweis: ");
            result.append(this.getFehlerKorrekturhinweis());
            result.append("\r\n");
        }
        return result.toString();
    }

    public static enum PlausiArt {
        MUSS,
        KANN;

    }
}

