/*
 * Decompiled with CFR 0.152.
 */
package de.superx.stat;

import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.WertNichtTypgerechtException;
import de.superx.stat.DistributionType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StatisticsBase
implements SatzInterface {
    private static Logger logger = LoggerFactory.getLogger(StatisticsBase.class);
    protected DistributionType distributionType = null;
    protected Map<String, String> fields = new HashMap<String, String>();
    public static final String MODULE_PREFIX = "astat_";

    protected StatisticsBase() {
    }

    protected String getStringCheck(String name, String result) {
        return result;
    }

    protected boolean setCheck(String name, String value) {
        return true;
    }

    protected long getLongCheck(String name, long result) throws NoSuchFieldException {
        return result;
    }

    protected boolean hatWertCheck(String name, boolean hat) {
        return hat;
    }

    public String getString(String name) {
        if (!this.distributionType.fieldSet.contains(name)) {
            logger.error("GET: No field with name {} in " + this.distributionType, (Object)name);
            return null;
        }
        String result = this.fields.get(name);
        if (result == null) {
            result = "";
        }
        return this.getStringCheck(name, result);
    }

    public void set(String name, String value) {
        if (!this.distributionType.fieldSet.contains(name)) {
            logger.error("SET: No field with name {} in " + this.distributionType, (Object)name);
            return;
        }
        if (this.setCheck(name, value)) {
            this.fields.put(name, value);
        }
    }

    public static String translateFieldNameToOrig(String fieldName) {
        Object rest = "";
        if (!fieldName.equals("berichtseinheitid")) {
            rest = fieldName.substring(2);
            while (((String)rest).startsWith("0")) {
                rest = ((String)rest).substring(1);
            }
            rest = "EF" + ((String)rest).toUpperCase();
        } else {
            rest = fieldName.toUpperCase();
        }
        return rest;
    }

    public String getString(FeldDeskriptorInterface arg0) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        String efnum = arg0.getFeldNameDSB();
        String result = this.getString(efnum);
        return result;
    }

    public boolean hasFieldLengths() {
        return this.distributionType.fieldLength != null && this.distributionType.fieldLength.length > 0;
    }

    public int getFieldLength(int fieldIndex) {
        return this.hasFieldLengths() ? this.distributionType.fieldLength[fieldIndex] : -1;
    }

    public boolean hatWert(FeldDeskriptorInterface arg0) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        String efnum;
        return this.hatWertCheck(efnum, this.fields.get(efnum = arg0.getFeldNameDSB()) != null);
    }

    public SatzInterface getSubSatz(FeldDeskriptorInterface arg0) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        logger.debug("getSubSatz {}", (Object)arg0.getFeldNameDSB());
        return null;
    }

    public long getLong(FeldDeskriptorInterface arg0) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        String efnum = arg0.getFeldNameDSB();
        return this.getLongCheck(efnum, Long.parseLong(this.fields.get(arg0.getFeldNameDSB().trim())));
    }

    public int getLaenge(FeldDeskriptorInterface arg0, int[] arg1) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        logger.debug("getLaenge {}", (Object)arg0.getFeldNameDSB());
        return 0;
    }

    public double getDouble(FeldDeskriptorInterface arg0) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        logger.debug("getDouble {}", (Object)arg0.getFeldNameDSB());
        return 0.0;
    }

    public boolean getBool(FeldDeskriptorInterface arg0) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        logger.debug("getBool {}", (Object)arg0.getFeldNameDSB());
        return false;
    }

    public void setString(FeldDeskriptorInterface arg0, String arg1) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        logger.debug("setString: {} f\u00fcr {}", (Object)arg1, (Object)arg0.getFeldNameDSB());
    }

    public void setLong(FeldDeskriptorInterface arg0, long arg1) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        logger.debug("setLong: {} f\u00fcr {}", (Object)arg1, (Object)arg0.getFeldNameDSB());
    }

    public void setLeerWert(FeldDeskriptorInterface arg0) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        logger.debug("setLeerWert ", (Object)arg0.getFeldNameDSB());
    }

    public void setDouble(FeldDeskriptorInterface arg0, double arg1) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        logger.debug("setDouble: ", (Object)arg1);
    }

    public void setBool(FeldDeskriptorInterface arg0, boolean arg1) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        logger.debug("setBool: {}", (Object)arg1);
    }

    public void setData(Map<String, String> data) {
        for (Map.Entry<String, String> entry : data.entrySet()) {
            this.set(StatisticsBase.translateFieldNameToOrig(entry.getKey()), entry.getValue());
        }
    }

    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }

    public List<String> getFieldList() {
        return this.distributionType.fieldSet;
    }
}

