/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.service;

import de.superx.jdbc.entity.Konstante;
import de.superx.jdbc.entity.MaskStatistic;
import de.superx.jdbc.repository.KonstanteRepository;
import de.superx.jdbc.repository.MaskStatisticRepository;
import java.time.LocalDate;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaskStatisticService {
    @Autowired
    MaskStatisticRepository maskStatisticRepository;
    @Autowired
    KonstanteRepository konstanteRepository;

    private boolean isEnabled() {
        Optional<Konstante> optk = this.konstanteRepository.findByBeschreibung("Nutzungsstatistiken");
        if (optk.isPresent()) {
            Konstante k = optk.get();
            return k.apnr == 1;
        }
        return false;
    }

    private void logInDb(Integer tid) {
        MaskStatistic stat;
        Optional<MaskStatistic> optioanlStat = this.maskStatisticRepository.findByTid(tid);
        if (optioanlStat.isPresent()) {
            stat = optioanlStat.get();
            ++stat.counter;
            stat.lastCall = LocalDate.now();
        } else {
            stat = new MaskStatistic();
            stat.tid = tid;
            stat.counter = 1;
            stat.firstCall = LocalDate.now();
            stat.lastCall = LocalDate.now();
        }
        this.maskStatisticRepository.save(stat);
    }

    public void logUsage(Integer tid) {
        if (this.isEnabled()) {
            this.logInDb(tid);
        }
    }
}

