/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.service;

import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.dbt.DbtManager;
import de.superx.etl.biad.DBSource;
import de.superx.etl.biad.SourcesYML;
import de.superx.job.ActionNode;
import de.superx.job.ContainerNode;
import de.superx.job.ExecuteDbtAction;
import de.superx.job.ExecuteSQLFluffAction;
import de.superx.job.ExtractAction;
import de.superx.job.KettleAction;
import de.superx.job.LoadAction;
import de.superx.job.LoadDbtSource;
import de.superx.job.LoadMondrianSchemaAction;
import de.superx.job.RemoveSpringBatchHistoryAction;
import de.superx.job.SqlAction;
import de.superx.job.SqlActionNoSxPool;
import de.superx.job.SqlScriptAction;
import de.superx.job.Timestamp;
import de.superx.job.TransferAction;
import de.superx.job.UnloadAction;
import de.superx.job.UnloadParams;
import de.superx.job.UpdateMetadataAction;
import de.superx.job.UpgradeDbFormsConfigAction;
import de.superx.rest.model.job.Component;
import de.superx.spring.batch.util.MixedSqlScriptParser;
import de.superx.spring.service.JobDescriptionSource;
import de.superx.util.PathAndFileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Service
public class EntityJobDescriptionSource
implements JobDescriptionSource {
    public static final String BIAD_COMPONENT_ABBREVIATION = "biad";
    public static final int SYSTEMINFO_ID_BIAD = 440;
    public static final int SYSTEMINFO_ID_ASTAT = 280;
    public static final int SYSTEMINFO_ID_SOS = 7;
    static Logger logger = LoggerFactory.getLogger(EntityJobDescriptionSource.class);

    @Override
    public List<ContainerNode> readJobs() {
        ArrayList<ContainerNode> jobs = new ArrayList<ContainerNode>();
        for (String componentAbbreviation : PathAndFileUtils.getModules()) {
            jobs.addAll(this.getJobsForComponent(componentAbbreviation));
        }
        return jobs;
    }

    @Override
    public Component getComponentWithLoadAndUnloadDetails(String abbreviation) {
        NodeList unloadJobs;
        Component component = new Component(abbreviation);
        boolean hasLoad = false;
        Document document = PathAndFileUtils.readXml(abbreviation, true);
        if (document != null) {
            NodeList etlSteps = document.getElementsByTagName("etl-step");
            for (int i = 0; i < etlSteps.getLength(); ++i) {
                Node etlStep = etlSteps.item(i);
                String type = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "type");
                if (!type.equals("load")) continue;
                hasLoad = true;
                break;
            }
        }
        boolean hasUnload = false;
        Document unloadXml = PathAndFileUtils.readXml(abbreviation, false);
        if (unloadXml != null && (unloadJobs = unloadXml.getElementsByTagName("unload-job")) != null && unloadJobs.getLength() > 0) {
            hasUnload = true;
        }
        component.setLoad(hasLoad);
        component.setUnload(hasUnload);
        return component;
    }

    @Override
    public ContainerNode getUnloadJob(String componentAbbreviation) {
        if (componentAbbreviation.equals(BIAD_COMPONENT_ABBREVIATION)) {
            ContainerNode root = EntityJobDescriptionSource.createContainerNode(componentAbbreviation.toUpperCase() + " Unload", ContainerNode.JobType.unload.createName(componentAbbreviation), 440);
            File file = new File(PathAndFileUtils.getSourcesYML("hisinone"));
            if (!file.exists()) {
                logger.error("No sources.yml for " + componentAbbreviation);
            } else {
                SourcesYML sourcesYML = SourcesYML.fromJson(file);
                for (DBSource source : sourcesYML.sources) {
                    for (ExtractAction action : source.tables) {
                        root.add(action);
                    }
                }
            }
            return root;
        }
        File xmlFile = PathAndFileUtils.getUnloadXmlFile(componentAbbreviation);
        if (!xmlFile.exists()) {
            logger.warn("No unload.xml for " + componentAbbreviation);
            return null;
        }
        Document unloadXml = null;
        try {
            unloadXml = PathAndFileUtils.readXmlFile(xmlFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String defaultSourcesystem = EntityJobDescriptionSource.getDefaultSourcesystem(unloadXml);
        Integer systemInfoId = Integer.valueOf(EntityJobDescriptionSource.getSystemInfoId(unloadXml));
        ContainerNode root = EntityJobDescriptionSource.createContainerNode(componentAbbreviation.toUpperCase() + " Unload", ContainerNode.JobType.unload.createName(componentAbbreviation), systemInfoId);
        NodeList unloadJobs = unloadXml.getElementsByTagName("unload-job");
        int unloadJobCount = unloadJobs.getLength();
        if (unloadJobCount == 0) {
            return null;
        }
        for (int i = 0; i < unloadJobCount; ++i) {
            Node unloadJob = unloadJobs.item(i);
            root.addAll(this.createUnloadStep(unloadJob, systemInfoId, componentAbbreviation));
        }
        root.getActions().add(0, new UnloadParams(systemInfoId));
        return root;
    }

    public List<ActionNode> createUnloadStep(Node unloadStep, Integer systemInfoId, String componentAbbreviation) {
        ArrayList<ActionNode> result = new ArrayList<ActionNode>();
        String id = PathAndFileUtils.getAttribute(unloadStep.getAttributes(), "id");
        String unloadFile = PathAndFileUtils.getAttribute(unloadStep.getAttributes(), "transfer-unload-file");
        String commentString = null;
        logger.info(id + " (" + !unloadFile.isEmpty() + ")");
        List<Node> sqlNodes = EntityJobDescriptionSource.filterElements(unloadStep.getChildNodes());
        Optional<Node> comment = sqlNodes.stream().filter(node -> node.getNodeName().equalsIgnoreCase("comment") || node.getNodeName().equalsIgnoreCase("description")).findFirst();
        if (comment.isPresent()) {
            commentString = comment.get().getTextContent();
            sqlNodes.remove(comment.get());
        }
        sqlNodes.forEach(sqlNode -> {
            String sourcesystem = PathAndFileUtils.getAttribute(sqlNode.getAttributes(), "sourcesystem");
            String database = PathAndFileUtils.getAttribute(sqlNode.getAttributes(), "database").toLowerCase();
            String sqlvarsourcesystem = PathAndFileUtils.getAttribute(sqlNode.getAttributes(), "sqlVarDatabase").toLowerCase();
            String version = PathAndFileUtils.getAttribute(sqlNode.getAttributes(), "version");
            if (database.isEmpty()) {
                database = "postgres";
            }
            if ("postgres".equals(database)) {
                String sql = sqlNode.getTextContent();
                if (sql.indexOf("<sqlvars>") > -1) {
                    sql = StringUtils.removeSqlVars(sql);
                }
                if (unloadFile.isEmpty()) {
                    result.add(new SqlAction(id, systemInfoId, database, sourcesystem, sqlvarsourcesystem, version, sql));
                } else {
                    result.add(new UnloadAction(id, sql, (String)(unloadFile.startsWith("$") ? unloadFile : "$" + componentAbbreviation.toUpperCase() + "_LOAD_PATH/" + unloadFile), sourcesystem, sqlvarsourcesystem, systemInfoId, version));
                }
            }
        });
        return result;
    }

    @Override
    public ContainerNode getLoadAndTransformJob(String componentAbbreviation) {
        ContainerNode timestampContainer;
        File xmlFile = PathAndFileUtils.getXmlFile(componentAbbreviation);
        Document document = null;
        try {
            document = PathAndFileUtils.readXmlFile(xmlFile);
        }
        catch (IOException e) {
            logger.error("Couldn't read " + xmlFile.getAbsolutePath(), (Throwable)e);
            return null;
        }
        NodeList etlSteps = document.getElementsByTagName("etl-step");
        Integer systemInfoId = Integer.valueOf(EntityJobDescriptionSource.getSystemInfoId(document));
        ContainerNode root = EntityJobDescriptionSource.createContainerNode(componentAbbreviation.toUpperCase() + " Load And Transform", ContainerNode.JobType.load_transform.createName(componentAbbreviation), systemInfoId);
        for (int i = 0; i < etlSteps.getLength(); ++i) {
            Node etlStep = etlSteps.item(i);
            String name = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "name");
            String type = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "type");
            String id = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "id");
            if ("manual".equals(type)) {
                logger.info("etl-step " + name + " type manual. Skipping.");
                continue;
            }
            if (name.isEmpty()) {
                name = type;
            }
            logger.info("etl-step: " + name);
            ContainerNode container = EntityJobDescriptionSource.createContainerNode(name, id, systemInfoId);
            List<ActionNode> stepList = this.createActions(etlStep.getChildNodes(), systemInfoId, componentAbbreviation);
            if (stepList.size() > 0) {
                container.addAll(stepList);
            }
            if (container.name.startsWith("Upload")) {
                container.add(new SqlScriptAction("postgres", systemInfoId, String.format("$%s_PFAD/%s_load_custom.sql", componentAbbreviation.toUpperCase(), componentAbbreviation)));
                container.add(new SqlScriptAction("postgres", systemInfoId, "$" + componentAbbreviation.toUpperCase() + "_PFAD/preparation.sql"));
            }
            if (container.name.startsWith("Transformation")) {
                container.add(new SqlScriptAction("postgres", systemInfoId, String.format("$%s_PFAD/%s_trans_custom.sql", componentAbbreviation.toUpperCase(), componentAbbreviation)));
                container.add(new SqlScriptAction("postgres", systemInfoId, "$" + componentAbbreviation.toUpperCase() + "_PFAD/finalize.sql"));
            }
            if (container.name.startsWith("Aggregation")) {
                container.add(new SqlScriptAction("postgres", systemInfoId, String.format("$%s_PFAD/%s_aggr_custom.sql", componentAbbreviation.toUpperCase(), componentAbbreviation)));
            }
            if (container.getActions().size() <= 0) continue;
            root.add(container);
        }
        int childrenCount = root.size();
        if (childrenCount > 0) {
            timestampContainer = new ContainerNode("Timestamp", "Timestamp", systemInfoId);
            timestampContainer.add(new Timestamp(root.systemInfoId));
            if (root.systemInfoId == 7) {
                timestampContainer.add(new Timestamp(280));
            }
        } else {
            return null;
        }
        root.add(timestampContainer);
        return root;
    }

    @Override
    public ContainerNode getCompleteJob(String componentAbbreviation) {
        ContainerNode loadAndTransform = this.getLoadAndTransformJob(componentAbbreviation);
        ContainerNode unload = this.getUnloadJob(componentAbbreviation);
        if (loadAndTransform == null || unload == null) {
            return null;
        }
        ContainerNode complete = EntityJobDescriptionSource.createContainerNode(componentAbbreviation.toUpperCase() + " Unload, Load And Transform", ContainerNode.JobType.complete.createName(componentAbbreviation), loadAndTransform.systemInfoId);
        complete.add(unload);
        complete.add(loadAndTransform);
        return complete;
    }

    @Override
    public ContainerNode getJobById(String id) {
        ContainerNode root = null;
        String componentAbbreviation = ContainerNode.JobType.getComponentAbbreviationFromJobName(id);
        ContainerNode.JobType type = ContainerNode.JobType.getJobTypeForName(id);
        switch (type) {
            case install_upgrade: {
                root = this.getInstallUpgradeJob(componentAbbreviation);
                break;
            }
            case uninstall: {
                root = this.getUninstallJob(componentAbbreviation);
                break;
            }
            case unload: {
                root = this.getUnloadJob(componentAbbreviation);
                break;
            }
            case load_transform: {
                root = this.getLoadAndTransformJob(componentAbbreviation);
                break;
            }
            case complete: {
                root = this.getCompleteJob(componentAbbreviation);
                break;
            }
            case special: {
                List<ContainerNode> node = this.getSpecialJobs(componentAbbreviation);
                for (ContainerNode containerNode : node) {
                    if (!containerNode.id.equals(id)) continue;
                    root = containerNode;
                }
                break;
            }
            case unknown: {
                break;
            }
            default: {
                root = this.getCompleteJob(id);
            }
        }
        return root;
    }

    @Override
    public List<ContainerNode> getSpecialJobs(String componentAbbreviation) {
        Document modulDoc = null;
        File xmlFile = null;
        try {
            xmlFile = PathAndFileUtils.getXmlFile(componentAbbreviation);
            if (PathAndFileUtils.getUnloadXmlFile(componentAbbreviation).exists()) {
                File xmlUnloadFile = PathAndFileUtils.getUnloadXmlFile(componentAbbreviation);
                modulDoc = XMLUtils.replaceMultipleUnloadJobs(xmlFile, xmlUnloadFile);
            } else {
                modulDoc = PathAndFileUtils.readXmlFile(xmlFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<ContainerNode> result = this.convertToContainers(componentAbbreviation, modulDoc);
        for (ContainerNode ulr : result) {
            ulr.getActions().add(0, new UnloadParams(ulr.systemInfoId));
        }
        return result;
    }

    public List<ContainerNode> convertToContainers(String componentAbbreviation, Document document) {
        ArrayList<ContainerNode> result = new ArrayList<ContainerNode>();
        NodeList etlSteps = document.getElementsByTagName("etl-step");
        Integer systemInfoId = Integer.valueOf(EntityJobDescriptionSource.getSystemInfoId(document));
        int count = etlSteps.getLength();
        for (int i = 0; i < count; ++i) {
            boolean generated;
            Node etlStep = etlSteps.item(i);
            String id = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "id");
            String name = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "name");
            String type = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "type");
            String active = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "active");
            String visible = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "visible");
            String generatedStr = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "generateExecutable");
            boolean bl = generated = generatedStr.isEmpty() || "true".equalsIgnoreCase(generatedStr);
            if (!"manual".equalsIgnoreCase(type) || !"true".equalsIgnoreCase(active) || !"true".equalsIgnoreCase(visible)) continue;
            if (generated) {
                ContainerNode root = EntityJobDescriptionSource.createContainerNode(componentAbbreviation.toUpperCase() + " " + name, ContainerNode.JobType.special.createName(componentAbbreviation, id), systemInfoId);
                List<ActionNode> stepList = this.createActions(etlStep.getChildNodes(), systemInfoId, componentAbbreviation);
                if (stepList.size() > 0) {
                    root.addAll(stepList);
                }
                if (!stepList.get((int)(stepList.size() - 1)).id.contains("_custom")) {
                    root.add(new SqlScriptAction("postgres", systemInfoId, String.format("$%s_PFAD/%s_man_%s_custom.sql", componentAbbreviation.toUpperCase(), componentAbbreviation, id)));
                }
                result.add(root);
                continue;
            }
            File dbiFile = PathAndFileUtils.getDbiFileForManualEtlStep(componentAbbreviation, id, "pg");
            File xslFile = PathAndFileUtils.getXslFile("dbi_ulr.xsl");
            StreamSource xslSource = new StreamSource(xslFile);
            StringWriter writer = new StringWriter();
            try {
                Transformer transformer = TransformerFactory.newDefaultInstance().newTransformer(xslSource);
                transformer.setParameter("id", id);
                transformer.setParameter("name", name);
                transformer.setParameter("systemInfoId", systemInfoId);
                transformer.transform(new StreamSource(dbiFile), new StreamResult(writer));
                String transformedXml = writer.getBuffer().toString();
                DocumentBuilderFactory documentBuilderFactory = XMLUtils.createSecureDocumentBuilderFactory();
                Document doc = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(transformedXml)));
                result.addAll(this.convertToContainers(componentAbbreviation, doc));
                continue;
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public ContainerNode getInstallUpgradeJob(String componentAbbreviation) {
        List<ActionNode> stepList;
        Document document;
        try {
            File xmlFile = PathAndFileUtils.getXmlFile(componentAbbreviation);
            if (!xmlFile.canRead()) {
                return null;
            }
            document = PathAndFileUtils.readXmlFile(xmlFile);
        }
        catch (Exception e) {
            logger.info("Could not get xml file for " + componentAbbreviation + " module. Skipping!");
            return null;
        }
        NodeList installSteps = document.getElementsByTagName("install-upgrade-step");
        int stepCount = installSteps.getLength();
        if (stepCount == 0) {
            logger.warn("No install-upgrade-steps found for component " + componentAbbreviation + " Please check " + componentAbbreviation + ".xml!");
            return null;
        }
        Integer systemInfoId = Integer.valueOf(EntityJobDescriptionSource.getSystemInfoId(document));
        ContainerNode root = EntityJobDescriptionSource.createContainerNode(componentAbbreviation.toUpperCase() + " Install/ Upgrade", ContainerNode.JobType.install_upgrade.createName(componentAbbreviation), systemInfoId);
        ContainerNode upgradeSchema = EntityJobDescriptionSource.createContainerNode(componentAbbreviation.toUpperCase() + " Upgrade DB Schema", componentAbbreviation + "_upgrade_db_schema", systemInfoId);
        ContainerNode updateMetadata = EntityJobDescriptionSource.createContainerNode(componentAbbreviation.toUpperCase() + "Update Module Metadata", componentAbbreviation + "_update_module_metadata", systemInfoId);
        ContainerNode scriptStepsContainer = EntityJobDescriptionSource.createContainerNode(componentAbbreviation.toUpperCase() + " Upgrade-Scripts", componentAbbreviation + "_upgrade_scripts", systemInfoId);
        logger.debug("In module: " + componentAbbreviation + " there were: " + stepCount + " Install/ Upgrade Steps found!");
        ArrayList<ActionNode> scriptSteps = new ArrayList<ActionNode>();
        for (int i = 0; i < stepCount; ++i) {
            Node installStep = installSteps.item(i);
            String name = PathAndFileUtils.getAttribute(installStep.getAttributes(), "name");
            String type = PathAndFileUtils.getAttribute(installStep.getAttributes(), "type");
            String id = PathAndFileUtils.getAttribute(installStep.getAttributes(), "id");
            if ("container".equals(type)) {
                try {
                    ContainerNode container = this.fillInstallUpgradeContainers(componentAbbreviation, name, id, systemInfoId, installStep);
                    if (container.size() == 0) continue;
                    if (container.id.contains("update_module_metadata")) {
                        updateMetadata = container;
                        continue;
                    }
                    root.add(container);
                }
                catch (IOException e) {
                    logger.error("couldn't read install/ upgrade job for module: " + componentAbbreviation);
                    e.printStackTrace();
                }
                continue;
            }
            List<ActionNode> stepList2 = this.createActions(installStep.getChildNodes(), systemInfoId, componentAbbreviation);
            for (ActionNode node : stepList2) {
                if (node.id.endsWith("upgrade_tables_pg.sql") || node.id.endsWith("upgrade_views_pg.sql") || node.id.endsWith("upgrade_fields_pg.sql") || node.id.endsWith("upgrade_indexes_pg.sql") || node.id.endsWith("sx_tables_fuellen.sql")) {
                    upgradeSchema.add(node);
                    continue;
                }
                scriptSteps.add(node);
            }
        }
        if (root.size() == 0) {
            logger.warn("No pre_upgrade container found in install-upgrade-steps for component " + componentAbbreviation + " Please check " + componentAbbreviation + ".xml!");
            return null;
        }
        root.add(1, upgradeSchema);
        scriptStepsContainer.addAll(scriptSteps);
        installSteps = document.getElementsByTagName("upgrade-step");
        if (installSteps.getLength() == 1 && (stepList = this.createActions(installSteps.item(0).getChildNodes(), systemInfoId, componentAbbreviation)).size() > 0) {
            scriptStepsContainer.addAll(stepList);
        }
        scriptStepsContainer.add(new SqlScriptAction("postgres", systemInfoId, String.format("$%s_PFAD/%s_install_custom.sql", componentAbbreviation.toUpperCase(), componentAbbreviation)));
        root.add(scriptStepsContainer);
        updateMetadata.addAll(EntityJobDescriptionSource.additionalInstallActions(componentAbbreviation, systemInfoId));
        root.add(updateMetadata);
        root.add(new UpgradeDbFormsConfigAction(systemInfoId, true, componentAbbreviation));
        root.add(new SqlScriptAction("postgres", systemInfoId, String.format("$%s_PFAD/conf/customize.sql", componentAbbreviation.toUpperCase())));
        root.add(new SqlAction("Update DB version", systemInfoId, "postgres", "eduetl", null, "insert into db_version (his_system, version, version_hash, systeminfo_id) values ('" + componentAbbreviation + "', '${version}', '${version_hash}', " + systemInfoId + ")\non conflict (his_system) do\nupdate set version='${version}', version_hash='${version_hash}'"));
        return stepCount != 0 ? root : null;
    }

    @Override
    public ContainerNode getUninstallJob(String componentAbbreviation) {
        Integer systemInfoId = -1;
        try {
            systemInfoId = Integer.valueOf(PathAndFileUtils.getSystemInfoId(componentAbbreviation));
        }
        catch (Exception e) {
            logger.error("Couldn't get systemInfoId for " + componentAbbreviation, (Throwable)e);
        }
        File uninstallFile = new File(String.format("%s/%s_drop_pg.sql", PathAndFileUtils.getModulePath(componentAbbreviation), componentAbbreviation));
        MixedSqlScriptParser mssp = new MixedSqlScriptParser(uninstallFile, componentAbbreviation, systemInfoId);
        ContainerNode uninstall = mssp.parseScript();
        uninstall.name = componentAbbreviation.toUpperCase() + " Uninstall";
        uninstall.addAll(EntityJobDescriptionSource.additionalInstallActions(componentAbbreviation, systemInfoId));
        return uninstall;
    }

    private static List<ActionNode> additionalInstallActions(String componentAbbreviation, Integer systemInfoId) {
        ArrayList<ActionNode> result = new ArrayList<ActionNode>();
        result.add(new LoadMondrianSchemaAction("load_mondrian_schema", null, systemInfoId, true, (Integer)0, componentAbbreviation));
        return result;
    }

    private ContainerNode fillInstallUpgradeContainers(String componentAbbreviation, String containerName, String containerId, Integer systemInfoId, Node installStep) throws IOException {
        ContainerNode container = EntityJobDescriptionSource.createContainerNode(componentAbbreviation.toUpperCase() + " " + containerName, containerId, systemInfoId);
        if ("pre_upgrade".equals(containerName)) {
            container.addAll(EntityJobDescriptionSource.checkForPreUpgrade(componentAbbreviation, systemInfoId));
        } else if ("install_functions".equals(containerName)) {
            container.addAll(this.installFunctions(componentAbbreviation, systemInfoId));
        } else if ("install_masks".equals(containerName)) {
            container.addAll(this.installMasks(componentAbbreviation, systemInfoId));
        } else if ("Update Module Metadata".equals(containerName)) {
            List<ActionNode> actionNodes = this.metadaten(componentAbbreviation, systemInfoId, installStep);
            container.addAll(actionNodes);
        } else {
            container.addAll(this.createActions(installStep.getChildNodes(), systemInfoId, componentAbbreviation));
        }
        return container;
    }

    private List<ActionNode> metadaten(String componentAbbreviation, Integer systemInfoId, Node installStep) {
        return this.createActions(installStep.getChildNodes(), systemInfoId, componentAbbreviation);
    }

    private List<ActionNode> installMasks(String componentAbbreviation, Integer systemInfoId) throws IOException {
        ArrayList<ActionNode> actions = new ArrayList<ActionNode>();
        File xmlFile = PathAndFileUtils.getXmlFile(componentAbbreviation);
        Document document = PathAndFileUtils.readXmlFile(xmlFile);
        NodeList masks = document.getElementsByTagName("maske");
        int maskCount = masks.getLength();
        for (int i = 0; i < maskCount; ++i) {
            Node mask = masks.item(i);
            String id = PathAndFileUtils.getAttribute(mask.getAttributes(), "tid");
            String name = PathAndFileUtils.getAttribute(mask.getAttributes(), "name");
            String path = null;
            NodeList srcTags = ((Element)mask).getElementsByTagName("src");
            for (int x = 0; x < srcTags.getLength(); ++x) {
                Element e = (Element)srcTags.item(x);
                String pathText = e.getElementsByTagName("path").item(0).getTextContent();
                String dbSystemText = null;
                NodeList dbSystemNode = e.getElementsByTagName("dbsystem");
                if (dbSystemNode.getLength() > 0) {
                    dbSystemText = dbSystemNode.item(0).getTextContent();
                }
                if (dbSystemText != null && !dbSystemText.isBlank() && !"POSTGRES".equals(dbSystemText)) continue;
                path = pathText;
            }
            ContainerNode container = EntityJobDescriptionSource.createContainerNode("Install mask: (" + id + ") " + name, "install_mask_tid_" + id, systemInfoId);
            container.add(new SqlAction("sql_del_maskeninfo_" + id, systemInfoId, "postgres", "eduetl", null, String.format("delete from maskeninfo where tid = %s;", id)));
            container.add(new SqlAction("sql_del_felderinfo_" + id, systemInfoId, "postgres", "eduetl", null, String.format("delete from felderinfo where tid in (select felderinfo_id from masken_felder_bez where maskeninfo_id = %s);", id)));
            container.add(new SqlAction("sql_del_masken_felder_bez_" + id, systemInfoId, "postgres", "eduetl", null, String.format("delete from masken_felder_bez where maskeninfo_id = %s;", id)));
            container.add(new SqlAction("sql_del_sachgeb_maske_bez_" + id, systemInfoId, "postgres", "eduetl", null, String.format("delete from sachgeb_maske_bez where maskeninfo_id = %s;", id)));
            container.add(new SqlAction("sql_del_maske_sys_bez_" + id, systemInfoId, "postgres", "eduetl", null, String.format("delete from maske_system_bez where maskeninfo_id = %s;", id)));
            String filePath = path + "/" + id + "_";
            container.add(new LoadAction(systemInfoId, false, "^", false, "eduetl", "maskeninfo", filePath + "maskeninfo.unl"));
            container.add(new LoadAction(systemInfoId, false, "^", false, "eduetl", "felderinfo", filePath + "felderinfo.unl"));
            container.add(new LoadAction(systemInfoId, false, "^", false, "eduetl", "masken_felder_bez", filePath + "masken_felder_bez.unl"));
            container.add(new LoadAction(systemInfoId, false, "^", false, "eduetl", "sachgeb_maske_bez", filePath + "sachgeb_maske_bez.unl"));
            container.add(new LoadAction(systemInfoId, false, "^", false, "eduetl", "maske_system_bez", filePath + "maske_system_bez.unl"));
            actions.add(container);
        }
        return actions;
    }

    private static ContainerNode createContainerNode(String name, String id, Integer systemInfoId) {
        ContainerNode node = new ContainerNode(name, id, systemInfoId);
        node.setJobSource(ContainerNode.JobSource.FILE);
        return node;
    }

    private List<ActionNode> installFunctions(String componentAbbreviation, Integer systemInfoId) throws IOException {
        File xmlFile = PathAndFileUtils.getXmlFile(componentAbbreviation);
        Document document = PathAndFileUtils.readXmlFile(xmlFile);
        ArrayList<ActionNode> functionActions = new ArrayList<ActionNode>();
        NodeList functions = document.getElementsByTagName("function");
        int functionsCount = functions.getLength();
        for (int i = 0; i < functionsCount; ++i) {
            Element function = (Element)functions.item(i);
            NodeList srcTags = function.getElementsByTagName("src");
            int srcTagsCount = srcTags.getLength();
            for (int k = 0; k < srcTagsCount; ++k) {
                Element src = (Element)srcTags.item(k);
                NodeList file = src.getElementsByTagName("file");
                NodeList body = src.getElementsByTagName("body");
                String dbsystem = src.getElementsByTagName("dbsystem").item(0).getTextContent();
                if (file.getLength() > 0) {
                    functionActions.add(EntityJobDescriptionSource.installFunctionFileTag(file, dbsystem, systemInfoId));
                    continue;
                }
                if (body.getLength() <= 0) continue;
                functionActions.add(EntityJobDescriptionSource.installFunctionBodyTag(body, dbsystem, systemInfoId));
            }
        }
        return functionActions;
    }

    private static ActionNode installFunctionBodyTag(NodeList body, String dbsystem, Integer systemInfoId) {
        Node cdata = body.item(0).getFirstChild();
        if (cdata instanceof CharacterData) {
            CharacterData cd = (CharacterData)cdata;
            return new SqlAction(cd.getData().toLowerCase().substring(0, 10).replace(" ", "_") + "_function_from_" + systemInfoId.toString(), systemInfoId, dbsystem, "eduetl", null, cd.getData());
        }
        return null;
    }

    private static ActionNode installFunctionFileTag(NodeList file, String dbsystem, Integer systemInfoId) {
        String f = file.item(0).getTextContent();
        if (dbsystem.equals("INFORMIX")) {
            return new SqlScriptAction("informix", systemInfoId, f);
        }
        return new SqlScriptAction("postgres", systemInfoId, f);
    }

    private static List<ActionNode> checkForPreUpgrade(String componentAbbreviation, Integer systemInfoId) throws IOException {
        ArrayList<ActionNode> actions = new ArrayList<ActionNode>();
        String moduleUpgradeDirPath = PathAndFileUtils.getModulePath(componentAbbreviation) + "/upgrade";
        File moduleUpgradeDir = new File(moduleUpgradeDirPath);
        File[] preUpgradeFiles = moduleUpgradeDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String filename = name.strip().toLowerCase();
                return filename.contains("pre_upgrade_pg") && filename.endsWith("sql") && !filename.contains("tmp");
            }
        });
        for (int i = 0; i < preUpgradeFiles.length; ++i) {
            actions.add(new SqlScriptAction("postgres", systemInfoId, String.format("$%s_PFAD/upgrade/%s", componentAbbreviation.toUpperCase(), preUpgradeFiles[i].getName())));
        }
        return actions;
    }

    private List<ActionNode> createActions(NodeList steps, Integer systemInfoId, String componentAbbreviation) {
        ArrayList<ActionNode> result = new ArrayList<ActionNode>();
        List<Node> actionNodes = EntityJobDescriptionSource.filterElements(steps);
        actionNodes.forEach(node -> {
            logger.info("action :");
            List<Node> actions = EntityJobDescriptionSource.filterElements(node.getChildNodes());
            for (Node action : actions) {
                String name = action.getNodeName();
                NamedNodeMap attributes = action.getAttributes();
                if ("nativeaction".equals(name)) {
                    ActionNode actionStep;
                    String database = PathAndFileUtils.getAttribute(attributes, "database");
                    String container = PathAndFileUtils.getAttribute(attributes, "container");
                    if (!database.isEmpty() && !"postgres".equals(database.toLowerCase()) || (actionStep = this.createActionStep(attributes, systemInfoId)) == null) continue;
                    if (container != null && container.equalsIgnoreCase("true")) {
                        ContainerNode containerNode = EntityJobDescriptionSource.createContainerNode(name + " Container", actionStep.id + "_container", systemInfoId);
                        containerNode.add(actionStep);
                        result.add(containerNode);
                        continue;
                    }
                    result.add(actionStep);
                    continue;
                }
                if ("loadtable".equals(name)) {
                    ActionNode loadStep = this.createLoadStep(action, attributes, systemInfoId);
                    result.add(loadStep);
                    continue;
                }
                if ("transferTable".equals(name)) {
                    ActionNode transferStep = this.createTransferStep(attributes, systemInfoId);
                    result.add(transferStep);
                    continue;
                }
                if ("kettle-job-embedded".equals(name)) {
                    ActionNode kettleStep = this.createKettleStep(attributes, systemInfoId);
                    result.add(kettleStep);
                    continue;
                }
                if ("unload-job".equals(name)) {
                    result.addAll(this.createUnloadStep(action, systemInfoId, componentAbbreviation));
                    continue;
                }
                if ("execute-unload-scripts".equals(name)) {
                    result.addAll(this.createLoadAfterExtract(componentAbbreviation, systemInfoId));
                    continue;
                }
                if ("evaluate-dbt-json".equals(name)) {
                    result.addAll(this.createDbtExecutionStep(attributes, systemInfoId));
                    result.add(EntityJobDescriptionSource.createMetaimportJsonStep(attributes, systemInfoId));
                    continue;
                }
                if ("evaluate-metadata".equals(name)) {
                    result.add(EntityJobDescriptionSource.createMetaimportJsonStep(attributes, systemInfoId));
                    continue;
                }
                if ("evaluate-dbt-test".equals(name)) {
                    result.addAll(this.createDbtTestStep(attributes, systemInfoId));
                    continue;
                }
                if ("remove-spring-batch-history".equals(name)) {
                    result.add(new RemoveSpringBatchHistoryAction(systemInfoId));
                    continue;
                }
                if ("loadtableinfo".equals(name)) continue;
                logger.error("Unknown action type: " + name);
            }
        });
        return result;
    }

    private List<ActionNode> createDbtTestStep(NamedNodeMap attributes, Integer systemInfoId) {
        ArrayList<ActionNode> nodes = new ArrayList<ActionNode>();
        String dbtProject = PathAndFileUtils.getAttribute(attributes, "project");
        String dbtSelect = PathAndFileUtils.getAttribute(attributes, "select");
        nodes.add(new ExecuteDbtAction(dbtProject, dbtSelect, systemInfoId, true));
        nodes.add(new ExecuteSQLFluffAction("Lint DBT Models using SQLFluff", "sqlfluff_action", (Integer)440, true, 0));
        return nodes;
    }

    private List<ActionNode> createDbtExecutionStep(NamedNodeMap attributes, Integer systemInfoId) {
        ArrayList<ActionNode> nodes = new ArrayList<ActionNode>();
        String dbtProject = PathAndFileUtils.getAttribute(attributes, "project");
        String dbtSelect = PathAndFileUtils.getAttribute(attributes, "select");
        if (dbtSelect != null && !dbtSelect.isBlank()) {
            String id = PathAndFileUtils.getAttribute(attributes, "id");
            ContainerNode extractLoad = EntityJobDescriptionSource.createContainerNode("Extract and Load", "extract_load_" + id, systemInfoId);
            List<String> stagingTables = DbtManager.getStagingTables(dbtSelect);
            if (stagingTables != null && !stagingTables.isEmpty()) {
                extractLoad.addAll(EntityJobDescriptionSource.createExtractAndLoadStep(stagingTables, systemInfoId));
                nodes.add(extractLoad);
            }
        }
        nodes.add(new ExecuteDbtAction(dbtProject, dbtSelect, systemInfoId));
        return nodes;
    }

    private static ActionNode createMetaimportJsonStep(NamedNodeMap attributes, Integer systemInfoId) {
        String dbtProject = PathAndFileUtils.getAttribute(attributes, "project");
        return new UpdateMetadataAction(dbtProject, systemInfoId);
    }

    private static List<ActionNode> createExtractAndLoadStep(List<String> tables, Integer systemInfoId) {
        ArrayList<ActionNode> result = new ArrayList<ActionNode>();
        SourcesYML sourcesYML = SourcesYML.fromJson(new File(PathAndFileUtils.getSourcesYML("hisinone")));
        for (DBSource source : sourcesYML.sources) {
            for (ExtractAction action : source.tables) {
                if (!tables.contains(action.sourceTable)) continue;
                result.add(action);
                result.add(new LoadDbtSource("postgres", systemInfoId, action.unlFile));
                logger.info("\tloadtable: tabname=" + action.sourceTable + " path=" + action.unlFile);
            }
        }
        return result;
    }

    private List<ActionNode> createLoadAfterExtract(String componentAbbreviation, Integer systemInfoId) {
        ArrayList<ActionNode> result = new ArrayList<ActionNode>();
        SourcesYML sourcesYML = SourcesYML.fromJson(new File(PathAndFileUtils.getSourcesYML("hisinone")));
        for (DBSource source : sourcesYML.sources) {
            for (ExtractAction action : source.tables) {
                result.add(new LoadDbtSource("postgres", systemInfoId, action.unlFile));
                logger.info("\tloadtable: tabname=" + action.sourceTable + " path=" + action.unlFile);
            }
        }
        return result;
    }

    private ActionNode createKettleStep(NamedNodeMap attributes, Integer systemInfoId) {
        String name = PathAndFileUtils.getAttribute(attributes, "name");
        String file = PathAndFileUtils.getAttribute(attributes, "file");
        logger.info("\tcreating kettle job " + name + " in path " + file);
        KettleAction kettleAction = new KettleAction(name, systemInfoId, file);
        return kettleAction;
    }

    private ActionNode createTransferStep(NamedNodeMap attributes, Integer systemInfoId) {
        String fromTable = PathAndFileUtils.getAttribute(attributes, "src");
        String toTable = PathAndFileUtils.getAttribute(attributes, "target");
        logger.info("\ttransfer table " + fromTable + " to " + toTable);
        TransferAction transferAction = new TransferAction(systemInfoId, fromTable, toTable);
        return transferAction;
    }

    private ActionNode createLoadStep(Node action, NamedNodeMap attributes, Integer systemInfoId) {
        String refresh = PathAndFileUtils.getAttribute(attributes, "refresh");
        String checkEmpty = PathAndFileUtils.getAttribute(attributes, "checkEmpty");
        String tabName = PathAndFileUtils.getAttribute(attributes, "tabname");
        String delimiter = PathAndFileUtils.getAttribute(attributes, "delimiter");
        String header = PathAndFileUtils.getAttribute(attributes, "header");
        String database = PathAndFileUtils.getAttribute(attributes, "database");
        Node fileNode = EntityJobDescriptionSource.filterElements(action.getChildNodes()).get(0);
        String unloadFileAttribute = PathAndFileUtils.getAttribute(fileNode.getAttributes(), "path");
        logger.info("\tloadtable: tabname=" + tabName + " path=" + unloadFileAttribute);
        LoadAction loadAction = new LoadAction(systemInfoId, Boolean.parseBoolean(refresh), delimiter, Boolean.parseBoolean(header), database.isEmpty() ? "eduetl" : database, tabName, unloadFileAttribute);
        if (!checkEmpty.isEmpty()) {
            loadAction.checkEmpty = Boolean.parseBoolean(checkEmpty);
        }
        return loadAction;
    }

    private ActionNode createActionStep(NamedNodeMap attributes, Integer systemInfoId) {
        String sqlVardataSource;
        ActionNode step = null;
        String sql = PathAndFileUtils.getAttribute(attributes, "sql");
        String scriptfile = PathAndFileUtils.getAttribute(attributes, "scriptfile");
        String dataSource = PathAndFileUtils.getAttribute(attributes, "dataSource");
        if (dataSource.isEmpty()) {
            dataSource = "eduetl";
        }
        if ((sqlVardataSource = PathAndFileUtils.getAttribute(attributes, "sqlVarDatabase")).isEmpty()) {
            sqlVardataSource = "eduetl";
        }
        if (!sql.isEmpty()) {
            logger.info("\tnativeaction: " + sql);
            String[] parts = sql.split(":", 2);
            String database = "eduetl";
            if (parts.length == 2) {
                database = parts[0];
                sql = parts[1].trim();
            } else if (parts.length != 1) {
                logger.error("Expecting format '<database>:<sql-code> or '<sql-code>', but got '" + sql + "'");
                return null;
            }
            if (sql.indexOf("<sqlvars>") > -1) {
                sql = StringUtils.removeSqlVars(sql);
            }
            step = new SqlAction(null, systemInfoId, "postgres", database, null, sql);
        } else {
            logger.info("\tnativeaction: file=" + scriptfile);
            step = new SqlScriptAction("postgres", dataSource, sqlVardataSource, systemInfoId, scriptfile);
        }
        return step;
    }

    private static String getDefaultSourcesystem(Document unloadXml) {
        String result = "hisinone";
        NodeList sourcesystems = unloadXml.getElementsByTagName("sourcesystem");
        int count = sourcesystems.getLength();
        for (int i = 0; i < count; ++i) {
            Node sourcesystem = sourcesystems.item(i);
            String def = PathAndFileUtils.getAttribute(sourcesystem.getAttributes(), "default");
            if (def.isEmpty()) continue;
            result = PathAndFileUtils.getAttribute(sourcesystem.getAttributes(), "name");
            break;
        }
        return result;
    }

    private static String getSystemInfoId(Document xml) {
        NodeList modules = xml.getElementsByTagName("module");
        if (modules.getLength() == 0) {
            return "-1";
        }
        Node module = modules.item(0);
        return PathAndFileUtils.getAttribute(module.getAttributes(), "systeminfo_id");
    }

    public static List<Node> filterElements(NodeList nodeList) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        int count = nodeList.getLength();
        for (int i = 0; i < count; ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            nodes.add(nodeList.item(i));
        }
        return nodes;
    }

    @Override
    public List<ContainerNode> readInstallJobs(List<String> components) {
        logger.debug("Reading install jobs from file system");
        ArrayList<ContainerNode> jobs = new ArrayList<ContainerNode>();
        for (String componentAbbreviation : PathAndFileUtils.getModules()) {
            jobs.add(this.getInstallUpgradeJob(componentAbbreviation));
        }
        logger.debug("Count of jobs: " + jobs.size());
        return jobs;
    }

    public static ContainerNode getPreKernInstallJob() {
        ContainerNode root = EntityJobDescriptionSource.createContainerNode("kern_pre_install", "kern_pre_install", 9);
        List<String> tables = Arrays.asList("db_version", "xdummy", "hochschulinfo", "konstanten", "userinfo", "groupinfo", "aggregierung", "user_group_bez", "db_tabellen", "sx_repository", "fm_templates", "sichten", "orgunit_mapping", "sx_captions", "macro_feld_wert", "graphicformat", "dbconnections", "themenbaum");
        for (String table : tables) {
            String unlFile = "$SUPERX_DIR/db/install/schluesseltabellen/release_unloads/" + table + ".unl";
            String tabFile = "$SUPERX_DIR/db/install/conf/his1_cli/dbconv/sch.eduetl/" + table + ".tab";
            SqlActionNoSxPool action = new SqlActionNoSxPool(tabFile, "eduetl", 9);
            root.add(action);
            LoadAction loadAction = new LoadAction(9, false, "^", false, "eduetl", table, unlFile);
            root.add(loadAction);
        }
        return root;
    }

    @Override
    public List<ContainerNode> getJobsForComponent(String componentAbbreviation) {
        ContainerNode rootComplete;
        ContainerNode root;
        ArrayList<ContainerNode> jobs = new ArrayList<ContainerNode>();
        ContainerNode installUpgrade = this.getInstallUpgradeJob(componentAbbreviation);
        if (installUpgrade != null) {
            jobs.add(installUpgrade);
            ContainerNode uninstallJob = this.getUninstallJob(componentAbbreviation);
            if (uninstallJob != null) {
                jobs.add(uninstallJob);
            }
        }
        if ((root = this.getLoadAndTransformJob(componentAbbreviation)) != null) {
            jobs.add(root);
        }
        List<ContainerNode> ulrs = this.getSpecialJobs(componentAbbreviation);
        for (ContainerNode ulr : ulrs) {
            jobs.add(ulr);
        }
        ContainerNode rootUnl = this.getUnloadJob(componentAbbreviation);
        if (rootUnl != null) {
            jobs.add(rootUnl);
        }
        if ((rootComplete = this.getCompleteJob(componentAbbreviation)) != null) {
            jobs.add(rootComplete);
        }
        return jobs;
    }

    @Override
    public List<ContainerNode> getSpecialJobsOverview(String abbreviation) {
        ArrayList<ContainerNode> result = new ArrayList<ContainerNode>();
        Document modulDoc = null;
        File xmlFile = null;
        try {
            xmlFile = PathAndFileUtils.getXmlFile(abbreviation);
            if (PathAndFileUtils.getUnloadXmlFile(abbreviation).exists()) {
                File xmlUnloadFile = PathAndFileUtils.getUnloadXmlFile(abbreviation);
                modulDoc = XMLUtils.replaceMultipleUnloadJobs(xmlFile, xmlUnloadFile);
            } else {
                modulDoc = PathAndFileUtils.readXmlFile(xmlFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (modulDoc == null) {
            logger.error("Could not get SpecialJob Overview for module " + abbreviation);
            return result;
        }
        NodeList etlSteps = modulDoc.getElementsByTagName("etl-step");
        Integer systemInfoId = Integer.valueOf(EntityJobDescriptionSource.getSystemInfoId(modulDoc));
        int count = etlSteps.getLength();
        for (int i = 0; i < count; ++i) {
            Node etlStep = etlSteps.item(i);
            String id = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "id");
            String name = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "name");
            String type = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "type");
            String active = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "active");
            String visible = PathAndFileUtils.getAttribute(etlStep.getAttributes(), "visible");
            if (!"manual".equalsIgnoreCase(type) || !"true".equalsIgnoreCase(active) || !"true".equalsIgnoreCase(visible)) continue;
            ContainerNode root = EntityJobDescriptionSource.createContainerNode(name, ContainerNode.JobType.special.createName(abbreviation, id), systemInfoId);
            result.add(root);
        }
        return result;
    }
}

