/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.config;

import de.superx.bianalysis.metadata.Identifier;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.jdbc.repository.config.AbstractJdbcConfiguration;
import org.springframework.data.jdbc.repository.config.EnableJdbcRepositories;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.PostgresDialect;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJdbcRepositories(basePackages={"de.superx.jdbc.repository", "de.superx.bianalysis.repository"})
public class DataJdbcConfiguration
extends AbstractJdbcConfiguration {
    @Autowired
    DataSource dataSource;

    @Bean
    NamedParameterJdbcOperations operations() {
        return new NamedParameterJdbcTemplate(this.dataSource);
    }

    @Bean
    PlatformTransactionManager transactionManager() {
        return new DataSourceTransactionManager(this.dataSource);
    }

    @Bean
    public Dialect jdbcDialect(NamedParameterJdbcOperations operations) {
        return PostgresDialect.INSTANCE;
    }

    public List<?> userConverters() {
        return Arrays.asList(new BooleanToIntegerConverter(), new IntegerToBooleanConverter(), new IdentifierToString(), new StringToIdentifier());
    }

    @WritingConverter
    public class BooleanToIntegerConverter
    implements Converter<Boolean, Integer> {
        public Integer convert(Boolean source) {
            if (source.booleanValue()) {
                return 1;
            }
            return 0;
        }
    }

    @ReadingConverter
    public class IntegerToBooleanConverter
    implements Converter<Integer, Boolean> {
        public Boolean convert(Integer source) {
            if (source.equals(1)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    @WritingConverter
    public class IdentifierToString
    implements Converter<Identifier, String> {
        public String convert(Identifier id) {
            return id.composedId;
        }
    }

    @ReadingConverter
    public class StringToIdentifier
    implements Converter<String, Identifier> {
        public Identifier convert(String source) {
            return new Identifier(source);
        }
    }
}

