/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.config;

import com.zaxxer.hikari.HikariDataSource;
import de.superx.spring.HIS1Databases;
import de.superx.spring.batch.His1DataSources;
import de.superx.spring.batch.job.JobUtils;
import de.superx.spring.batch.tasklet.RemoveSpringBatchHistoryTasklet;
import de.superx.util.PathAndFileUtils;
import java.io.File;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.ListableJobLocator;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.support.SimpleJobOperator;
import org.springframework.batch.core.launch.support.TaskExecutorJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableBatchProcessing
@PropertySources(value={@PropertySource(value={"classpath:spring-batch.properties"}), @PropertySource(value={"classpath:hikari.properties"})})
@ComponentScan(basePackages={"de.superx.spring.service", "de.superx.spring.batch.tasklet", "de.superx.rest", "de.superx.bianalysis.service", "de.superx.bianalysis.rest"})
public class BatchConfig {
    @Value(value="${hikari.connection_timeout:180000}")
    protected Long connectionTimeout;
    @Value(value="${hikari.leak_detection_threshold:0}")
    protected Long leakDetectionThreshold;
    public static final int DEFAULT_POOL_SIZE = 5;
    public static final int EDUETL_POOL_SIZE = 20;
    private static Logger logger = Logger.getLogger(BatchConfig.class);
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private JobRegistry jobRegistry;
    @Autowired
    private JobExplorer jobExplorer;

    @Bean
    public PlatformTransactionManager transactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    public JobLauncher jobLauncher() throws Exception {
        TaskExecutorJobLauncher jobLauncher = new TaskExecutorJobLauncher();
        jobLauncher.setJobRepository(this.jobRepository);
        jobLauncher.setTaskExecutor((TaskExecutor)new SimpleAsyncTaskExecutor());
        jobLauncher.afterPropertiesSet();
        return jobLauncher;
    }

    @Bean
    public JobLocator jobLocator() {
        return this.jobRegistry;
    }

    @Bean
    public JobLauncher syncJobLauncher() throws Exception {
        TaskExecutorJobLauncher jobLauncher = new TaskExecutorJobLauncher();
        jobLauncher.setJobRepository(this.jobRepository);
        jobLauncher.afterPropertiesSet();
        return jobLauncher;
    }

    @Bean
    public JobOperator jobOperator() throws Exception {
        SimpleJobOperator jobOperator = new SimpleJobOperator();
        jobOperator.setJobLauncher(this.jobLauncher());
        jobOperator.setJobExplorer(this.jobExplorer);
        jobOperator.setJobRepository(this.jobRepository);
        jobOperator.setJobRegistry((ListableJobLocator)this.jobRegistry);
        JobUtils.terminateAllJobExecutions(this.jobExplorer, (JobOperator)jobOperator);
        return jobOperator;
    }

    @Bean
    public His1DataSources dataSources() {
        HashMap<String, HikariDataSource> dataSources = new HashMap<String, HikariDataSource>();
        try {
            for (Map.Entry<String, Map<String, String>> co : HIS1Databases.getValidConnections().entrySet()) {
                dataSources.put(co.getKey().toString(), HIS1Databases.convertConnection(co.getKey().toString(), co.getValue(), this.leakDetectionThreshold, this.connectionTimeout));
                logger.info((Object)String.format("Connection to %s added to dataSources bean", co.getKey()));
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.fatal((Object)e);
            e.printStackTrace();
        }
        return new His1DataSources(dataSources);
    }

    @Bean
    public DataSource dataSource() {
        HikariDataSource ds = (HikariDataSource)this.dataSources().get("eduetl");
        if (!BatchConfig.batchSchemaExists((DataSource)ds)) {
            BatchConfig.dropBatchSchema((DataSource)ds);
            BatchConfig.createBatchSchema((DataSource)ds);
        }
        BatchConfig.upgradeBatchSchema((DataSource)ds);
        if (!BatchConfig.quartzSchemaExists((DataSource)ds)) {
            BatchConfig.createQuartzSchema((DataSource)ds);
        }
        return ds;
    }

    @Bean
    public Step removeStep(PlatformTransactionManager transactionManager, DataSource dataSource) {
        RemoveSpringBatchHistoryTasklet tasklet = new RemoveSpringBatchHistoryTasklet();
        tasklet.setJdbcTemplate(new JdbcTemplate(dataSource));
        String name = "removeStep";
        return new StepBuilder(name, this.jobRepository).tasklet((Tasklet)tasklet, transactionManager).build();
    }

    @Bean
    public Job removeSpringBatchHistoryJob(Step removeStep) {
        return new JobBuilder("removeSpringBatchHistoryJob", this.jobRepository).start(removeStep).build();
    }

    private static boolean batchSchemaExists(DataSource dataSource) {
        int count = 0;
        try (Connection con = dataSource.getConnection();){
            DatabaseMetaData meta = con.getMetaData();
            ResultSet resultSet = meta.getTables(null, "public", "batch_%", new String[]{"TABLE"});
            while (resultSet.next()) {
                ++count;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't check for spring batch tables", e);
        }
        return count == 6;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean quartzSchemaExists(DataSource dataSource) {
        try (Connection con = dataSource.getConnection();){
            DatabaseMetaData meta = con.getMetaData();
            ResultSet resultSet = meta.getTables(null, "public", "qrtz_%", new String[]{"TABLE"});
            if (!resultSet.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't check for spring batch tables", e);
        }
    }

    private static void createBatchSchema(DataSource dataSource) {
        try (Connection con = dataSource.getConnection();){
            ScriptUtils.executeSqlScript((Connection)con, (Resource)new ClassPathResource("/org/springframework/batch/core/schema-postgresql.sql"));
            logger.info((Object)"Spring Batch schema created;");
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't create Spring Batch schema!", (Throwable)e);
        }
    }

    private static void dropBatchSchema(DataSource dataSource) {
        try (Connection con = dataSource.getConnection();){
            ScriptUtils.executeSqlScript((Connection)con, (Resource)new ClassPathResource("/org/springframework/batch/core/schema-drop-postgresql.sql"));
            logger.info((Object)"Spring Batch schema dropped;");
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't drop Spring Batch schema!", (Throwable)e);
        }
    }

    private static void createQuartzSchema(DataSource dataSource) {
        try (Connection con = dataSource.getConnection();){
            ScriptUtils.executeSqlScript((Connection)con, (Resource)new ClassPathResource("/org/quartz/impl/jdbcjobstore/tables_postgres.sql"));
            logger.info((Object)"Quartz schema created;");
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't create Quartz schema!", (Throwable)e);
        }
    }

    public static void upgradeBatchSchema(DataSource dataSource) {
        try (Connection con = dataSource.getConnection();){
            File file = new File(String.format("%s/conf/edustore/db/install/upgrade/spring_batch_schema_upgrade.sql", PathAndFileUtils.getWebinfPath()));
            ScriptUtils.executeSqlScript((Connection)con, (Resource)new FileSystemResource(file));
            logger.info((Object)"Spring Batch schema upgraded;");
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't upgrade Spring Batch schema!", (Throwable)e);
        }
    }
}

