/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.writer;

import java.util.ArrayList;
import java.util.Arrays;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.jdbc.core.JdbcTemplate;

public class LoadDbtSourceItemWriter
implements ItemWriter<String> {
    private DataSource dataSource;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public LoadDbtSourceItemWriter(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void write(Chunk<? extends String> sqlStatements) throws Exception {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        ArrayList list = new ArrayList();
        sqlStatements.forEach(list::add);
        String[] insertStatements = list.toArray(new String[0]);
        String firstStatement = insertStatements[0];
        if (firstStatement.startsWith("DROP")) {
            jt.execute(firstStatement);
            this.logger.debug("CREATE TABLE: " + firstStatement);
            insertStatements = Arrays.copyOfRange(insertStatements, 1, insertStatements.length);
        }
        if (insertStatements.length > 0) {
            jt.batchUpdate(insertStatements);
        }
    }
}

