/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.tasklet;

import de.superx.rest.JobParamKonstanten;
import de.superx.spring.batch.job.JobUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public class RemoveSpringBatchHistoryTasklet
implements Tasklet,
InitializingBean {
    private static final String DEFAULT_TABLE_PREFIX = "BATCH_";
    private static final Long DEFAULT_RETENTION_DAYS = 10L;
    private String tablePrefix = "BATCH_";
    private Long historicRetentionDays = DEFAULT_RETENTION_DAYS;
    private JdbcTemplate jdbcTemplate;
    private static final Logger LOG = LoggerFactory.getLogger(RemoveSpringBatchHistoryTasklet.class);

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) {
        JobParameters params = contribution.getStepExecution().getJobParameters();
        Long job_protocol_period_param = params.getLong(JobParamKonstanten.JOB_PROTOCOL_PERIOD.name());
        this.historicRetentionDays = job_protocol_period_param != null ? job_protocol_period_param : this.historicRetentionDays;
        int totalCount = JobUtils.deleteJobHistoryOlderThanDays(this.historicRetentionDays.intValue(), this.jdbcTemplate, this.tablePrefix);
        contribution.incrementWriteCount((long)totalCount);
        return RepeatStatus.FINISHED;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setHistoricRetentionMonth(Long historicRetentionDays) {
        this.historicRetentionDays = historicRetentionDays;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jdbcTemplate, (String)"The jdbcTemplate must not be null");
    }
}

