/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.tasklet;

import com.zaxxer.hikari.HikariDataSource;
import de.superx.rest.JobParamKonstanten;
import de.superx.spring.batch.tasklet.CommonSqlTasklet;
import de.superx.spring.batch.util.SuperxScriptUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;

public class ExecuteSqlScriptTasklet
extends CommonSqlTasklet
implements Tasklet {
    private static final Pattern COMMENT_LINE_SQL = Pattern.compile("^\\s*(--|!).*", 8);
    Logger log = LoggerFactory.getLogger(this.getClass());
    private Resource sqlScript;
    private boolean continueOnError = true;
    private List<Throwable> errors = new ArrayList<Throwable>();
    private int limitDebugStmts = -1;

    public ExecuteSqlScriptTasklet(Resource script, DataSource dataSource, DataSource sqlVarDataSource, boolean continueOnError) {
        this.sqlScript = script;
        this.dataSource = dataSource;
        this.continueOnError = continueOnError;
        this.sqlVarDataSource = sqlVarDataSource;
    }

    public ExecuteSqlScriptTasklet(Resource script, DataSource dataSource, DataSource sqlVarDataSource) {
        this(script, dataSource, sqlVarDataSource, true);
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        super.beforeStep(stepExecution);
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        return super.afterStep(stepExecution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        if (!this.sqlScript.exists()) {
            this.log.warn("SQL-Script wurde nicht gefunden: " + this.sqlScript.getFilename());
        } else {
            Connection con = null;
            try {
                con = this.dataSource.getConnection();
                EncodedResource sql = this.loadSqlScriptAndParseWithFreemarkerIfNecessary();
                if (sql != null) {
                    JobParameters params = contribution.getStepExecution().getJobParameters();
                    Long work_mem_param = params.getLong(JobParamKonstanten.JOBS_SQL_SCRIPT_WORK_MEM.name());
                    int work_mem = work_mem_param != null ? work_mem_param.intValue() : 0;
                    this.setWorkMem(con, work_mem);
                    this.errors = SuperxScriptUtils.executeSqlScript(con, sql, this.continueOnError, this.continueOnError, this.limitDebugStmts);
                } else {
                    this.log.warn("Empty sql script: " + this.sqlScript.getFilename());
                }
            }
            catch (Exception e) {
                this.log.error("Error executing script file " + this.sqlScript);
                if (con != null) {
                    ((HikariDataSource)this.dataSource).evictConnection(con);
                }
                this.errors.add(e);
            }
            finally {
                this.resetWorkMem(con);
                if (con != null) {
                    con.close();
                }
            }
        }
        if (this.errors.size() > 0) {
            ExitStatus exitStatus = ExitStatus.FAILED;
            for (Throwable error : this.errors) {
                String errorMsg = error.getMessage();
                int endIndex = errorMsg.length();
                endIndex = errorMsg.contains("Position:") ? errorMsg.indexOf("Position:") : endIndex;
                exitStatus = exitStatus.addExitDescription(errorMsg.substring(0, endIndex));
            }
            contribution.setExitStatus(exitStatus);
        }
        return RepeatStatus.FINISHED;
    }

    private EncodedResource loadSqlScriptAndParseWithFreemarkerIfNecessary() {
        String sql = "";
        try {
            File file = this.sqlScript.getFile();
            sql = FileUtils.readFileToString((File)file, (Charset)Charsets.UTF_8);
            sql = this.checkFreemarker(sql);
            this.keepGeneratedIfNecessary(sql);
        }
        catch (Exception e) {
            this.log.error("Unable to load sql skript " + this.sqlScript, (Throwable)e);
            throw new RuntimeException(e);
        }
        sql = ExecuteSqlScriptTasklet.deleteAllCommentLines(sql);
        sql = sql.replaceAll("(?m)^[ \t]*\r?\n", "");
        if (sql.isEmpty() || !SuperxScriptUtils.containsSqlScriptDelimiters(sql, ";")) {
            return null;
        }
        return new EncodedResource((Resource)new ByteArrayResource(sql.getBytes(Charsets.UTF_8)), Charsets.UTF_8);
    }

    private void keepGeneratedIfNecessary(String sqlContent) {
        String keep = System.getProperty("FreemarkerKeepGenerated");
        if (keep != null && keep.equalsIgnoreCase("true")) {
            try {
                String path = this.sqlScript.getFile().getAbsolutePath();
                File freemarkerFile = new File(path + ".tmp.sql");
                Files.writeString(freemarkerFile.toPath(), (CharSequence)sqlContent, new OpenOption[0]);
            }
            catch (IOException e) {
                this.log.error("Couldn't write Freemarker file", (Throwable)e);
            }
        }
    }

    private static String deleteAllCommentLines(String sql) {
        return COMMENT_LINE_SQL.matcher(sql).replaceAll("");
    }

    public void setLimitDebugStmts(int limit) {
        this.limitDebugStmts = limit;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }
}

