/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.tasklet;

import de.superx.dbt.DbtManager;
import de.superx.servlet.SuperXManager;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatStatus;

public class ExecuteDbtTasklet
implements Tasklet,
StepExecutionListener {
    static Logger logger = LoggerFactory.getLogger(ExecuteDbtTasklet.class);
    private static final long DBT_TIMEOUT_MILLISECONDS = 300000L;
    private final String dbtProject;
    private final String dbtSelect;
    private final boolean dbtTest;

    public ExecuteDbtTasklet(String dbtProject, String dbtSelect, boolean dbtTest) {
        this.dbtProject = dbtProject;
        this.dbtSelect = dbtSelect;
        this.dbtTest = dbtTest;
    }

    public void beforeStep(StepExecution stepExecution) {
        Path dbtProjectDir = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "projects", this.dbtProject, "transform");
        DbtManager manager = new DbtManager(dbtProjectDir, null);
        String pythonVersion = manager.getPythonVersion();
        logger.debug("Running with Python " + pythonVersion);
        try {
            DbtManager.checkPythonCompatability(pythonVersion);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Path dbtProjectDir = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "projects", this.dbtProject, "transform");
        try {
            DbtManager manager = new DbtManager(dbtProjectDir, this.dbtSelect, this.dbtTest);
            Thread t = new Thread(manager);
            t.start();
            long startTime = System.currentTimeMillis();
            while (t.isAlive()) {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - startTime > 300000L) {
                    manager.getProcess().destroyForcibly();
                    throw new RuntimeException("DBT run timeout!");
                }
                int processedTotal = manager.getModelCount();
                ExecutionContext context = contribution.getStepExecution().getExecutionContext();
                context.putInt("stepsInternal", processedTotal);
            }
            if (!manager.isSuccess().isPresent() || manager.isSuccess().get() == Boolean.FALSE) {
                ExitStatus exitStatus = ExitStatus.FAILED;
                List<String> errors = manager.getErrorMessages();
                for (String error : errors) {
                    exitStatus = exitStatus.addExitDescription(error);
                }
                contribution.setExitStatus(exitStatus);
            }
        }
        catch (Exception e) {
            ExitStatus exitStatus = ExitStatus.FAILED;
            exitStatus.addExitDescription(e.getMessage());
            contribution.setExitStatus(exitStatus);
        }
        return RepeatStatus.FINISHED;
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }
}

