/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.reader;

import com.zaxxer.hikari.HikariDataSource;
import de.superx.util.SqlStringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcUnloadReader<T>
extends JdbcCursorItemReader<T>
implements StepExecutionListener {
    private boolean continueOnError = true;
    private ExitStatus exitStatus = null;
    private List<String> sourceVersions;
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public JdbcUnloadReader(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public JdbcUnloadReader() {
    }

    protected void doOpen() throws Exception {
        try {
            super.doOpen();
        }
        catch (Exception e) {
            if (!this.continueOnError) {
                throw e;
            }
            this.exitStatus = ExitStatus.FAILED;
            String errorMsg = e.getMessage();
            this.logger.error(errorMsg);
            this.exitStatus = this.exitStatus.addExitDescription(errorMsg.substring(0, errorMsg.length() - 1));
        }
    }

    protected T doRead() throws Exception {
        if (this.exitStatus == null || !this.exitStatus.getExitCode().equals("FAILED")) {
            return (T)super.doRead();
        }
        return null;
    }

    public void beforeStep(StepExecution stepExecution) {
        Map unloadParams = (Map)stepExecution.getJobExecution().getExecutionContext().get("UNLOAD_PARAMS");
        if (unloadParams == null) {
            this.logger.warn("no 'UNLOAD_PARAMS' found for unload step with SQL:\n");
        } else {
            String jdbcParamSql;
            if (unloadParams.containsKey("JDBC_PARAM") && (jdbcParamSql = (String)unloadParams.get("JDBC_PARAM")) != null && !jdbcParamSql.trim().isEmpty()) {
                JdbcTemplate jt = new JdbcTemplate(this.getDataSource());
                this.logger.info("execute JDBC_PARAM: " + jdbcParamSql);
                jt.execute(jdbcParamSql);
            }
            this.setSql(SqlStringUtils.replaceAllProperties(this.getSql(), unloadParams));
        }
        this.logger.info(this.getSql());
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        try {
            String schema = this.getDataSource().unwrap(HikariDataSource.class).getSchema();
            if (schema != null) {
                String schemaSql = "SET search_path TO " + schema;
                JdbcTemplate jt = new JdbcTemplate(this.getDataSource());
                jt.execute(schemaSql);
            }
        }
        catch (SQLException e) {
            this.logger.error("Couldn't reset search_path to pool config!", (Throwable)e);
        }
        catch (Exception e) {
            this.exitStatus = ExitStatus.FAILED;
            String errorMsg = e.getMessage();
            this.logger.error(errorMsg);
            this.exitStatus = this.exitStatus.addExitDescription(errorMsg.substring(0, errorMsg.length() - 1));
        }
        return this.exitStatus;
    }

    public void setSourceVersions(String sourceVersions) {
        this.sourceVersions = sourceVersions != null ? Arrays.asList(sourceVersions.split(",")) : new ArrayList<String>();
    }
}

