/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.reader;

import de.superx.job.ExtractAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.database.JdbcCursorItemReader;

public class JdbcExtractReader<T>
extends JdbcCursorItemReader<T>
implements StepExecutionListener {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ExtractAction extractAction;
    public String dropTableStmt = "DROP TABLE IF EXISTS %s.%s;";
    public String createTableStmt = "CREATE TABLE %s.%s (%s);";
    public String selectFromTableStmt = "SELECT %s from %s WHERE %s;";
    private List<String> colsToExclude = Arrays.asList("lock_version");
    private DataSource dataSource;

    public JdbcExtractReader(ExtractAction extractAction, DataSource dataSource) {
        this.extractAction = extractAction;
        this.dataSource = dataSource;
        if (this.extractAction.extractionExclude != null && !extractAction.extractionExclude.isBlank()) {
            List<String> projection = Arrays.asList(extractAction.extractionExclude.split("\\s*,\\s*"));
            this.colsToExclude.addAll(projection);
        }
    }

    public void beforeStep(StepExecution stepExecution) {
        this.setDataSource(this.dataSource);
        String selectBody = "";
        String createBody = "";
        ArrayList<String> selectElements = new ArrayList<String>();
        ArrayList<String> createElements = new ArrayList<String>();
        try (Connection con = this.dataSource.getConnection();){
            String schema = con.getSchema();
            DatabaseMetaData dbm = con.getMetaData();
            try (ResultSet columns = dbm.getColumns(null, schema, this.extractAction.sourceTable, null);){
                while (columns.next()) {
                    String nullable;
                    String col = columns.getString("COLUMN_NAME");
                    String type = columns.getString("TYPE_NAME");
                    String string = nullable = columns.getString("IS_NULLABLE").equals("NO") ? "not null" : "";
                    if (this.colsToExclude.contains(col)) continue;
                    selectElements.add(col);
                    createElements.add(String.format("%s %s %s", col, type, nullable));
                }
                selectBody = String.join((CharSequence)", ", selectElements);
                createBody = String.join((CharSequence)", ", createElements);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (createBody.isEmpty()) {
            this.logger.warn("Unable to extract Table '" + this.extractAction.sourceTable + "' because it does not exist.");
            this.createTableStmt = "";
            this.setSql("select");
            return;
        }
        this.createTableStmt = String.format(this.dropTableStmt, this.extractAction.stagingSchema, this.extractAction.stagingTable) + String.format(this.createTableStmt, this.extractAction.stagingSchema, this.extractAction.stagingTable, createBody);
        this.selectFromTableStmt = String.format(this.selectFromTableStmt, selectBody, this.extractAction.sourceTable, this.extractAction.extractionScript);
        this.setSql(this.selectFromTableStmt);
        this.logger.info(this.getSql());
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return ExitStatus.COMPLETED;
    }
}

