/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.job;

import de.superx.rest.model.job.JobExecutionStatus;
import de.superx.rest.model.job.StepExecutionStatus;
import de.superx.spring.batch.tasklet.RemoveSpringBatchHistoryTasklet;
import de.superx.spring.batch.util.StepCounter;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class JobUtils {
    private static final String SQL_DELETE_BATCH_STEP_EXECUTION_CONTEXT = "DELETE FROM %PREFIX%STEP_EXECUTION_CONTEXT WHERE STEP_EXECUTION_ID IN (SELECT STEP_EXECUTION_ID FROM %PREFIX%STEP_EXECUTION WHERE JOB_EXECUTION_ID IN (SELECT JOB_EXECUTION_ID FROM  %PREFIX%JOB_EXECUTION where CREATE_TIME < ?))";
    private static final String SQL_DELETE_BATCH_STEP_EXECUTION = "DELETE FROM %PREFIX%STEP_EXECUTION WHERE JOB_EXECUTION_ID IN (SELECT JOB_EXECUTION_ID FROM %PREFIX%JOB_EXECUTION where CREATE_TIME < ?)";
    private static final String SQL_DELETE_BATCH_JOB_EXECUTION_CONTEXT = "DELETE FROM %PREFIX%JOB_EXECUTION_CONTEXT WHERE JOB_EXECUTION_ID IN (SELECT JOB_EXECUTION_ID FROM  %PREFIX%JOB_EXECUTION where CREATE_TIME < ?)";
    private static final String SQL_DELETE_BATCH_JOB_EXECUTION_PARAMS = "DELETE FROM %PREFIX%JOB_EXECUTION_PARAMS WHERE JOB_EXECUTION_ID IN (SELECT JOB_EXECUTION_ID FROM %PREFIX%JOB_EXECUTION where CREATE_TIME < ?)";
    private static final String SQL_DELETE_BATCH_JOB_EXECUTION = "DELETE FROM %PREFIX%JOB_EXECUTION where CREATE_TIME < ?";
    private static final String SQL_DELETE_BATCH_JOB_INSTANCE = "DELETE FROM %PREFIX%JOB_INSTANCE WHERE JOB_INSTANCE_ID NOT IN (SELECT JOB_INSTANCE_ID FROM %PREFIX%JOB_EXECUTION)";
    private static final String SQL_DELETE_JOB_LOGS = "DELETE FROM job_log WHERE job_instance_id NOT IN (SELECT job_instance_id FROM %PREFIX%job_instance)";
    private static final Logger logger = LoggerFactory.getLogger(RemoveSpringBatchHistoryTasklet.class);

    public static boolean terminateJobExecution(JobExplorer jobExplorer, JobOperator jobOperator, Long jobExecutionId) {
        JobExecution jobExecution = jobExplorer.getJobExecution(jobExecutionId);
        if (jobExecution == null || !jobExecution.isRunning()) {
            return false;
        }
        boolean stopOk = false;
        try {
            stopOk = jobOperator.stop(jobExecutionId.longValue());
        }
        catch (JobExecutionNotRunningException | NoSuchJobExecutionException e) {
            logger.warn("Couldn't stop JobExecution " + jobExecutionId);
        }
        if (!stopOk) {
            try {
                jobOperator.abandon(jobExecutionId.longValue());
            }
            catch (NoSuchJobExecutionException | JobExecutionAlreadyRunningException e) {
                logger.warn("Couldn't abandon JobExecution " + jobExecutionId);
            }
        }
        return stopOk;
    }

    public static void terminateAllJobExecutions(JobExplorer jobExplorer, JobOperator jobOperator) {
        List jobNames = jobExplorer.getJobNames();
        for (String jobName : jobNames) {
            Set jobExecutions = jobExplorer.findRunningJobExecutions(jobName);
            for (JobExecution jobExecution : jobExecutions) {
                JobUtils.terminateJobExecution(jobExplorer, jobOperator, jobExecution.getId());
            }
        }
    }

    public static int deleteJobHistoryOlderThanDays(int days, JdbcTemplate jdbcTemplate) {
        return JobUtils.deleteJobHistoryOlderThanDays(days, jdbcTemplate, "batch_");
    }

    public static int deleteJobHistoryOlderThanDays(int days, JdbcTemplate jdbcTemplate, String tablePrefix) {
        int totalCount = 0;
        Date date = DateUtils.addDays((Date)new Date(), (int)(-days));
        if (days <= 0) {
            logger.warn("Days set to 0 or less. Only deleting jobs older than 15 minutes.");
            date = DateUtils.addMinutes((Date)new Date(), (int)-15);
        }
        SimpleDateFormat df = new SimpleDateFormat();
        logger.info("Remove the Spring Batch history before the {}", (Object)df.format(date));
        int rowCount = jdbcTemplate.update(JobUtils.getQuery(SQL_DELETE_BATCH_STEP_EXECUTION_CONTEXT, tablePrefix), new Object[]{date});
        logger.info("Deleted rows number from the BATCH_STEP_EXECUTION_CONTEXT table: {}", (Object)rowCount);
        totalCount += rowCount;
        rowCount = jdbcTemplate.update(JobUtils.getQuery(SQL_DELETE_BATCH_STEP_EXECUTION, tablePrefix), new Object[]{date});
        logger.info("Deleted rows number from the BATCH_STEP_EXECUTION table: {}", (Object)rowCount);
        totalCount += rowCount;
        rowCount = jdbcTemplate.update(JobUtils.getQuery(SQL_DELETE_BATCH_JOB_EXECUTION_CONTEXT, tablePrefix), new Object[]{date});
        logger.info("Deleted rows number from the BATCH_JOB_EXECUTION_CONTEXT table: {}", (Object)rowCount);
        totalCount += rowCount;
        rowCount = jdbcTemplate.update(JobUtils.getQuery(SQL_DELETE_BATCH_JOB_EXECUTION_PARAMS, tablePrefix), new Object[]{date});
        logger.info("Deleted rows number from the BATCH_JOB_EXECUTION_PARAMS table: {}", (Object)rowCount);
        totalCount += rowCount;
        rowCount = jdbcTemplate.update(JobUtils.getQuery(SQL_DELETE_BATCH_JOB_EXECUTION, tablePrefix), new Object[]{date});
        logger.info("Deleted rows number from the BATCH_JOB_EXECUTION table: {}", (Object)rowCount);
        totalCount += rowCount;
        rowCount = jdbcTemplate.update(JobUtils.getQuery(SQL_DELETE_BATCH_JOB_INSTANCE, tablePrefix));
        logger.info("Deleted rows number from the BATCH_JOB_INSTANCE table: {}", (Object)rowCount);
        totalCount += rowCount;
        rowCount = jdbcTemplate.update(JobUtils.getQuery(SQL_DELETE_JOB_LOGS, tablePrefix));
        logger.info("Deleted rows number from the job_log table: {}", (Object)rowCount);
        return totalCount += rowCount;
    }

    protected static String getQuery(String base, String tablePrefix) {
        return StringUtils.replace((String)base, (String)"%PREFIX%", (String)tablePrefix);
    }

    public static JobExecutionStatus getJobExecutionStatus(JobExecution je, JobExplorer jobExplorer) {
        StepCounter stepCounter = new StepCounter();
        JobExecutionStatus jobExecutionStatus = new JobExecutionStatus();
        jobExecutionStatus.totalStepsCount = je.getJobParameters().getLong("countTotalSteps");
        Collection stepExecutions = je.getStepExecutions();
        ArrayList<StepExecutionStatus> stepExecutionStatus = new ArrayList<StepExecutionStatus>();
        stepExecutions.forEach(stepExecution -> stepExecutionStatus.add(new StepExecutionStatus((StepExecution)stepExecution, jobExplorer, stepCounter)));
        jobExecutionStatus.jobExecutionId = je.getId();
        jobExecutionStatus.name = je.getJobInstance().getJobName();
        jobExecutionStatus.executedStepsCount = stepCounter.getCount();
        jobExecutionStatus.exitStatus = new ExitStatus(je.getExitStatus().getExitCode());
        jobExecutionStatus.setStepExecutions(stepExecutionStatus);
        jobExecutionStatus.endTime = JobUtils.convertLocalDateToDate(je.getEndTime());
        jobExecutionStatus.startTime = JobUtils.convertLocalDateToDate(je.getStartTime());
        return jobExecutionStatus;
    }

    public static Properties jobParametersToProperties(JobParameters jobParameters) {
        Properties props = new Properties();
        for (Map.Entry entry : jobParameters.getParameters().entrySet()) {
            props.put(entry.getKey(), ((JobParameter)entry.getValue()).getValue().toString());
        }
        return props;
    }

    public static Date convertLocalDateToDate(LocalDateTime localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(localDate.atZone(ZoneId.systemDefault()).toInstant());
    }
}

