/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.job;

import de.superx.job.ContainerNode;
import de.superx.rest.EtlJobApi;
import de.superx.spring.batch.util.StepCounter;
import javax.sql.DataSource;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class BiQuartzBatchJob
extends QuartzJobBean {
    private static Logger logger = LoggerFactory.getLogger(BiQuartzBatchJob.class);
    String jobName;

    protected void executeInternal(JobExecutionContext context) {
        try {
            Job job;
            EtlJobApi api;
            JobLauncher jobLauncher;
            block6: {
                SchedulerContext schedulerContext = context.getScheduler().getContext();
                JobLocator jobLocator = (JobLocator)schedulerContext.get((Object)"jobLocator");
                jobLauncher = (JobLauncher)schedulerContext.get((Object)"jobLauncher");
                DataSource dataSource = (DataSource)schedulerContext.get((Object)"dataSource");
                api = (EtlJobApi)schedulerContext.get((Object)"api");
                job = null;
                try {
                    if (jobLocator == null) {
                        throw new NoSuchJobException(this.jobName);
                    }
                    job = jobLocator.getJob(this.jobName);
                    logger.info("Found job " + this.jobName + " via JobLocator.");
                }
                catch (NoSuchJobException nsje) {
                    ContainerNode jobNode = api.getJob(this.jobName);
                    if (jobNode == null) break block6;
                    logger.info("Found job " + this.jobName + " via EtlJobApi.");
                    job = api.createBatchJob(jobNode, this.jobName, new StepCounter());
                }
            }
            if (job == null) {
                logger.error("Couldn't find job " + this.jobName);
                return;
            }
            StepCounter stepCounter = new StepCounter();
            api.startJob(job, stepCounter.getCount(), null, jobLauncher);
        }
        catch (Exception e) {
            logger.error("Problem executing job " + this.jobName, (Throwable)e);
        }
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public static void scheduleJob(Scheduler scheduler, String batchJobName, JobKey jobKey, JobDataMap jobDataMap, ScheduleBuilder<?> schedule, boolean startNow) {
        try {
            if (scheduler.checkExists(jobKey)) {
                logger.info(jobKey + " already scheduled. Deleting Job.");
                scheduler.deleteJob(jobKey);
            }
            jobDataMap.put("jobName", batchJobName);
            JobDetail job = JobBuilder.newJob(BiQuartzBatchJob.class).withIdentity(jobKey).setJobData(jobDataMap).storeDurably().build();
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(jobKey.getName() + " Trigger", jobKey.getGroup() + " Triggers");
            if (startNow) {
                triggerBuilder = triggerBuilder.startNow();
            }
            Trigger trigger = triggerBuilder.withSchedule(schedule).build();
            scheduler.scheduleJob(job, trigger);
            logger.info("Job " + jobKey + " successfully scheduled.");
        }
        catch (SchedulerException e) {
            logger.error("Couldn't schedule job " + jobKey, (Throwable)e);
        }
    }
}

