/*
 * Decompiled with CFR 0.152.
 */
package de.superx.spring.batch.job;

import de.superx.job.ContainerNode;
import de.superx.spring.batch.job.EtlJobLoggingFilter;
import de.superx.util.PathAndFileUtils;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.Filter;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;

public class BiJobLoggingListener
implements JobExecutionListener {
    static Logger logger = Logger.getLogger(BiJobLoggingListener.class);
    private static final String BATCH_JOB_FILE_APPENDER = "BATCH_JOB_FILE_APPENDER";
    private static final String BATCH_JOB_STRING_APPENDER = "BATCH_JOB_STRING_APPENDER";
    private static final List<String> loggerNames = List.of(new String[]{"de.superx.spring.batch", "de.superx.dbt.DbtManager", "de.superx.bin.fm.EtlStarter", "de.superx.spring.service.BatchJobDescriptionAdapter", "org.springframework.batch.core.job", "org.springframework.jdbc.datasource.init.ScriptUtils"});
    private static final Level logLevel = Level.DEBUG;
    private static final PatternLayout PATTERN_SHORT = new PatternLayout("%d{HH:mm:ss,SSS} [%p|%c{1}] %m%n");
    private static final PatternLayout PATTERN_LONG = new PatternLayout("%d [%p|%c{1}] %m%n");
    private File logFile;
    private StringWriter logWriter;
    private String jobName;

    public BiJobLoggingListener(String jobName, ContainerNode.JobSource jobSource) {
        this.jobName = jobName;
        this.logWriter = this.createLogger();
        String readFrom = String.format("Job %s was read from %s\n", new Object[]{jobName, jobSource});
        logger.info((Object)readFrom);
        logger.info((Object)("*".repeat(readFrom.length() - 1) + "\n"));
    }

    public void beforeJob(JobExecution jobExecution) {
    }

    public void afterJob(JobExecution jobExecution) {
        BiJobLoggingListener.removeLogger();
    }

    public String getNextLogSection() {
        if (this.logWriter == null) {
            return "";
        }
        this.logWriter.flush();
        int logWriterNextPos = this.logWriter.getBuffer().length();
        String logSection = this.logWriter.getBuffer().substring(0, logWriterNextPos);
        this.logWriter.getBuffer().delete(0, logWriterNextPos);
        return logSection;
    }

    private StringWriter createLogger() {
        String jobFileName = StringUtils.remove((String)StringUtils.replaceChars((String)this.jobName, (String)" /", (String)"_-"), (String)",");
        StringWriter stringWriter = new StringWriter();
        WriterAppender writer = new WriterAppender((Layout)PATTERN_SHORT, (Writer)stringWriter);
        writer.setName(BATCH_JOB_STRING_APPENDER);
        writer.setThreshold((Priority)logLevel);
        writer.addFilter((Filter)new EtlJobLoggingFilter());
        writer.activateOptions();
        FileAppender fa = new FileAppender();
        fa.setName(BATCH_JOB_FILE_APPENDER);
        String logdir = PathAndFileUtils.getWebinfPath() + File.separator + "logs" + File.separator + "jobs" + File.separator;
        String logFilePath = logdir + jobFileName + ".log";
        fa.setFile(logFilePath);
        fa.setLayout((Layout)PATTERN_LONG);
        fa.setThreshold((Priority)logLevel);
        fa.setAppend(false);
        fa.addFilter((Filter)new EtlJobLoggingFilter());
        fa.activateOptions();
        for (String loggerName : loggerNames) {
            Logger batchLogger = Logger.getLogger((String)loggerName);
            batchLogger.addAppender((Appender)fa);
            batchLogger.addAppender((Appender)writer);
            batchLogger.setAdditivity(false);
            batchLogger.setLevel(logLevel);
        }
        this.logFile = new File(logFilePath);
        return stringWriter;
    }

    public File getLogFile() {
        return this.logFile;
    }

    private static void removeLogger() {
        for (String loggerName : loggerNames) {
            Logger batchLogger = Logger.getLogger((String)loggerName);
            batchLogger.removeAppender(BATCH_JOB_FILE_APPENDER);
            batchLogger.removeAppender(BATCH_JOB_STRING_APPENDER);
            batchLogger.setAdditivity(true);
            batchLogger.setLevel(null);
        }
    }
}

